/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.ArrayList;
import java.util.List;

class MergedData {
    private final Declaration declaration;
    private final Expression importance;
    private ListExpressionOperator.Operator operator;
    private List<Expression> mergedExpressions = new ArrayList<Expression>();

    public MergedData(Declaration declaration, Expression importance) {
        this.declaration = declaration;
        this.importance = importance;
        this.operator = declaration.getMergeOperator();
    }

    public void replaceExpressions(Expression expression) {
        this.mergedExpressions = new ArrayList<Expression>();
        this.mergedExpressions.add(expression);
    }

    public Expression mergeExpressions() {
        HiddenTokenAwareTree underlying = this.declaration.getUnderlyingStructure();
        List<Expression> expressions = this.getMergedExpressions();
        if (expressions.size() == 1) {
            return expressions.get(0);
        }
        ListExpressionOperator.Operator mergeOperator = this.getOperator();
        ListExpression result = new ListExpression(underlying, expressions, new ListExpressionOperator(underlying, mergeOperator));
        result.configureParentToAllChilds();
        return result;
    }

    public boolean isImportant() {
        return this.importance != null;
    }

    public void add(Expression expression) {
        this.mergedExpressions.add(expression);
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public Expression getImportance() {
        return this.importance;
    }

    public ListExpressionOperator.Operator getOperator() {
        return this.operator;
    }

    public void setOperator(ListExpressionOperator.Operator operator) {
        this.operator = operator;
    }

    public List<Expression> getMergedExpressions() {
        return this.mergedExpressions;
    }
}

