/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.Collections;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.TypeRule;
import org.exoplatform.commons.api.persistence.GenericDAO;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RuleDAO
extends GenericDAOJPAImpl<RuleEntity, Long>
implements GenericDAO<RuleEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(RuleDAO.class);

    public RuleEntity findEnableRuleByTitle(String ruleTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findEnabledRuleByTitle", RuleEntity.class).setParameter("ruleTitle", (Object)ruleTitle);
        query.setParameter("type", (Object)TypeRule.AUTOMATIC);
        try {
            List ruleEntities = query.getResultList();
            return !ruleEntities.isEmpty() ? (RuleEntity)ruleEntities.get(0) : null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> findEnabledRulesByEvent(String event) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findEnabledRulesByEvent", RuleEntity.class).setParameter("event", (Object)event);
        query.setParameter("type", (Object)TypeRule.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public RuleEntity findRuleByTitle(String ruleTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findRuleByTitle", RuleEntity.class);
        query.setParameter("ruleTitle", (Object)ruleTitle);
        query.setParameter("type", (Object)TypeRule.AUTOMATIC);
        try {
            List ruleEntities = query.getResultList();
            return !ruleEntities.isEmpty() ? (RuleEntity)ruleEntities.get(0) : null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public RuleEntity findRuleByEventAndDomain(String event, String domain) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findRuleByEventAndDomain", RuleEntity.class).setParameter("event", (Object)event).setParameter("domain", (Object)domain);
        query.setParameter("type", (Object)TypeRule.AUTOMATIC);
        try {
            List ruleEntities = query.getResultList();
            return !ruleEntities.isEmpty() ? (RuleEntity)ruleEntities.get(0) : null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> getAllAutomaticRules() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllAutomaticRules", RuleEntity.class);
        query.setParameter("type", (Object)TypeRule.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> getAllRules() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllRules", RuleEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> getActiveRules() {
        try {
            TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getEnabledRules", RuleEntity.class).setParameter("isEnabled", (Object)true);
            query.setParameter("type", (Object)TypeRule.AUTOMATIC);
            return query.getResultList();
        }
        catch (PersistenceException e) {
            LOG.error((Object)"Error : Unable to fetch active rules", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<RuleEntity> getAllRulesByDomain(String domain) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllRulesByDomain", RuleEntity.class).setParameter("domain", (Object)domain);
        query.setParameter("type", (Object)TypeRule.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> getAllRulesWithNullDomain() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getAllRulesWithNullDomain", RuleEntity.class);
        query.setParameter("type", (Object)TypeRule.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<String> getDomainList() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getDomainList", String.class);
        query.setParameter("type", (Object)TypeRule.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<String> getAllEvents() throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getEventList", String.class);
        query.setParameter("type", (Object)TypeRule.AUTOMATIC);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<RuleEntity> findAllChallengesByUser(int offset, int limit, List<Long> ids) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findAllChallengesByUser", RuleEntity.class);
        query.setParameter("ids", ids);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }
}

