/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.operation.TransformException;

public abstract class GeometryTransform {
    private final GeometryFactory geometryFactory;
    protected final CoordinateSequenceFactory coordinateFactory;

    protected GeometryTransform(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.coordinateFactory = geometryFactory.getCoordinateSequenceFactory();
    }

    public Geometry transform(Geometry geometry) throws TransformException {
        if (geometry instanceof Point) {
            return this.transform((Point)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return this.transform((MultiPoint)geometry);
        }
        if (geometry instanceof LinearRing) {
            return this.transform((LinearRing)geometry);
        }
        if (geometry instanceof LineString) {
            return this.transform((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.transform((MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.transform((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.transform((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.transform((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException(Errors.format((short)163, (Object)Classes.getClass((Object)geometry)));
    }

    public Point transform(Point point) throws TransformException {
        CoordinateSequence coordinateSequence = point.getCoordinateSequence();
        return this.geometryFactory.createPoint(this.transform(coordinateSequence, 1));
    }

    public MultiPoint transform(MultiPoint multiPoint) throws TransformException {
        Point[] pointArray = new Point[multiPoint.getNumGeometries()];
        for (int i = 0; i < pointArray.length; ++i) {
            pointArray[i] = this.transform((Point)multiPoint.getGeometryN(i));
        }
        return this.geometryFactory.createMultiPoint(pointArray);
    }

    public LineString transform(LineString lineString) throws TransformException {
        CoordinateSequence coordinateSequence = this.transform(lineString.getCoordinateSequence(), 2);
        return this.geometryFactory.createLineString(coordinateSequence);
    }

    public MultiLineString transform(MultiLineString multiLineString) throws TransformException {
        LineString[] lineStringArray = new LineString[multiLineString.getNumGeometries()];
        for (int i = 0; i < lineStringArray.length; ++i) {
            lineStringArray[i] = this.transform((LineString)multiLineString.getGeometryN(i));
        }
        return this.geometryFactory.createMultiLineString(lineStringArray);
    }

    public LinearRing transform(LinearRing linearRing) throws TransformException {
        CoordinateSequence coordinateSequence = this.transform(linearRing.getCoordinateSequence(), 4);
        return this.geometryFactory.createLinearRing(coordinateSequence);
    }

    public Polygon transform(Polygon polygon) throws TransformException {
        LinearRing linearRing = this.transform((LinearRing)polygon.getExteriorRing());
        LinearRing[] linearRingArray = new LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < linearRingArray.length; ++i) {
            linearRingArray[i] = this.transform((LinearRing)polygon.getInteriorRingN(i));
        }
        return this.geometryFactory.createPolygon(linearRing, linearRingArray);
    }

    public MultiPolygon transform(MultiPolygon multiPolygon) throws TransformException {
        Polygon[] polygonArray = new Polygon[multiPolygon.getNumGeometries()];
        for (int i = 0; i < polygonArray.length; ++i) {
            polygonArray[i] = this.transform((Polygon)multiPolygon.getGeometryN(i));
        }
        return this.geometryFactory.createMultiPolygon(polygonArray);
    }

    public GeometryCollection transform(GeometryCollection geometryCollection) throws TransformException {
        Geometry[] geometryArray = new Geometry[geometryCollection.getNumGeometries()];
        for (int i = 0; i < geometryArray.length; ++i) {
            geometryArray[i] = this.transform(geometryCollection.getGeometryN(i));
        }
        return this.geometryFactory.createGeometryCollection(geometryArray);
    }

    protected abstract CoordinateSequence transform(CoordinateSequence var1, int var2) throws TransformException;
}

