/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Task;

@Entity(name="TaskStatus")
@ExoEntity
@Table(name="TASK_STATUS")
@NamedQueries(value={@NamedQuery(name="Status.findLowestRankStatusByProject", query="SELECT s FROM TaskStatus s WHERE s.project.id = :projectId AND s.rank = (SELECT MIN(s2.rank) FROM TaskStatus s2 WHERE s2.project.id = :projectId)"), @NamedQuery(name="Status.findHighestRankStatusByProject", query="SELECT s FROM TaskStatus s WHERE s.project.id = :projectId AND s.rank = (SELECT MAX(s2.rank) FROM TaskStatus s2 WHERE s2.project.id = :projectId)"), @NamedQuery(name="Status.findByName", query="SELECT s FROM TaskStatus s WHERE s.name = :name AND s.project.id = :projectID"), @NamedQuery(name="Status.findStatusByProject", query="SELECT s FROM TaskStatus s WHERE s.project.id = :projectId ORDER BY s.rank ASC")})
public class Status
implements Comparable<Status> {
    @Id
    @SequenceGenerator(name="SEQ_TASK_STATUS_STATUS_ID", sequenceName="SEQ_TASK_STATUS_STATUS_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_STATUS_STATUS_ID")
    @Column(name="STATUS_ID")
    private long id;
    private String name;
    @Column(name="STATUS_RANK")
    private Integer rank;
    @OneToMany(mappedBy="status", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private List<Task> tasks = new ArrayList<Task>();
    @ManyToOne
    @JoinColumn(name="PROJECT_ID")
    private Project project;

    public Status() {
    }

    public Status(long id, String name) {
        this.id = id;
        this.name = name;
    }

    public Status(long id, String name, Integer rank, Project project) {
        this.id = id;
        this.name = name;
        this.rank = rank;
        this.project = project;
    }

    public Status(String name, Integer rank, Project project) {
        this.name = name;
        this.rank = rank;
        this.project = project;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Status clone() {
        Status status = new Status(this.getId(), this.getName(), this.getRank(), this.getProject().clone(false));
        return status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        if (this.id != status.id) {
            return false;
        }
        if (this.name != null ? !this.name.equals(status.name) : status.name != null) {
            return false;
        }
        if (this.project != null ? !this.project.equals(status.project) : status.project != null) {
            return false;
        }
        return !(this.rank != null ? !this.rank.equals(status.rank) : status.rank != null);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.rank, this.project);
    }

    @Override
    public int compareTo(Status o) {
        if (this.getRank() == null) {
            return o.getRank() == null ? 0 : -1;
        }
        if (o.getRank() == null) {
            return 1;
        }
        return this.getRank().compareTo(o.getRank());
    }
}

