/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.cssfile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.cssfile.CssClassIconFile;
import org.exoplatform.webui.cssfile.CssClassPlugin;
import org.exoplatform.webui.cssfile.CssClassUtils;
import org.picocontainer.Startable;

public class CssClassManager
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(CssClassManager.class);
    private static final String UI_ICON = "uiIcon";
    public static final String DEFAULT_CSS_ICON_FILE = "nt_file";
    private List<CssClassPlugin> plugins = new ArrayList<CssClassPlugin>();
    private Map<String, CssClassIconFile> cssClassIconFileData = new HashMap<String, CssClassIconFile>();
    private String dataJsonIconFileType = null;

    public CssClassManager(InitParams params) {
    }

    public void start() {
        try {
            LOG.info((Object)"initializing CSS class icon files...");
            this.initCssClassIconFile();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while initializing CSS class icon files: " + e.getMessage()));
        }
    }

    public void stop() {
    }

    public void registerCssClassPlugin(CssClassPlugin classPlugin) {
        this.plugins.add(classPlugin);
    }

    public void initCssClassIconFile() {
        this.cssClassIconFileData.put("default", CssClassIconFile.getDefault());
        for (CssClassPlugin cssClassPlugin : this.plugins) {
            for (CssClassIconFile cssClass : cssClassPlugin.getCssClassIconFile()) {
                this.cssClassIconFileData.put(cssClass.getType(), cssClass);
            }
        }
    }

    public String getCSSClassByFileType(String fileType, ICON_SIZE size) {
        Collection<CssClassIconFile> classIconFiles = this.cssClassIconFileData.values();
        for (CssClassIconFile cssFile : classIconFiles) {
            if (!cssFile.containInGroupFileTypes(fileType)) continue;
            return CssClassManager.buildCssClass(cssFile, size);
        }
        return CssClassManager.buildCssClass(null, size);
    }

    public String getCSSClassByFileName(String fileName, ICON_SIZE size) {
        String fileExtension = CssClassUtils.getFileExtension(fileName);
        CssClassIconFile cssFile = this.cssClassIconFileData.get(fileExtension);
        if (cssFile == null || cssFile.equals(CssClassIconFile.getDefault())) {
            String fileType = new StringBuffer("File").append(fileExtension.substring(0, 1).toUpperCase()).append(fileExtension.substring(1).toLowerCase()).toString();
            return this.getCSSClassByFileType(fileType, size);
        }
        return CssClassManager.buildCssClass(cssFile, size);
    }

    private static String buildCssClass(CssClassIconFile cssFile, ICON_SIZE size) {
        if (cssFile == null) {
            cssFile = CssClassIconFile.getDefault();
        }
        if (size == null) {
            size = ICON_SIZE.ICON_16;
        }
        return String.format("%s%s%s %s%s%s", UI_ICON, size.getName(), cssFile.getCssClass(), UI_ICON, size.getName(), DEFAULT_CSS_ICON_FILE);
    }

    public String getClassIconJsonData() {
        if (this.dataJsonIconFileType == null) {
            this.dataJsonIconFileType = this.cssClassIconFileData.values().toString();
        }
        return this.dataJsonIconFileType;
    }

    public static enum ICON_SIZE {
        ICON_16("16x16"),
        ICON_24("24x24"),
        ICON_48("48x48"),
        ICON_64("64x64");

        private final String name;

        private ICON_SIZE(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

