/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.DefinitionVerifier;
import org.apache.sis.internal.referencing.EllipsoidalHeightCombiner;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.EllipsoidalHeightSeparator;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class CRS
extends Static {
    private CRS() {
    }

    public static CoordinateReferenceSystem forCode(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)string);
        try {
            return AuthorityFactories.ALL.createCoordinateReferenceSystem(string);
        }
        catch (UnavailableFactoryException unavailableFactoryException) {
            return AuthorityFactories.fallback(unavailableFactoryException).createCoordinateReferenceSystem(string);
        }
    }

    public static CoordinateReferenceSystem fromWKT(String string) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"text", (Object)string);
        CoordinateReferenceSystem coordinateReferenceSystem = ((CRSFactory)DefaultFactories.forBuildin(CRSFactory.class)).createFromWKT(string);
        DefinitionVerifier.withAuthority(coordinateReferenceSystem, "org.apache.sis.io.wkt", CRS.class, "fromWKT");
        return coordinateReferenceSystem;
    }

    public static CoordinateReferenceSystem fromXML(String string) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"text", (Object)string);
        CoordinateReferenceSystem coordinateReferenceSystem = ((CRSFactory)DefaultFactories.forBuildin(CRSFactory.class)).createFromXML(string);
        DefinitionVerifier.withAuthority(coordinateReferenceSystem, "org.apache.sis.xml", CRS.class, "fromXML");
        return coordinateReferenceSystem;
    }

    public static CoordinateReferenceSystem fromAuthority(CoordinateReferenceSystem coordinateReferenceSystem, CRSAuthorityFactory cRSAuthorityFactory, Filter filter) throws FactoryException {
        DefinitionVerifier definitionVerifier;
        if (coordinateReferenceSystem != null && (definitionVerifier = DefinitionVerifier.withAuthority(coordinateReferenceSystem, cRSAuthorityFactory, true)) != null) {
            LogRecord logRecord;
            coordinateReferenceSystem = definitionVerifier.authoritative;
            if (filter != null && (logRecord = definitionVerifier.warning(false)) != null) {
                logRecord.setLoggerName("org.apache.sis.referencing");
                logRecord.setSourceClassName(CRS.class.getName());
                logRecord.setSourceMethodName("fromAuthority");
                if (filter.isLoggable(logRecord)) {
                    Logging.getLogger((String)"org.apache.sis.referencing").log(logRecord);
                }
            }
        }
        return coordinateReferenceSystem;
    }

    @Deprecated
    public static CoordinateReferenceSystem fromAuthority(CoordinateReferenceSystem coordinateReferenceSystem, CRSAuthorityFactory cRSAuthorityFactory, WarningListener<?> warningListener) throws FactoryException {
        return CRS.fromAuthority(coordinateReferenceSystem, cRSAuthorityFactory, warningListener != null ? warningListener.asFilter() : null);
    }

    public static CoordinateReferenceSystem suggestCommonTarget(GeographicBoundingBox geographicBoundingBox, CoordinateReferenceSystem ... coordinateReferenceSystemArray) {
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        boolean bl = false;
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
        GeographicBoundingBox[] geographicBoundingBoxArray = new GeographicBoundingBox[coordinateReferenceSystemArray.length];
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateReferenceSystemArray[i];
            GeographicBoundingBox geographicBoundingBox2 = CRS.getGeographicBoundingBox(coordinateReferenceSystem2);
            if (geographicBoundingBox2 == null) {
                if (!(coordinateReferenceSystem2 instanceof GeodeticCRS)) {
                    return null;
                }
                coordinateReferenceSystem = coordinateReferenceSystem2;
                bl = true;
                continue;
            }
            geographicBoundingBoxArray[i] = geographicBoundingBox2;
            if (bl) continue;
            if (defaultGeographicBoundingBox == null) {
                defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(geographicBoundingBox2);
                continue;
            }
            defaultGeographicBoundingBox.add(geographicBoundingBox2);
        }
        if (defaultGeographicBoundingBox != null && !bl) {
            if (geographicBoundingBox != null) {
                defaultGeographicBoundingBox.intersect(geographicBoundingBox);
            }
            geographicBoundingBox = defaultGeographicBoundingBox;
            defaultGeographicBoundingBox = null;
        }
        double d = Extents.area((GeographicBoundingBox)geographicBoundingBox);
        double d2 = 0.0;
        double d3 = Double.POSITIVE_INFINITY;
        boolean bl2 = false;
        do {
            for (int i = 0; i < geographicBoundingBoxArray.length; ++i) {
                GeographicBoundingBox geographicBoundingBox3 = geographicBoundingBoxArray[i];
                if (geographicBoundingBox3 == null) continue;
                double d4 = Extents.area((GeographicBoundingBox)geographicBoundingBox3);
                double d5 = 0.0;
                if (geographicBoundingBox != null) {
                    if (defaultGeographicBoundingBox == null) {
                        defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(geographicBoundingBox3);
                    } else {
                        defaultGeographicBoundingBox.setBounds(geographicBoundingBox3);
                    }
                    defaultGeographicBoundingBox.intersect(geographicBoundingBox);
                    double d6 = d4;
                    d4 = Extents.area((GeographicBoundingBox)defaultGeographicBoundingBox);
                    d5 = d6 - d4;
                }
                if (!(d4 > d2) && (d4 != d2 || !(d5 < d3))) continue;
                d2 = d4;
                d3 = d5;
                coordinateReferenceSystem = coordinateReferenceSystemArray[i];
            }
            if (!(d2 < d) || bl2) break;
            CoordinateReferenceSystem[] coordinateReferenceSystemArray2 = new CoordinateReferenceSystem[coordinateReferenceSystemArray.length];
            for (int i = 0; i < coordinateReferenceSystemArray2.length; ++i) {
                GeographicBoundingBox geographicBoundingBox4 = null;
                CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateReferenceSystemArray[i];
                if (coordinateReferenceSystem3 instanceof GeneralDerivedCRS) {
                    CoordinateReferenceSystem coordinateReferenceSystem4 = ((GeneralDerivedCRS)coordinateReferenceSystem3).getBaseCRS();
                    geographicBoundingBox4 = CRS.getGeographicBoundingBox(coordinateReferenceSystem4);
                    if (geographicBoundingBox4 == null && coordinateReferenceSystem == null && coordinateReferenceSystem4 instanceof GeodeticCRS) {
                        coordinateReferenceSystem = coordinateReferenceSystem4;
                    }
                    bl2 = true;
                    coordinateReferenceSystemArray2[i] = coordinateReferenceSystem4;
                }
                geographicBoundingBoxArray[i] = geographicBoundingBox4;
            }
            coordinateReferenceSystemArray = coordinateReferenceSystemArray2;
        } while (bl2);
        return coordinateReferenceSystem;
    }

    public static CoordinateOperation findOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, GeographicBoundingBox geographicBoundingBox) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)coordinateReferenceSystem2);
        CoordinateOperationContext coordinateOperationContext = CoordinateOperationContext.fromBoundingBox(geographicBoundingBox);
        DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = CoordinateOperations.factory();
        try {
            return defaultCoordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2, coordinateOperationContext);
        }
        catch (UnavailableFactoryException unavailableFactoryException) {
            if (AuthorityFactories.failure(unavailableFactoryException)) {
                throw unavailableFactoryException;
            }
            try {
                return defaultCoordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2, coordinateOperationContext);
            }
            catch (FactoryException factoryException) {
                factoryException.addSuppressed((Throwable)((Object)unavailableFactoryException));
                throw factoryException;
            }
        }
    }

    public static List<CoordinateOperation> findOperations(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, GeographicBoundingBox geographicBoundingBox) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)coordinateReferenceSystem2);
        CoordinateOperationContext coordinateOperationContext = CoordinateOperationContext.fromBoundingBox(geographicBoundingBox);
        DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = CoordinateOperations.factory();
        try {
            return defaultCoordinateOperationFactory.createOperations(coordinateReferenceSystem, coordinateReferenceSystem2, coordinateOperationContext);
        }
        catch (UnavailableFactoryException unavailableFactoryException) {
            if (AuthorityFactories.failure(unavailableFactoryException)) {
                throw unavailableFactoryException;
            }
            try {
                return Collections.singletonList(defaultCoordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2, coordinateOperationContext));
            }
            catch (FactoryException factoryException) {
                factoryException.addSuppressed((Throwable)((Object)unavailableFactoryException));
                throw factoryException;
            }
        }
    }

    public static double getLinearAccuracy(CoordinateOperation coordinateOperation) {
        if (coordinateOperation == null) {
            return Double.NaN;
        }
        if (coordinateOperation instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)coordinateOperation).getLinearAccuracy();
        }
        return PositionalAccuracyConstant.getLinearAccuracy(coordinateOperation);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateOperation coordinateOperation) {
        if (coordinateOperation == null) {
            return null;
        }
        GeographicBoundingBox geographicBoundingBox = Extents.getGeographicBoundingBox((Extent)coordinateOperation.getDomainOfValidity());
        if (geographicBoundingBox == null) {
            geographicBoundingBox = Extents.intersection((GeographicBoundingBox)CRS.getGeographicBoundingBox(coordinateOperation.getSourceCRS()), (GeographicBoundingBox)CRS.getGeographicBoundingBox(coordinateOperation.getTargetCRS()));
        }
        return geographicBoundingBox;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem coordinateReferenceSystem) {
        return coordinateReferenceSystem != null ? Extents.getGeographicBoundingBox((Extent)coordinateReferenceSystem.getDomainOfValidity()) : null;
    }

    public static Envelope getDomainOfValidity(CoordinateReferenceSystem coordinateReferenceSystem) {
        SingleCRS singleCRS;
        GeographicCRS geographicCRS;
        GeneralEnvelope generalEnvelope = null;
        GeneralEnvelope generalEnvelope2 = null;
        GeographicBoundingBox geographicBoundingBox = CRS.getGeographicBoundingBox(coordinateReferenceSystem);
        if (geographicBoundingBox != null && !Boolean.FALSE.equals(geographicBoundingBox.getInclusion()) && (geographicCRS = ReferencingUtilities.toNormalizedGeographicCRS((CoordinateReferenceSystem)(singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem)), false, false)) != null) {
            generalEnvelope = generalEnvelope2 = new GeneralEnvelope(geographicBoundingBox);
            generalEnvelope2.translate(-CRS.getGreenwichLongitude((GeodeticCRS)geographicCRS), 0.0);
            generalEnvelope2.setCoordinateReferenceSystem((CoordinateReferenceSystem)geographicCRS);
            try {
                generalEnvelope = Envelopes.transform(generalEnvelope, (CoordinateReferenceSystem)singleCRS);
            }
            catch (TransformException transformException) {
                CRS.unexpectedException("getEnvelope", (Exception)((Object)transformException));
                generalEnvelope = null;
            }
        }
        return generalEnvelope;
    }

    public static CoordinateReferenceSystem compound(CoordinateReferenceSystem ... coordinateReferenceSystemArray) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"components", (Object)coordinateReferenceSystemArray);
        switch (coordinateReferenceSystemArray.length) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((short)29, (Object)"components"));
            }
            case 1: {
                CoordinateReferenceSystem coordinateReferenceSystem = coordinateReferenceSystemArray[0];
                if (coordinateReferenceSystem == null) break;
                return coordinateReferenceSystem;
            }
        }
        return new EllipsoidalHeightCombiner().createCompoundCRS(coordinateReferenceSystemArray);
    }

    public static CoordinateReferenceSystem reduce(CoordinateReferenceSystem coordinateReferenceSystem, int ... nArray) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"dimensions", (Object)nArray);
        if (coordinateReferenceSystem == null) {
            return null;
        }
        int n = ReferencingUtilities.getDimension(coordinateReferenceSystem);
        long l = 0L;
        for (int n2 : nArray) {
            if (n2 < 0 || n2 >= n) {
                throw new IndexOutOfBoundsException(Errors.format((short)71, (Object)n2));
            }
            if (n2 >= 64) {
                throw new IllegalArgumentException(Errors.format((short)37, (Object)n2));
            }
            l |= 1L << n2;
        }
        if (l == 0L) {
            throw new IllegalArgumentException(Errors.format((short)29, (Object)"dimensions"));
        }
        Object object = new ArrayList(Long.bitCount(l));
        CRS.reduce(0, coordinateReferenceSystem, n, l, (List<CoordinateReferenceSystem>)object);
        return CRS.compound(object.toArray(new CoordinateReferenceSystem[object.size()]));
    }

    private static long reduce(int n, CoordinateReferenceSystem coordinateReferenceSystem, int n2, long l, List<CoordinateReferenceSystem> list) throws FactoryException {
        long l2 = Numerics.bitmask((int)n2) - 1L << n;
        long l3 = l & l2;
        if (l3 != 0L) {
            Datum datum;
            if (l3 == l2) {
                list.add(coordinateReferenceSystem);
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (coordinateReferenceSystem instanceof CompoundCRS) {
                CoordinateReferenceSystem coordinateReferenceSystem2;
                Iterator iterator = ((CompoundCRS)coordinateReferenceSystem).getComponents().iterator();
                while (iterator.hasNext() && ((l = CRS.reduce(n, coordinateReferenceSystem2 = (CoordinateReferenceSystem)iterator.next(), n2 = ReferencingUtilities.getDimension(coordinateReferenceSystem2), l, list)) & l2) != 0L) {
                    n += n2;
                }
            } else if (n2 == 3 && coordinateReferenceSystem instanceof SingleCRS && (datum = ((SingleCRS)coordinateReferenceSystem).getDatum()) instanceof GeodeticDatum) {
                boolean bl = Long.bitCount(l3) == 1;
                int n3 = Long.numberOfTrailingZeros((bl ? l3 : l3 ^ 0xFFFFFFFFFFFFFFFFL) >>> n);
                CoordinateSystemAxis coordinateSystemAxis = coordinateReferenceSystem.getCoordinateSystem().getAxis(n3);
                if (AxisDirections.isVertical(coordinateSystemAxis.getDirection())) {
                    try {
                        list.add((CoordinateReferenceSystem)new EllipsoidalHeightSeparator((GeodeticDatum)datum).separate((SingleCRS)coordinateReferenceSystem, bl));
                        l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    catch (ClassCastException | IllegalArgumentException runtimeException) {
                        throw new FactoryException(Resources.format((short)84, coordinateReferenceSystem.getName()));
                    }
                }
            }
        }
        if ((l & l2) != 0L) {
            throw new FactoryException(Resources.format((short)84, coordinateReferenceSystem.getName()));
        }
        return l;
    }

    public static boolean isHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        return CRS.horizontalCode(coordinateReferenceSystem) == 2;
    }

    private static int horizontalCode(CoordinateReferenceSystem coordinateReferenceSystem) {
        CoordinateSystem coordinateSystem;
        int n;
        boolean bl = false;
        boolean bl2 = coordinateReferenceSystem instanceof GeodeticCRS;
        if ((bl2 || coordinateReferenceSystem instanceof ProjectedCRS || (bl = coordinateReferenceSystem instanceof EngineeringCRS)) && ((n = (coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()).getDimension()) & 0xFFFFFFFE) == 2 && (!bl2 || coordinateSystem instanceof EllipsoidalCS)) {
            if (bl) {
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    if (!AxisDirections.isCompass(coordinateSystem.getAxis(i).getDirection())) continue;
                    ++n2;
                }
                if (n2 != 2) {
                    return 0;
                }
            }
            return n;
        }
        return 0;
    }

    public static SingleCRS getHorizontalComponent(CoordinateReferenceSystem coordinateReferenceSystem) {
        CompoundCRS compoundCRS;
        switch (CRS.horizontalCode(coordinateReferenceSystem)) {
            case 2: {
                return (SingleCRS)coordinateReferenceSystem;
            }
            case 3: {
                compoundCRS = CoordinateSystems.replaceAxes(coordinateReferenceSystem.getCoordinateSystem(), new AxisFilter(){

                    @Override
                    public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
                        return !AxisDirections.isVertical(coordinateSystemAxis.getDirection());
                    }
                });
                if (compoundCRS.getDimension() != 2) break;
                Map<String, ?> map = ReferencingUtilities.getPropertiesForModifiedCRS((IdentifiedObject)coordinateReferenceSystem);
                if (coordinateReferenceSystem instanceof GeodeticCRS) {
                    return new DefaultGeographicCRS(map, ((GeodeticCRS)coordinateReferenceSystem).getDatum(), (EllipsoidalCS)compoundCRS);
                }
                if (coordinateReferenceSystem instanceof ProjectedCRS) {
                    ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem;
                    GeographicCRS geographicCRS = (GeographicCRS)CRS.getHorizontalComponent((CoordinateReferenceSystem)projectedCRS.getBaseCRS());
                    Object object = projectedCRS.getConversionFromBase();
                    object = new DefaultConversion(IdentifiedObjects.getProperties((IdentifiedObject)object, new String[0]), object.getMethod(), null, object.getParameterValues());
                    return new DefaultProjectedCRS(map, geographicCRS, (Conversion)object, (CartesianCS)compoundCRS);
                }
                return new DefaultEngineeringCRS(map, ((EngineeringCRS)coordinateReferenceSystem).getDatum(), (CoordinateSystem)compoundCRS);
            }
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                SingleCRS singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem2);
                if (singleCRS == null) continue;
                return singleCRS;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalComponent(CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) {
        Object object;
        boolean bl2;
        CompoundCRS compoundCRS;
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            return (VerticalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            bl2 = false;
            do {
                for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                    object = CRS.getVerticalComponent(coordinateReferenceSystem2, bl2);
                    if (object == null) continue;
                    return object;
                }
            } while ((bl2 = !bl2) == bl);
        }
        if (bl && CRS.horizontalCode(coordinateReferenceSystem) == 3 && (bl2 = AxisDirections.indexOfColinear((CoordinateSystem)(compoundCRS = coordinateReferenceSystem.getCoordinateSystem()), AxisDirection.UP)) >= false) {
            CoordinateReferenceSystem coordinateReferenceSystem2;
            CoordinateSystemAxis coordinateSystemAxis = compoundCRS.getAxis(bl2 ? 1 : 0);
            coordinateReferenceSystem2 = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            if (!coordinateReferenceSystem2.getCoordinateSystem().getAxis(0).equals(coordinateSystemAxis)) {
                object = IdentifiedObjects.getProperties((IdentifiedObject)coordinateReferenceSystem2, new String[0]);
                coordinateReferenceSystem2 = new DefaultVerticalCRS((Map<String, ?>)object, coordinateReferenceSystem2.getDatum(), new DefaultVerticalCS((Map<String, ?>)object, coordinateSystemAxis));
            }
            return coordinateReferenceSystem2;
        }
        return null;
    }

    public static TemporalCRS getTemporalComponent(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            return (TemporalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem2);
                if (temporalCRS == null) continue;
                return temporalCRS;
            }
        }
        return null;
    }

    public static List<SingleCRS> getSingleComponents(CoordinateReferenceSystem coordinateReferenceSystem) {
        List<SingleCRS> list;
        if (coordinateReferenceSystem == null) {
            list = Collections.emptyList();
        } else if (coordinateReferenceSystem instanceof CompoundCRS) {
            if (coordinateReferenceSystem instanceof DefaultCompoundCRS) {
                list = ((DefaultCompoundCRS)coordinateReferenceSystem).getSingleComponents();
            } else {
                List list2 = ((CompoundCRS)coordinateReferenceSystem).getComponents();
                list = new ArrayList<SingleCRS>(list2.size());
                ReferencingUtilities.getSingleComponents(list2, list);
            }
        } else {
            list = Collections.singletonList((SingleCRS)coordinateReferenceSystem);
        }
        return list;
    }

    public static CoordinateReferenceSystem getComponentAt(CoordinateReferenceSystem coordinateReferenceSystem, int n, int n2) {
        int n3 = ReferencingUtilities.getDimension(coordinateReferenceSystem);
        ArgumentChecks.ensureValidIndexRange((int)n3, (int)n, (int)n2);
        block0: while (n != 0 || n2 != n3) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                List list = ((CompoundCRS)coordinateReferenceSystem).getComponents();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    coordinateReferenceSystem = (CoordinateReferenceSystem)list.get(i);
                    n3 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
                    if (n < n3) continue block0;
                    n -= n3;
                    n2 -= n3;
                }
            }
            return null;
        }
        return coordinateReferenceSystem;
    }

    public static double getGreenwichLongitude(GeodeticCRS geodeticCRS) {
        ArgumentChecks.ensureNonNull((String)"crs", (Object)geodeticCRS);
        return ReferencingUtilities.getGreenwichLongitude(geodeticCRS.getDatum().getPrimeMeridian(), (Unit<Angle>)Units.DEGREE);
    }

    public static CRSAuthorityFactory getAuthorityFactory(String string) throws FactoryException {
        if (string == null) {
            return AuthorityFactories.ALL;
        }
        return AuthorityFactories.ALL.getAuthorityFactory(CRSAuthorityFactory.class, string, null);
    }

    private static void unexpectedException(String string, Exception exception) {
        Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.referencing"), CRS.class, (String)string, (Throwable)exception);
    }
}

