/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public abstract class DatumShiftGrid<C extends Quantity<C>, T extends Quantity<T>>
implements Serializable {
    private static final long serialVersionUID = 8405276545243175808L;
    protected static final int INTERPOLATED_DIMENSIONS = 2;
    private final Unit<C> coordinateUnit;
    private final LinearTransform coordinateToGrid;
    private final Unit<T> translationUnit;
    private final boolean isCellValueRatio;
    private final int[] gridSize;

    protected DatumShiftGrid(Unit<C> unit, LinearTransform linearTransform, int[] nArray, boolean bl, Unit<T> unit2) {
        ArgumentChecks.ensureNonNull((String)"coordinateUnit", unit);
        ArgumentChecks.ensureNonNull((String)"coordinateToGrid", (Object)linearTransform);
        ArgumentChecks.ensureNonNull((String)"gridSize", (Object)nArray);
        ArgumentChecks.ensureNonNull((String)"translationUnit", unit2);
        int n = linearTransform.getTargetDimensions();
        ArgumentChecks.ensureDimensionMatches((String)"gridSize", (int)n, (int[])nArray);
        this.coordinateUnit = unit;
        this.coordinateToGrid = linearTransform;
        this.isCellValueRatio = bl;
        this.translationUnit = unit2;
        nArray = (int[])nArray.clone();
        this.gridSize = nArray;
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            if (n >= 2) continue;
            throw new IllegalArgumentException(Errors.format((short)(n <= 0 ? (short)165 : 45), (Object)Strings.toIndexed((String)"gridSize", (int)i), (Object)n));
        }
    }

    protected DatumShiftGrid(DatumShiftGrid<C, T> datumShiftGrid) {
        ArgumentChecks.ensureNonNull((String)"other", datumShiftGrid);
        this.coordinateUnit = datumShiftGrid.coordinateUnit;
        this.coordinateToGrid = datumShiftGrid.coordinateToGrid;
        this.isCellValueRatio = datumShiftGrid.isCellValueRatio;
        this.translationUnit = datumShiftGrid.translationUnit;
        this.gridSize = datumShiftGrid.gridSize;
    }

    public int[] getGridSize() {
        return (int[])this.gridSize.clone();
    }

    public Envelope getDomainOfValidity() throws TransformException {
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(this.gridSize.length);
        for (int i = 0; i < this.gridSize.length; ++i) {
            generalEnvelope.setRange(i, -0.5, (double)this.gridSize[i] - 0.5);
        }
        return Envelopes.transform(this.getCoordinateToGrid().inverse(), (Envelope)generalEnvelope);
    }

    public Unit<C> getCoordinateUnit() {
        return this.coordinateUnit;
    }

    public LinearTransform getCoordinateToGrid() {
        return this.coordinateToGrid;
    }

    public abstract int getTranslationDimensions();

    public Unit<T> getTranslationUnit() {
        return this.translationUnit;
    }

    public double[] interpolateAt(double ... dArray) throws TransformException {
        LinearTransform linearTransform = this.getCoordinateToGrid();
        ArgumentChecks.ensureDimensionMatches((String)"coordinates", (int)linearTransform.getSourceDimensions(), (double[])dArray);
        int n = this.getTranslationDimensions();
        double[] dArray2 = new double[Math.max(n, linearTransform.getTargetDimensions())];
        linearTransform.transform(dArray, 0, dArray2, 0, 1);
        this.interpolateInCell(dArray2[0], dArray2[1], dArray2);
        if (this.isCellValueRatio()) {
            linearTransform.inverse().deltaTransform(dArray2, 0, dArray2, 0, 1);
        }
        if (dArray2.length != n) {
            dArray2 = Arrays.copyOf(dArray2, n);
        }
        return dArray2;
    }

    public void interpolateInCell(double d, double d2, double[] dArray) {
        boolean bl = false;
        boolean bl2 = false;
        if (d < 0.0) {
            d = 0.0;
            bl = true;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
            bl2 = true;
        }
        int n = (int)d;
        d -= (double)n;
        int n2 = (int)d2;
        d2 -= (double)n2;
        int n3 = this.gridSize[0] - 2;
        if (n > n3) {
            bl |= n != n3 + 1 || d != 0.0;
            n = n3;
            d = 1.0;
        }
        if (n2 > (n3 = this.gridSize[1] - 2)) {
            bl2 |= n2 != n3 + 1 || d2 != 0.0;
            n2 = n3;
            d2 = 1.0;
        }
        boolean bl3 = dArray.length >= (n3 = this.getTranslationDimensions()) + 4;
        for (int i = 0; i < n3; ++i) {
            double d3 = this.getCellValue(i, n, n2);
            double d4 = this.getCellValue(i, n + 1, n2);
            double d5 = this.getCellValue(i, n, n2 + 1);
            double d6 = this.getCellValue(i, n + 1, n2 + 1);
            double d7 = d4 - d3;
            double d8 = d3 + d * d7;
            double d9 = d6 - d5;
            double d10 = d5 + d * d9;
            dArray[i] = d2 * (d10 - d8) + d8;
            if (!bl3) continue;
            d7 = bl ? 0.0 : (d7 += (d9 - d7) * d);
            if (bl2) {
                d9 = 0.0;
            } else {
                d9 = d5 - d3;
                d9 += (d6 - d4 - d9) * d2;
            }
            int n4 = n3;
            if (i == 0) {
                d7 += 1.0;
            } else {
                d9 += 1.0;
                n4 += 2;
                bl3 = false;
            }
            dArray[n4] = d7;
            dArray[n4 + 1] = d9;
        }
    }

    public Matrix derivativeInCell(double d, double d2) {
        int n = Math.max(0, Math.min(this.gridSize[0] - 2, (int)d));
        int n2 = Math.max(0, Math.min(this.gridSize[1] - 2, (int)d2));
        boolean bl = (d -= (double)n) < 0.0 || d > 1.0;
        boolean bl2 = (d2 -= (double)n2) < 0.0 || d2 > 1.0;
        MatrixSIS matrixSIS = Matrices.createDiagonal(this.getTranslationDimensions(), this.gridSize.length);
        int n3 = matrixSIS.getNumRow();
        while (--n3 >= 0) {
            double d3;
            double d4 = this.getCellValue(n3, n, n2);
            double d5 = this.getCellValue(n3, n + 1, n2);
            double d6 = this.getCellValue(n3, n, n2 + 1);
            double d7 = this.getCellValue(n3, n + 1, n2 + 1);
            if (!bl) {
                d3 = d5 - d4;
                d3 += (d7 - d6 - d3) * d;
                matrixSIS.setElement(n3, 0, matrixSIS.getElement(n3, 0) + d3);
            }
            if (bl2) continue;
            d3 = d6 - d4;
            d3 += (d7 - d5 - d3) * d2;
            matrixSIS.setElement(n3, 1, matrixSIS.getElement(n3, 1) + d3);
        }
        return matrixSIS;
    }

    public abstract double getCellValue(int var1, int var2, int var3);

    public double getCellMean(int n) {
        DoubleDouble doubleDouble = new DoubleDouble();
        int n2 = this.gridSize[0];
        int n3 = this.gridSize[1];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleDouble.addKahan(this.getCellValue(n, j, i));
            }
        }
        return doubleDouble.doubleValue() / (double)(n2 * n3);
    }

    public abstract double getCellPrecision();

    public boolean isCellValueRatio() {
        return this.isCellValueRatio;
    }

    public boolean isCellInGrid(double d, double d2) {
        return d >= 0.0 && d2 >= 0.0 && d <= (double)(this.gridSize[0] - 1) && d2 <= (double)(this.gridSize[1] - 1);
    }

    public abstract ParameterDescriptorGroup getParameterDescriptors();

    public abstract void getParameterValues(Parameters var1);

    public String toString() {
        ParameterDescriptorGroup parameterDescriptorGroup = this.getParameterDescriptors();
        if (parameterDescriptorGroup != null) {
            Parameters parameters = Parameters.castOrWrap(parameterDescriptorGroup.createValue());
            this.getParameterValues(parameters);
            return parameters.toString();
        }
        return super.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            DatumShiftGrid datumShiftGrid = (DatumShiftGrid)object;
            return Arrays.equals(this.gridSize, datumShiftGrid.gridSize) && Objects.equals(this.coordinateToGrid, datumShiftGrid.coordinateToGrid) && Objects.equals(this.coordinateUnit, datumShiftGrid.coordinateUnit) && Objects.equals(this.translationUnit, datumShiftGrid.translationUnit) && this.isCellValueRatio == datumShiftGrid.isCellValueRatio;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.coordinateToGrid) + 37 * Arrays.hashCode(this.gridSize);
    }
}

