/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.action;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.action.EditDocumentActionComponent;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsContainBinaryFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsEditableFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotEditingDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={EditPropertyActionListener.class})})
public class EditPropertyActionComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsDocumentFilter(), new IsEditableFilter(), new CanSetPropertyFilter(), new IsNotLockedFilter(), new IsCheckedOutFilter(), new IsNotInTrashFilter(), new IsNotEditingDocumentFilter(), new IsContainBinaryFilter()});

    @UIExtensionFilters
    public static List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void editDocument(Event<? extends UIComponent> event, WebuiRequestContext context, UIComponent comp, UIJCRExplorer uiExplorer, Node selectedNode, UIApplication uiApp) throws Exception {
        EditDocumentActionComponent.editDocument(event, context, comp, uiExplorer, selectedNode, uiApp);
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class EditPropertyActionListener
    extends UIActionBarActionListener<EditPropertyActionComponent> {
        public void processEvent(Event<EditPropertyActionComponent> event) throws Exception {
            EditPropertyActionComponent uicomp = (EditPropertyActionComponent)((Object)event.getSource());
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            Node selectedNode = null;
            if (nodePath != null && nodePath.length() != 0) {
                Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
                String wsName = null;
                if (!matcher.find()) {
                    throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
                }
                wsName = matcher.group(1);
                nodePath = matcher.group(2);
                Session session = uiExplorer.getSessionByWorkspace(wsName);
                UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
                try {
                    selectedNode = uiExplorer.getNodeByPath(nodePath, session);
                }
                catch (PathNotFoundException path) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                    return;
                }
                catch (AccessDeniedException ace) {
                    uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.null-exception", null, 1));
                    return;
                }
                catch (Exception e) {
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                    return;
                }
            }
            if (selectedNode == null) {
                selectedNode = uiExplorer.getCurrentNode();
            }
            uiExplorer.setSelectNode(selectedNode.getPath());
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            EditPropertyActionComponent.editDocument(event, null, (UIComponent)uicomp, uiExplorer, selectedNode, uiApp);
        }
    }
}

