/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.common.JSONContext;
import org.cometd.oort.Oort;

public abstract class OortConfigServlet
extends HttpServlet {
    public static final String OORT_URL_PARAM = "oort.url";
    public static final String OORT_SECRET_PARAM = "oort.secret";
    public static final String OORT_CHANNELS_PARAM = "oort.channels";
    public static final String OORT_ENABLE_ACK_EXTENSION_PARAM = "enableAckExtension";
    public static final String OORT_JSON_CONTEXT_PARAM = "jsonContext";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        BayeuxServer bayeux = (BayeuxServer)servletContext.getAttribute("org.cometd.bayeux");
        if (bayeux == null) {
            throw new UnavailableException("Missing org.cometd.bayeux attribute");
        }
        String url = this.provideOortURL();
        if (url == null) {
            throw new UnavailableException("Missing oort.url init parameter");
        }
        try {
            Oort oort = this.newOort(bayeux, url);
            String secret = config.getInitParameter(OORT_SECRET_PARAM);
            if (secret != null) {
                oort.setSecret(secret);
            }
            boolean enableAckExtension = Boolean.parseBoolean(config.getInitParameter(OORT_ENABLE_ACK_EXTENSION_PARAM));
            oort.setAckExtensionEnabled(enableAckExtension);
            String jsonContext = config.getInitParameter(OORT_JSON_CONTEXT_PARAM);
            if (jsonContext != null) {
                oort.setJSONContextClient((JSONContext.Client)((Object)((Object)this)).getClass().getClassLoader().loadClass(jsonContext).newInstance());
            }
            oort.start();
            servletContext.setAttribute(Oort.OORT_ATTRIBUTE, (Object)oort);
            this.configureCloud(config, oort);
            String channels = config.getInitParameter(OORT_CHANNELS_PARAM);
            if (channels != null) {
                String[] patterns;
                for (String channel : patterns = channels.split(",")) {
                    if ((channel = channel.trim()).length() <= 0) continue;
                    oort.observeChannel(channel);
                }
            }
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected String provideOortURL() {
        return this.getServletConfig().getInitParameter(OORT_URL_PARAM);
    }

    protected abstract void configureCloud(ServletConfig var1, Oort var2) throws Exception;

    protected Oort newOort(BayeuxServer bayeux, String url) {
        return new Oort(bayeux, url);
    }

    public void destroy() {
        try {
            ServletContext servletContext = this.getServletConfig().getServletContext();
            Oort oort = (Oort)((Object)servletContext.getAttribute(Oort.OORT_ATTRIBUTE));
            servletContext.removeAttribute(Oort.OORT_ATTRIBUTE);
            if (oort != null) {
                oort.stop();
            }
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }
}

