/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.Arrays;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;

public class UserSetExternalInGateinPortal
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(UserSetExternalInGateinPortal.class);
    OrganizationService organizationService;

    public UserSetExternalInGateinPortal(OrganizationService organizationService, InitParams initParams) {
        super(initParams);
        this.organizationService = organizationService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Start upgrade process to add external info in gatein user profile");
        long startupTime = System.currentTimeMillis();
        try {
            Group group = this.organizationService.getGroupHandler().findGroupById("/platform/externals");
            ListAccess externalsMemberships = this.organizationService.getMembershipHandler().findAllMembershipsByGroup(group);
            int total = externalsMemberships.getSize();
            LOG.info((Object)("Number of users to update : " + total));
            int pageSize = 100;
            int current = 0;
            while (current < total) {
                RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
                Membership[] currentBatch = (Membership[])externalsMemberships.load(0, pageSize);
                Arrays.stream(currentBatch).forEach(membership -> {
                    long startTimeForUser = System.currentTimeMillis();
                    String username = membership.getUserName();
                    try {
                        UserProfile profile = this.organizationService.getUserProfileHandler().findUserProfileByName(username);
                        if (profile == null) {
                            profile = this.organizationService.getUserProfileHandler().createUserProfileInstance(username);
                        }
                        profile.setAttribute(UserProfile.OTHER_KEYS[2], "true");
                        this.organizationService.getUserProfileHandler().saveUserProfile(profile, true);
                        LOG.debug("External info added in gatein profile for user {}, {}ms", new Object[]{username, System.currentTimeMillis() - startTimeForUser});
                    }
                    catch (Exception e) {
                        LOG.error("Unable to get profile for user {}", new Object[]{username});
                    }
                });
                LOG.info("Progession : {} users updated on {} total users. It tooks {}ms", new Object[]{current += currentBatch.length, total, System.currentTimeMillis() - startupTime});
                RequestLifeCycle.end();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to find group externals");
        }
    }
}

