/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.drives.impl;

import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NewUserListener
extends UserEventListener {
    private ManageDriveService driveService_;
    private InitParams initParams_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String userPath_;

    public NewUserListener(ManageDriveService driveService, NodeHierarchyCreator nodeHierarchyCreatorService, InitParams params) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreatorService;
        this.driveService_ = driveService;
        this.initParams_ = params;
        this.userPath_ = nodeHierarchyCreatorService.getJcrPath("usersPath");
    }

    public void preSave(User user, boolean isNew) throws Exception {
        String workspace = this.initParams_.getValueParam("workspace").getValue();
        String permissions = this.initParams_.getValueParam("permissions").getValue();
        permissions = permissions.concat("," + user.getUserName());
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, user.getUserName());
        String homePath = userNode.getPath();
        String views = this.initParams_.getValueParam("views").getValue();
        String icon = this.initParams_.getValueParam("icon").getValue();
        boolean viewPreferences = Boolean.parseBoolean(this.initParams_.getValueParam("viewPreferences").getValue());
        boolean viewNonDocument = Boolean.parseBoolean(this.initParams_.getValueParam("viewNonDocument").getValue());
        boolean viewSideBar = Boolean.parseBoolean(this.initParams_.getValueParam("viewSideBar").getValue());
        boolean showHiddenNode = Boolean.parseBoolean(this.initParams_.getValueParam("showHiddenNode").getValue());
        String allowCreateFolder = this.initParams_.getValueParam("allowCreateFolder").getValue();
        String allowNodeTypesOnTree = this.initParams_.getValueParam("allowNodeTypesOnTree").getValue();
        String publicPath = this.nodeHierarchyCreator_.getJcrPath("userPublic");
        String privatePath = this.nodeHierarchyCreator_.getJcrPath("userPrivate");
        String userRelPath = StringUtils.replaceOnce((String)userNode.getPath(), (String)(this.userPath_ + "/"), (String)"");
        this.driveService_.addDrive(userRelPath + "|" + privatePath, workspace, user.getUserName(), homePath + "/" + privatePath, views, icon, viewPreferences, viewNonDocument, viewSideBar, showHiddenNode, allowCreateFolder, allowNodeTypesOnTree);
        this.driveService_.addDrive(userRelPath + "|" + publicPath, workspace, permissions, homePath + "/" + publicPath, views, icon, viewPreferences, viewNonDocument, viewSideBar, showHiddenNode, allowCreateFolder, allowNodeTypesOnTree);
    }

    public void preDelete(User user) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, user.getUserName());
        String userRelPath = StringUtils.replaceOnce((String)userNode.getPath(), (String)(this.userPath_ + "/"), (String)"");
        this.driveService_.removeDrive(userRelPath + "|" + this.nodeHierarchyCreator_.getJcrPath("userPrivate"));
        this.driveService_.removeDrive(userRelPath + "|" + this.nodeHierarchyCreator_.getJcrPath("userPublic"));
    }
}

