/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr;

import java.security.AccessControlException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.documents.storage.TrashStorage;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.picocontainer.Startable;

public class JCRDeleteFileStorageImpl
implements JCRDeleteFileStorage,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)JCRDeleteFileStorageImpl.class.getName());
    private RepositoryService repositoryService;
    private IdentityManager identityManager;
    private TrashStorage trashStorage;
    private FavoriteService favoriteService;
    private ScheduledExecutorService scheduledExecutor;
    private PortalContainer container;
    private SessionProviderService sessionProviderService;
    private ListenerService listenerService;
    public static final Map<String, String> documentsToDeleteQueue = new HashMap<String, String>();

    public JCRDeleteFileStorageImpl(RepositoryService repositoryService, IdentityManager identityManager, TrashStorage trashStorage, FavoriteService favoriteService, PortalContainer container, SessionProviderService sessionProviderService, ListenerService listenerService) {
        this.repositoryService = repositoryService;
        this.identityManager = identityManager;
        this.trashStorage = trashStorage;
        this.favoriteService = favoriteService;
        this.container = container;
        this.sessionProviderService = sessionProviderService;
        this.listenerService = listenerService;
    }

    public void start() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
    }

    public void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    public void undoDelete(String documentId, long userIdentityId) {
        if (documentsToDeleteQueue.containsKey(documentId)) {
            String originalModifierUser = documentsToDeleteQueue.get(documentId);
            if (!originalModifierUser.equals(String.valueOf(userIdentityId))) {
                LOG.warn("User {} attempts to cancel deletion of a document deleted by user {}", new Object[]{userIdentityId, originalModifierUser});
                return;
            }
            documentsToDeleteQueue.remove(documentId);
        }
    }

    public Map<String, String> getDocumentsToDelete() {
        return documentsToDeleteQueue;
    }

    public void deleteDocument(String folderPath, String documentId, boolean favorite, boolean checkToMoveToTrash, long delay, Identity identity, long userIdentityId) {
        SessionProvider sessionProvider = null;
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity);
            Session session = sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), manageableRepository);
            if (delay > 0L) {
                documentsToDeleteQueue.put(documentId, String.valueOf(userIdentityId));
                this.scheduledExecutor.schedule(() -> {
                    if (documentsToDeleteQueue.containsKey(documentId)) {
                        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
                        RequestLifeCycle.begin((ExoContainer)this.container);
                        try {
                            documentsToDeleteQueue.remove(documentId);
                            this.moveToTrash(folderPath, session, userIdentityId, favorite, checkToMoveToTrash);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error when deleting the document with path" + folderPath), (Throwable)e);
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                    }
                }, delay, TimeUnit.SECONDS);
            } else {
                this.moveToTrash(folderPath, session, userIdentityId, favorite, checkToMoveToTrash);
            }
        }
        catch (PathNotFoundException path) {
            LOG.error((Object)("The document with this path is not found" + folderPath), (Throwable)path);
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting the document" + folderPath), (Throwable)e);
        }
    }

    private void moveToTrash(String folderPath, Session session, long userIdentityId, boolean favorite, boolean checkToMoveToTrash) throws RepositoryException, ObjectNotFoundException {
        Node node = null;
        if (StringUtils.isNotBlank((CharSequence)folderPath)) {
            node = JCRDocumentsUtil.getNodeByPath(session, folderPath);
        }
        if (node != null) {
            String trashId;
            if (favorite) {
                Favorite favoriteDocument = new Favorite("file", node.getUUID(), null, userIdentityId);
                this.favoriteService.deleteFavorite(favoriteDocument);
            }
            if ((trashId = this.processRemoveOrMoveToTrash(node, checkToMoveToTrash)).equals("-1")) {
                LOG.error((Object)"an unexpected error occurs while removing or moving the node to trash");
            }
        }
    }

    private String processRemoveOrMoveToTrash(Node node, boolean checkToMoveToTrash) throws RepositoryException {
        String trashId;
        block7: {
            if (!checkToMoveToTrash || this.trashStorage.isInTrash(node)) {
                this.processRemoveNode(node);
                return "0";
            }
            trashId = this.moveToTrash(node);
            if (!trashId.equals("-1") && !(node = this.trashStorage.getNodeByTrashId(trashId)).getPrimaryNodeType().getName().equals("nt:file")) {
                LinkedList<Node> queue = new LinkedList<Node>();
                queue.add(node);
                Node tempNode = null;
                try {
                    while (!queue.isEmpty()) {
                        tempNode = (Node)queue.poll();
                        if (tempNode.getPrimaryNodeType().getName().equals("nt:file")) {
                            this.listenerService.broadcast("FileActivityNotify.event.FileRemoved", (Object)tempNode.getParent(), (Object)tempNode);
                            continue;
                        }
                        NodeIterator iter = tempNode.getNodes();
                        while (iter.hasNext()) {
                            Node childNode = iter.nextNode();
                            if (!childNode.isNodeType("nt:unstructured") && !childNode.isNodeType("nt:folder")) continue;
                            queue.add(childNode);
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block7;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        return trashId;
    }

    private void processRemoveNode(Node node) throws RepositoryException {
        block4: {
            Node parentNode = node.getParent();
            try {
                if (!node.isNodeType("exo:symlink")) {
                    for (Node symlink : this.trashStorage.getAllLinks(node, "exo:symlink")) {
                        symlink.remove();
                        symlink.getSession().save();
                    }
                }
                node.remove();
                parentNode.save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"an unexpected error occurs while removing the node", (Throwable)e);
            }
        }
    }

    private String moveToTrash(Node node) throws RepositoryException {
        boolean ret = true;
        String trashId = null;
        try {
            if (!node.isCheckedOut()) {
                throw new VersionException("node is locked, can't move to trash node :" + node.getPath());
            }
            if (!JCRDeleteFileStorageImpl.canRemoveNode(node)) {
                throw new AccessDeniedException("access denied, can't move to trash node:" + node.getPath());
            }
            SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            trashId = this.trashStorage.moveToTrash(node, sessionProvider);
        }
        catch (PathNotFoundException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error to find node with the path :" + node.getPath()));
            }
            ret = false;
        }
        catch (LockException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("node is locked, can't move to trash node :" + node.getPath()));
            }
            ret = false;
        }
        catch (VersionException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("node is checked in, can't move to trash node:" + node.getPath()));
            }
            this.removeMixinRestoreLocation(node);
            ret = false;
        }
        catch (AccessDeniedException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("access denied, can't move to trash node:" + node.getPath()));
            }
            ret = false;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs", (Throwable)e);
            }
            ret = false;
        }
        return ret ? trashId : "-1";
    }

    public static boolean canRemoveNode(Node node) throws RepositoryException {
        return JCRDeleteFileStorageImpl.checkPermission(node, "remove");
    }

    private static boolean checkPermission(Node node, String permissionType) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission(permissionType);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    private void removeMixinRestoreLocation(Node node) throws RepositoryException {
        if (node.isNodeType("exo:restoreLocation")) {
            node.removeMixin("exo:restoreLocation");
            node.save();
        }
    }
}

