/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.category.config;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.category.UICategoryNavigationPortlet;
import org.exoplatform.wcm.webui.category.UICategoryNavigationUtils;
import org.exoplatform.wcm.webui.selector.page.UIPageSelector;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={ChangeRepositoryActionListener.class}), @EventConfig(listeners={SelectTargetPathActionListener.class})})
public class UICategoryNavigationConfig
extends UIForm
implements UISelectable {
    private String popupId;

    public UICategoryNavigationConfig() throws Exception {
        PortletPreferences preferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceRepository = preferences.getValue("repository", "");
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ArrayList<SelectItemOption> repositories = new ArrayList<SelectItemOption>();
        RepositoryEntry repositoryEntry = repositoryService.getCurrentRepository().getConfiguration();
        repositories.add(new SelectItemOption((Object)repositoryEntry.getName()));
        UIFormSelectBox repositoryFormSelectBox = new UIFormSelectBox("UICategoryNavigationRepositoryFormSelectBox", "UICategoryNavigationRepositoryFormSelectBox", repositories);
        repositoryFormSelectBox.setValue(preferenceRepository);
        repositoryFormSelectBox.setOnChange("ChangeRepository");
        this.addUIFormInput((UIFormInput)repositoryFormSelectBox);
        String preferenceTreeTitle = preferences.getValue("treeTitle", "");
        this.addUIFormInput((UIFormInput)new UIFormStringInput("UICategoryNavigationTreeTitleFormStringInput", "UICategoryNavigationTreeTitleFormStringInput", preferenceTreeTitle));
        String preferenceTreeName = preferences.getValue("treeName", "");
        List<SelectItemOption<String>> trees = this.getTaxonomyTrees();
        UIFormSelectBox treeNameFormSelectBox = new UIFormSelectBox("UICategoryNavigationTreeNameFormSelectBox", "UICategoryNavigationTreeNameFormSelectBox", trees);
        treeNameFormSelectBox.setValue(preferenceTreeName);
        this.addUIFormInput((UIFormInput)treeNameFormSelectBox);
        String preferencePortletName = preferences.getValue("portletName", "");
        String preferenceTemplateCategory = preferences.getValue("templateCategory", "");
        String preferenceTemplatePath = preferences.getValue("templatePath", "");
        List<SelectItemOption<String>> templates = this.getTemplateList(preferencePortletName, preferenceTemplateCategory);
        UIFormSelectBox templateFormSelectBox = new UIFormSelectBox("UICategoryNavigationTemplateFormSelectBox", "UICategoryNavigationTemplateFormSelectBox", templates);
        templateFormSelectBox.setValue(preferenceTemplatePath);
        this.addUIFormInput((UIFormInput)templateFormSelectBox);
        String preferenceTargetPath = preferences.getValue("targetPath", "");
        UIFormInputSetWithAction targetPathFormInputSet = new UIFormInputSetWithAction("UICategoryNavigationTargetPathFormInputSet");
        UIFormStringInput targetPathFormStringInput = new UIFormStringInput("UICategoryNavigationTargetPathFormStringInput", "UICategoryNavigationTargetPathFormStringInput", preferenceTargetPath);
        targetPathFormStringInput.setReadOnly(true);
        targetPathFormInputSet.setActionInfo("UICategoryNavigationTargetPathFormStringInput", new String[]{"SelectTargetPath"});
        targetPathFormInputSet.addUIFormInput((UIFormInput)targetPathFormStringInput);
        this.addChild((UIComponent)targetPathFormInputSet);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public String getPopupId() {
        return this.popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    private List<SelectItemOption<String>> getTemplateList(String portletName, String templateCategory) throws Exception {
        ArrayList<SelectItemOption<String>> templates = new ArrayList<SelectItemOption<String>>();
        ApplicationTemplateManagerService appTemplateMngService = (ApplicationTemplateManagerService)this.getApplicationComponent(ApplicationTemplateManagerService.class);
        List templateNodes = appTemplateMngService.getTemplatesByCategory(portletName, templateCategory, WCMCoreUtils.getUserSessionProvider());
        for (Node templateNode : templateNodes) {
            String templateName = templateNode.getName();
            String templatePath = templateNode.getPath();
            templates.add((SelectItemOption<String>)new SelectItemOption(templateName, (Object)templatePath));
        }
        return templates;
    }

    private List<SelectItemOption<String>> getTaxonomyTrees() throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)this.getApplicationComponent(LivePortalManagerService.class);
        List taxonomyNodes = taxonomyService.getAllTaxonomyTrees();
        ArrayList<SelectItemOption<String>> taxonomyTrees = new ArrayList<SelectItemOption<String>>();
        for (Node taxonomyNode : taxonomyNodes) {
            Node portalNode = livePortalManagerService.getLivePortalByChild(taxonomyNode);
            if (portalNode == null) continue;
            taxonomyTrees.add((SelectItemOption<String>)new SelectItemOption(taxonomyNode.getName(), (Object)taxonomyNode.getName()));
        }
        return taxonomyTrees;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        UIFormStringInput formStringInput = (UIFormStringInput)this.findComponentById(selectField);
        formStringInput.setValue((Object)value.toString());
        UICategoryNavigationPortlet categoryNavigationPortlet = (UICategoryNavigationPortlet)this.getAncestorOfType(UICategoryNavigationPortlet.class);
        UIPopupContainer popupContainer = (UIPopupContainer)categoryNavigationPortlet.getChild(UIPopupContainer.class);
        Utils.closePopupWindow((UIContainer)popupContainer, (String)this.popupId);
    }

    public static class SelectTargetPathActionListener
    extends EventListener<UICategoryNavigationConfig> {
        public void execute(Event<UICategoryNavigationConfig> event) throws Exception {
            UICategoryNavigationConfig categoryNavigationConfig = (UICategoryNavigationConfig)((Object)event.getSource());
            UICategoryNavigationPortlet categoryNavigationPortlet = (UICategoryNavigationPortlet)categoryNavigationConfig.getAncestorOfType(UICategoryNavigationPortlet.class);
            UIPopupContainer popupContainer = (UIPopupContainer)categoryNavigationPortlet.getChild(UIPopupContainer.class);
            UIPageSelector pageSelector = (UIPageSelector)popupContainer.createUIComponent(UIPageSelector.class, null, null);
            pageSelector.setSourceComponent((UIComponent)categoryNavigationConfig, new String[]{"UICategoryNavigationTargetPathFormStringInput"});
            Utils.createPopupWindow((UIContainer)popupContainer, (UIComponent)pageSelector, (String)"UICategoryNavigationTargetPathPopupWindow", (int)700);
            categoryNavigationConfig.setPopupId("UICategoryNavigationTargetPathPopupWindow");
        }
    }

    public static class ChangeRepositoryActionListener
    extends EventListener<UICategoryNavigationConfig> {
        public void execute(Event<UICategoryNavigationConfig> event) throws Exception {
        }
    }

    public static class CancelActionListener
    extends EventListener<UICategoryNavigationConfig> {
        public void execute(Event<UICategoryNavigationConfig> event) throws Exception {
            UICategoryNavigationConfig viewerManagementForm = (UICategoryNavigationConfig)((Object)event.getSource());
            Utils.closePopupWindow((UIContainer)viewerManagementForm, (String)"UICNConfigPopupWindow");
            ((PortletRequestContext)event.getRequestContext()).setApplicationMode(PortletMode.VIEW);
        }
    }

    public static class SaveActionListener
    extends EventListener<UICategoryNavigationConfig> {
        public void execute(Event<UICategoryNavigationConfig> event) throws Exception {
            UICategoryNavigationConfig categoryNavigationConfig = (UICategoryNavigationConfig)((Object)event.getSource());
            String preferenceRepository = (String)categoryNavigationConfig.getUIFormSelectBox("UICategoryNavigationRepositoryFormSelectBox").getValue();
            String preferenceTreeName = (String)categoryNavigationConfig.getUIFormSelectBox("UICategoryNavigationTreeNameFormSelectBox").getValue();
            String preferenceTreeTitle = (String)categoryNavigationConfig.getUIStringInput("UICategoryNavigationTreeTitleFormStringInput").getValue();
            if (preferenceTreeTitle == null) {
                preferenceTreeTitle = "";
            }
            String preferenceTargetPath = (String)categoryNavigationConfig.getUIStringInput("UICategoryNavigationTargetPathFormStringInput").getValue();
            String preferenceTemplate = (String)categoryNavigationConfig.getUIFormSelectBox("UICategoryNavigationTemplateFormSelectBox").getValue();
            PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
            portletPreferences.setValue("repository", preferenceRepository);
            portletPreferences.setValue("treeName", preferenceTreeName);
            portletPreferences.setValue("treeTitle", preferenceTreeTitle);
            portletPreferences.setValue("targetPath", preferenceTargetPath);
            portletPreferences.setValue("templatePath", preferenceTemplate);
            portletPreferences.store();
            if (!Utils.isEditPortletInCreatePageWizard()) {
                PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
                UIPortal uiPortal = Util.getUIPortal();
                NodeURL nodeURL = (NodeURL)portalRequestContext.createURL(NodeURL.TYPE);
                String uri = nodeURL.setNode(uiPortal.getSelectedUserNode()).toString();
                ((PortletRequestContext)event.getRequestContext()).setApplicationMode(PortletMode.VIEW);
                Utils.closePopupWindow((UIContainer)categoryNavigationConfig, (String)"UICNConfigPopupWindow");
                RequireJS requireJS = event.getRequestContext().getJavascriptManager().getRequireJS();
                requireJS.require("SHARED/ecm-utils", "ecmutil").addScripts("ecmutil.ECMUtils.ajaxRedirect('" + uri + "');");
            } else if (Utils.isQuickEditMode((UIContainer)categoryNavigationConfig, (String)"UICNConfigPopupWindow")) {
                Utils.closePopupWindow((UIContainer)categoryNavigationConfig, (String)"UICNConfigPopupWindow");
            } else {
                Utils.createPopupMessage((UIContainer)categoryNavigationConfig, (String)"UICategoryNavigationConfig.msg.saving-success", null, (int)2);
            }
        }
    }
}

