/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.security.RolesAllowed;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.io.IOUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.documents.DocumentTypeService;
import org.exoplatform.services.cms.documents.impl.DocumentType;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.rest.api.RestUtils;
import org.json.JSONObject;
import org.picocontainer.Startable;

@Path(value="/office/")
@RolesAllowed(value={"users"})
public class OpenInOfficeConnector
implements ResourceContainer,
Startable {
    private Log log = ExoLogger.getExoLogger(OpenInOfficeConnector.class);
    private final String OPEN_DOCUMENT_ON_DESKTOP_ICO = "uiIconOpenOnDesktop";
    private final String CONNECTOR_BUNDLE_LOCATION = "locale.wcm.resources.WCMResourceBundleConnector";
    private final String OPEN_DOCUMENT_ON_DESKTOP_RESOURCE_KEY = "OpenInOfficeConnector.label.exo.remote-edit.desktop";
    private final String OPEN_DOCUMENT_IN_DESKTOP_APP_RESOURCE_KEY = "OpenInOfficeConnector.label.exo.remote-edit.desktop-app";
    private final String OPEN_DOCUMENT_DEFAULT_TITLE = "Open on Desktop";
    private final int CACHED_TIME = 518400;
    private static final String VERSION_MIXIN = "mix:versionable";
    private NodeFinder nodeFinder;
    private LinkManager linkManager;
    private ResourceBundleService resourceBundleService;
    private DocumentTypeService documentTypeService;

    public OpenInOfficeConnector(NodeFinder nodeFinder, LinkManager linkManager, ResourceBundleService resourceBundleService, DocumentTypeService documentTypeService) {
        this.nodeFinder = nodeFinder;
        this.linkManager = linkManager;
        this.resourceBundleService = resourceBundleService;
        this.documentTypeService = documentTypeService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/updateDocumentTitle")
    public Response updateDocumentTitle(@Context Request request, @QueryParam(value="objId") String objId, @QueryParam(value="lang") String language) throws Exception {
        boolean isFile;
        String nodePath;
        DocumentType documentType;
        String ico;
        String title;
        CacheControl cc;
        EntityTag etag;
        Response.ResponseBuilder builder;
        String workspace;
        block18: {
            try {
                objId = URLDecoder.decode(objId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"Error while decoding file name", (Throwable)e);
            }
            int indexColon = objId.indexOf(":/");
            if (indexColon < 0) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The objId param must start by the workspace name, followed by ':' and the node path").build();
            }
            workspace = objId.substring(0, indexColon);
            String filePath = objId.substring(indexColon + 1);
            String extension = filePath.substring(filePath.lastIndexOf(".") + 1, filePath.length());
            if (extension.contains("[")) {
                extension = extension.substring(0, extension.indexOf("["));
            }
            if ((builder = request.evaluatePreconditions(etag = new EntityTag(Integer.toString((extension + "_" + language).hashCode())))) != null) {
                return builder.build();
            }
            cc = new CacheControl();
            cc.setMaxAge(518400);
            ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.wcm.resources.WCMResourceBundleConnector", new Locale(language));
            title = resourceBundle != null ? resourceBundle.getString("OpenInOfficeConnector.label.exo.remote-edit.desktop") : "Open on Desktop";
            ico = "uiIconOpenOnDesktop";
            documentType = this.documentTypeService.getDocumentType(extension);
            if (documentType != null && resourceBundle != null) {
                try {
                    if (!StringUtils.isEmpty((String)resourceBundle.getString(documentType.getResourceBundleKey()))) {
                        title = resourceBundle.getString(documentType.getResourceBundleKey());
                    }
                }
                catch (MissingResourceException ex) {
                    String _openonDesktop = resourceBundle.getString("OpenInOfficeConnector.label.exo.remote-edit.desktop-app");
                    title = _openonDesktop != null && _openonDesktop.contains("{0}") ? _openonDesktop.replace("{0}", documentType.getResourceBundleKey()) : "Open on Desktop";
                }
                if (!StringUtils.isEmpty((String)documentType.getIconClass())) {
                    ico = documentType.getIconClass();
                }
            }
            nodePath = filePath;
            isFile = false;
            try {
                Node node;
                try {
                    node = (Node)this.nodeFinder.getItem(workspace, filePath);
                }
                catch (PathNotFoundException e) {
                    node = (Node)this.nodeFinder.getItem(workspace, Text.unescapeIllegalJcrChars((String)filePath));
                }
                if (this.linkManager.isLink((Item)node)) {
                    node = this.linkManager.getTarget(node);
                }
                nodePath = node.getPath();
                isFile = node.isNodeType("nt:file");
            }
            catch (AccessDeniedException | PathNotFoundException e) {
                if (this.log.isDebugEnabled()) {
                    String currentUser = RestUtils.getCurrentUser();
                    this.log.debug("User {} can't access document {}:{}", new Object[]{currentUser, workspace, filePath, e});
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            catch (RepositoryException ex) {
                if (!this.log.isErrorEnabled()) break block18;
                this.log.error((Object)("Exception when get node with path: " + filePath), (Throwable)ex);
            }
        }
        boolean isMsoffice = false;
        if (documentType.getResourceBundleKey() != "OpenInOfficeConnector.label.exo.remote-edit.desktop") {
            isMsoffice = true;
        }
        JSONObject rs = new JSONObject();
        rs.put("ico", (Object)ico);
        rs.put("title", (Object)title);
        rs.put("repository", (Object)WCMCoreUtils.getRepository().getConfiguration().getName());
        rs.put("workspace", (Object)workspace);
        rs.put("filePath", (Object)nodePath);
        rs.put("isFile", isFile);
        rs.put("isMsoffice", isMsoffice);
        builder = Response.ok((Object)rs.toString(), (String)"application/json");
        builder.tag(etag);
        builder.cacheControl(cc);
        return builder.build();
    }

    public String[] getDocumentInfos(String fileName) {
        String title = "OpenInOfficeConnector.label.exo.remote-edit.desktop";
        String icon = "uiIconOpenOnDesktop";
        String _extension = "";
        if (fileName.lastIndexOf(".") > 0) {
            _extension = StringUtils.substring((String)fileName, (int)(fileName.lastIndexOf(".") + 1), (int)fileName.length());
        }
        if (StringUtils.isBlank((String)_extension)) {
            return new String[]{title, icon};
        }
        DocumentType documentType = this.documentTypeService.getDocumentType(_extension);
        if (documentType != null) {
            if (!StringUtils.isEmpty((String)documentType.getResourceBundleKey())) {
                title = documentType.getResourceBundleKey();
            }
            if (!StringUtils.isEmpty((String)documentType.getIconClass())) {
                icon = documentType.getIconClass();
            }
        }
        return new String[]{title, icon};
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/checkout")
    public Response checkout(@Context Request request, @QueryParam(value="filePath") String filePath, @QueryParam(value="workspace") String workspace) {
        try {
            Node node = null;
            try {
                node = (Node)this.nodeFinder.getItem(workspace, filePath);
            }
            catch (PathNotFoundException e) {
                node = (Node)this.nodeFinder.getItem(workspace, Text.unescapeIllegalJcrChars((String)filePath));
            }
            if (node.canAddMixin(VERSION_MIXIN)) {
                node.addMixin(VERSION_MIXIN);
                node.save();
                node.checkin();
                node.checkout();
            }
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            return Response.ok((Object)String.valueOf(node.isCheckedOut()), (String)"text/plain").build();
        }
        catch (AccessDeniedException | PathNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                String currentUser = RestUtils.getCurrentUser();
                this.log.debug("User {} can't access document {}:{}", new Object[]{currentUser, workspace, filePath, e});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log.warn("Error checking out document {}:{}", new Object[]{workspace, filePath, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/{linkFilePath}/")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/internet-shortcut"})
    public Response createShortcut(@Context HttpServletRequest httpServletRequest, @PathParam(value="linkFilePath") String linkFilePath, @QueryParam(value="filePath") String filePath, @QueryParam(value="workspace") String workspace) throws Exception {
        try {
            Node node = null;
            try {
                node = (Node)this.nodeFinder.getItem(workspace, filePath);
            }
            catch (PathNotFoundException e) {
                node = (Node)this.nodeFinder.getItem(workspace, Text.unescapeIllegalJcrChars((String)filePath));
            }
            String repo = WCMCoreUtils.getRepository().getConfiguration().getName();
            String obsPath = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + "/" + WCMCoreUtils.getRestContextName() + "/private/jcr/" + repo + "/" + workspace + node.getPath();
            Object shortCutContent = "[InternetShortcut]\n";
            shortCutContent = (String)shortCutContent + "URL=" + obsPath + "\n";
            return Response.ok((Object)IOUtils.toInputStream((String)shortCutContent), (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=" + node.getName() + ".url")).header("Content-type", (Object)"application/internet-shortcut").build();
        }
        catch (AccessDeniedException | PathNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                String currentUser = RestUtils.getCurrentUser();
                this.log.debug("User {} can't access document {}:{}", new Object[]{currentUser, workspace, filePath, e});
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.log.warn("Error getting shortcut of document {}:{}", new Object[]{workspace, filePath, e});
            return Response.serverError().build();
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

