/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.ecm.webui.CloudDriveUIMenuAction;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.webui.CloudDriveUIExtension;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.picocontainer.Startable;

public class CloudDriveUIService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(CloudDriveUIService.class);
    protected static final String DMS_SYSTEM_WORKSPACE = "dms-system";
    protected static final String EXO_BUTTONS = "exo:buttons";
    protected static final String ECD_USER_BUTTONS = "ecd:userButtons";
    protected static final String ECD_BUTTONS = "ecd:buttons";
    protected static final String ECD_DEFAULT_BUTTONS = "ecd:defaultButtons";
    public static final String CONNECT_CLOUD_DRIVE_ACTION = "add.connect.clouddrive.action";
    protected final RepositoryService jcrService;
    protected final ManageViewService manageView;
    protected final CloudDriveService driveService;
    protected final UIExtensionManager uiExtensions;
    protected final Set<String> defaultMenuActions = new HashSet<String>();
    protected final List<String> VIEWS = Arrays.asList("List/List", "Admin/Admin", "Web/Authoring", "Icons/Icons", "Categories/Collaboration");

    public CloudDriveUIService(RepositoryService repoService, CloudDriveService driveService, UIExtensionManager uiExtensions, ManageViewService manageView) {
        this.jcrService = repoService;
        this.manageView = manageView;
        this.driveService = driveService;
        this.uiExtensions = uiExtensions;
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof CloudDriveUIExtension) {
            CloudDriveUIExtension ext = (CloudDriveUIExtension)plugin;
            this.defaultMenuActions.addAll(ext.getDefaultActions());
        } else {
            LOG.warn((Object)("Cannot recognize component plugin for " + plugin.getName() + ": type " + plugin.getClass() + " not supported"));
        }
    }

    protected Set<String> getDefaultActions() throws Exception {
        LinkedHashSet<String> cdActions = new LinkedHashSet<String>();
        for (UIExtension ext : this.uiExtensions.getUIExtensions("org.exoplatform.ecm.dms.UIActionBar")) {
            String menuAction = ext.getName();
            if (!this.defaultMenuActions.contains(menuAction)) continue;
            cdActions.add(menuAction);
        }
        return cdActions;
    }

    protected List<String> getAllActions() throws Exception {
        ArrayList<String> cdActions = new ArrayList<String>();
        for (UIExtension ext : this.uiExtensions.getUIExtensions("org.exoplatform.ecm.dms.UIActionBar")) {
            Class extComp = ext.getComponent();
            if (!CloudDriveUIMenuAction.class.isAssignableFrom(extComp)) continue;
            cdActions.add(ext.getName());
        }
        return cdActions;
    }

    protected String readViewActions(Node node, String propertyName) throws RepositoryException {
        ArrayList<String> actionList = new ArrayList<String>();
        if (node.hasProperty(propertyName)) {
            String[] actions = node.getProperty(propertyName).getString().split(";");
            for (int i = 0; i < actions.length; ++i) {
                String a = actions[i].trim();
                if (actionList.contains(a)) continue;
                actionList.add(a);
            }
        }
        return String.join((CharSequence)";", actionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareViews() throws Exception {
        try (SessionProvider jcrSessions = SessionProvider.createSystemProvider();){
            Set<String> defaultConfiguredActions = this.getDefaultActions();
            Session session = jcrSessions.getSession(DMS_SYSTEM_WORKSPACE, this.jcrService.getCurrentRepository());
            for (String view : this.VIEWS) {
                Node viewNode = this.manageView.getViewByName(view, jcrSessions);
                StringBuilder newActions = new StringBuilder();
                newActions.append(this.readViewActions(viewNode, EXO_BUTTONS));
                int menuLength = newActions.length();
                StringBuilder cdActions = new StringBuilder();
                cdActions.append(this.readViewActions(viewNode, ECD_BUTTONS));
                if (cdActions.length() > 0) {
                    newActions.append(';');
                    newActions.append(' ');
                    newActions.append((CharSequence)cdActions);
                }
                if (newActions.length() == menuLength) {
                    cdActions.append(' ');
                    for (String cda : defaultConfiguredActions) {
                        String acs = this.uncapitalize(cda);
                        if (newActions.indexOf(acs) < 0) {
                            newActions.append(';');
                            newActions.append(' ');
                            newActions.append(acs);
                        }
                        if (cdActions.indexOf(acs) >= 0) continue;
                        cdActions.append(acs);
                        cdActions.append(';');
                    }
                    String cdButtons = cdActions.toString().trim();
                    if (viewNode.canAddMixin(ECD_USER_BUTTONS)) {
                        viewNode.addMixin(ECD_USER_BUTTONS);
                    }
                    viewNode.setProperty(ECD_BUTTONS, cdButtons);
                    if (viewNode.canAddMixin(ECD_DEFAULT_BUTTONS)) {
                        viewNode.addMixin(ECD_DEFAULT_BUTTONS);
                    }
                    viewNode.setProperty(ECD_DEFAULT_BUTTONS, cdButtons);
                } else {
                    StringBuilder defaultSavedActions = new StringBuilder();
                    defaultSavedActions.append(this.readViewActions(viewNode, ECD_DEFAULT_BUTTONS));
                    LinkedHashSet<String> addDefaultActions = new LinkedHashSet<String>();
                    for (String cda : defaultConfiguredActions) {
                        String acs = this.uncapitalize(cda);
                        if (defaultSavedActions.indexOf(acs) >= 0) continue;
                        addDefaultActions.add(acs);
                        defaultSavedActions.append(acs);
                        defaultSavedActions.append(';');
                    }
                    if (addDefaultActions.size() > 0) {
                        for (String acs : addDefaultActions) {
                            if (newActions.indexOf(acs) < 0) {
                                newActions.append(';');
                                newActions.append(' ');
                                newActions.append(acs);
                            }
                            if (cdActions.indexOf(acs) >= 0) continue;
                            cdActions.append(acs);
                            cdActions.append(';');
                        }
                        viewNode.setProperty(ECD_BUTTONS, cdActions.toString().trim());
                        if (viewNode.canAddMixin(ECD_DEFAULT_BUTTONS)) {
                            viewNode.addMixin(ECD_DEFAULT_BUTTONS);
                        }
                        viewNode.setProperty(ECD_DEFAULT_BUTTONS, defaultSavedActions.toString().trim());
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("New buttons: " + newActions.toString()));
                }
                viewNode.setProperty(EXO_BUTTONS, newActions.toString());
            }
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreViews() throws Exception {
        try (SessionProvider jcrSessions = SessionProvider.createSystemProvider();){
            Session session = jcrSessions.getSession(DMS_SYSTEM_WORKSPACE, this.jcrService.getCurrentRepository());
            for (String view : this.VIEWS) {
                Node viewNode = this.manageView.getViewByName(view, jcrSessions);
                String newActions = "";
                String cdActions = "";
                if (viewNode.hasProperty(EXO_BUTTONS)) {
                    String[] actions = viewNode.getProperty(EXO_BUTTONS).getString().split(";");
                    ArrayList<String> cloudDriveActions = new ArrayList<String>();
                    ArrayList<String> defaultActions = new ArrayList<String>();
                    for (String action : actions) {
                        String a = action.trim();
                        String aname = this.capitalize(a);
                        UIExtension ae = this.uiExtensions.getUIExtension("org.exoplatform.ecm.dms.UIActionBar", aname);
                        if (ae != null) {
                            if (CloudDriveUIMenuAction.class.isAssignableFrom(ae.getComponent())) {
                                if (cloudDriveActions.contains(a)) continue;
                                cloudDriveActions.add(a);
                                continue;
                            }
                            if (defaultActions.contains(a)) continue;
                            defaultActions.add(a);
                            continue;
                        }
                        LOG.warn((Object)("Cannot find UIExtension for action " + aname));
                    }
                    newActions = String.join((CharSequence)";", defaultActions);
                    cdActions = String.join((CharSequence)";", cloudDriveActions);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Stored user buttons: " + cdActions));
                }
                viewNode.setProperty(EXO_BUTTONS, newActions);
                viewNode.setProperty(ECD_BUTTONS, cdActions);
            }
            session.save();
        }
    }

    protected String capitalize(String text) {
        char[] tc = text.toCharArray();
        if (tc.length > 0) {
            tc[0] = Character.toUpperCase(tc[0]);
        }
        return new String(tc);
    }

    protected String uncapitalize(String text) {
        char[] tc = text.toCharArray();
        if (tc.length > 0) {
            tc[0] = Character.toLowerCase(tc[0]);
        }
        return new String(tc);
    }

    public void start() {
        try {
            this.prepareViews();
            List repoContainers = ExoContainerContext.getCurrentContainer().getComponentInstancesOfType(RepositoryContainer.class);
            for (Object rco : repoContainers) {
                RepositoryContainer rc = (RepositoryContainer)rco;
                WorkspaceContainer wc = rc.getWorkspaceContainer(DMS_SYSTEM_WORKSPACE);
                if (wc == null) continue;
                wc.registerComponentInstance((Object)new ViewRestorer());
            }
            LOG.info((Object)"Cloud Drive actions successfully enabled");
        }
        catch (Exception e) {
            LOG.error((Object)("Error enabling Cloud Drive actions: " + e.getMessage()), (Throwable)e);
        }
    }

    public void stop() {
    }

    class ViewRestorer
    implements Suspendable {
        boolean suspended = false;

        ViewRestorer() {
        }

        public void suspend() throws SuspendException {
            try {
                CloudDriveUIService.this.restoreViews();
                LOG.info((Object)"Cloud Drive actions successfully disabled");
            }
            catch (Exception e) {
                LOG.error((Object)("Error disabling Cloud Drive actions: " + e.getMessage()), (Throwable)e);
            }
            this.suspended = true;
        }

        public void resume() throws ResumeException {
            this.suspended = true;
        }

        public boolean isSuspended() {
            return this.suspended;
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    }
}

