/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NewsArticlesViewsCountUpgrade
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)NewsArticlesViewsCountUpgrade.class.getName());
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private int updatedNodes = 0;
    private static final String EXO_NEWS_VIEWERS = "exo:viewers";
    private static final String EXO_NEWS_VIEWS_COUNT = "exo:viewsCount";

    public NewsArticlesViewsCountUpgrade(InitParams initParams, RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    public int getUpdatedNodes() {
        return this.updatedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start upgrade of news articles viewsCount");
        try (SessionProvider sessionProvider = null;){
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            String queryString = "SELECT * FROM exo:news WHERE jcr:path LIKE '/Groups/spaces/%/News/%'";
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString, "sql");
            NodeIterator newsIterator = query.execute().getNodes();
            while (newsIterator.hasNext()) {
                long oldViewsCount;
                long viewsCount;
                Node news = newsIterator.nextNode();
                String newsTitle = news.getProperty("exo:title").getValue().getString();
                if (!news.hasProperty(EXO_NEWS_VIEWS_COUNT) || !news.hasProperty(EXO_NEWS_VIEWERS) || (viewsCount = (long)news.getProperty(EXO_NEWS_VIEWERS).getValue().getString().split(",").length) <= (oldViewsCount = news.getProperty(EXO_NEWS_VIEWS_COUNT).getValue().getLong())) continue;
                news.setProperty(EXO_NEWS_VIEWS_COUNT, viewsCount);
                news.save();
                LOG.info("viewsCount of article {} has been updated: {}", new Object[]{newsTitle, viewsCount});
                ++this.updatedNodes;
            }
            LOG.info("End upgrade of news articles viewsCount, {} articles were successfully updated. It took {} ms", new Object[]{this.updatedNodes, System.currentTimeMillis() - startupTime});
        }
    }
}

