/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ClientDataRequest;
import javax.portlet.EventRequest;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.gatein.common.http.QueryStringParser;
import org.gatein.common.util.ParameterMap;
import org.gatein.common.util.Tools;
import org.gatein.pc.portlet.impl.jsr168.Dispatch;
import org.gatein.pc.portlet.impl.jsr168.DispatchType;
import org.gatein.pc.portlet.impl.jsr168.DispatchedHttpSession;
import org.gatein.pc.portlet.impl.jsr168.DispatchedRequestDispatcher;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;

public abstract class DispatchedHttpServletRequest
extends HttpServletRequestWrapper {
    private static final int REQUEST_URI = 0;
    private static final int SERVLET_PATH = 1;
    private static final int PATH_INFO = 2;
    private static final int QUERY_STRING = 3;
    private static final int CONTEXT_PATH = 4;
    private static final String[] INCLUDE_KEYS = new String[]{"javax.servlet.include.request_uri", "javax.servlet.include.servlet_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string", "javax.servlet.include.context_path"};
    private static final String[] FORWARD_KEYS = new String[]{"javax.servlet.forward.request_uri", "javax.servlet.forward.servlet_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string", "javax.servlet.forward.context_path"};
    private static final Set<String> ALL_CONTAINER_ATTRIBUTES = new HashSet<String>();
    final DispatchType dispatchType;
    private final PortletRequest preq;
    private final HttpServletRequestWrapper dreq;
    private final Map<String, String[]> parameters;
    private final int sessionScope;
    private final LinkedList<Dispatch> dispatches;
    private String[] infos;
    private final ServletContext servletContext;
    private DispatchedHttpSession session;

    public DispatchedHttpServletRequest(Dispatch dispatch, PortletRequest preq, HttpServletRequestWrapper dreq, ServletContext servletContext) {
        super((HttpServletRequest)dreq);
        Map parameters;
        int index;
        PortletConfig config = (PortletConfig)dreq.getAttribute("javax.portlet.config");
        Map options = config.getContainerRuntimeOptions();
        String[] sessionScopeOption = (String[])options.get("javax.portlet.servletDefaultSessionScope");
        int sessionScope = 1;
        if (sessionScopeOption != null && sessionScopeOption.length > 0 && "PORTLET_SCOPE".equals(sessionScopeOption[0])) {
            sessionScope = 2;
        }
        this.dispatchType = dispatch.getType();
        this.preq = preq;
        this.dreq = dreq;
        this.servletContext = servletContext;
        this.dispatches = new LinkedList();
        this.sessionScope = sessionScope;
        this.pushDispatch(dispatch);
        String queryString = null;
        String path = dispatch.getPath();
        if (path != null && (index = path.indexOf(63)) > -1) {
            queryString = path.substring(index + 1);
        }
        if (queryString != null && queryString.length() > 0) {
            ParameterMap tmp = new ParameterMap();
            tmp.putAll((Map)QueryStringParser.getInstance().parseQueryString(queryString));
            tmp.append(preq.getParameterMap());
            parameters = tmp;
        } else {
            parameters = preq.getParameterMap();
        }
        this.parameters = parameters;
        this.infos = null;
    }

    public final String getRemoteAddr() {
        return null;
    }

    public final String getRemoteHost() {
        return null;
    }

    public final String getRealPath(String s) {
        return null;
    }

    public final String getLocalAddr() {
        return null;
    }

    public final String getLocalName() {
        return null;
    }

    public final StringBuffer getRequestURL() {
        return null;
    }

    public final int getRemotePort() {
        return 0;
    }

    public final int getLocalPort() {
        return 0;
    }

    public final String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        return pathInfo == null ? null : this.servletContext.getRealPath(pathInfo);
    }

    public final String getPathInfo() {
        return this.getSpecAttribute(2);
    }

    public final String getQueryString() {
        return this.getSpecAttribute(3);
    }

    public final String getRequestURI() {
        return this.getSpecAttribute(0);
    }

    public final String getServletPath() {
        return this.getSpecAttribute(1);
    }

    private String getSpecAttribute(int index) {
        if (this.dispatches.getFirst().getPath() == null) {
            return null;
        }
        if (this.infos != null) {
            return this.infos[index];
        }
        return (String)this.preq.getAttribute(INCLUDE_KEYS[index]);
    }

    public final String getScheme() {
        return this.preq.getScheme();
    }

    public final String getServerName() {
        return this.preq.getServerName();
    }

    public final int getServerPort() {
        return this.preq.getServerPort();
    }

    public final Object getAttribute(String s) {
        if (s != null) {
            if (ALL_CONTAINER_ATTRIBUTES.contains(s)) {
                Dispatch dispatch = this.dispatches.getLast();
                if (dispatch.getType() == DispatchType.INCLUDE) {
                    if (dispatch.getPath() == null) {
                        return null;
                    }
                    for (String key : INCLUDE_KEYS) {
                        if (!key.equals(s)) continue;
                        return this.preq.getAttribute(key);
                    }
                } else {
                    ListIterator<Dispatch> it = this.dispatches.listIterator(this.dispatches.size());
                    while (it.hasPrevious()) {
                        if (it.previous().getPath() != null) continue;
                        return null;
                    }
                    for (int i = 0; i < FORWARD_KEYS.length; ++i) {
                        if (!FORWARD_KEYS[i].equals(s)) continue;
                        if (this.infos != null) {
                            return this.infos[i];
                        }
                        return this.preq.getAttribute(INCLUDE_KEYS[i]);
                    }
                }
            }
            if (ALL_CONTAINER_ATTRIBUTES.contains(s)) {
                return null;
            }
            return this.preq.getAttribute(s);
        }
        return null;
    }

    public final Enumeration getAttributeNames() {
        String[] containerKeys;
        Set names = Tools.toSet((Enumeration)this.preq.getAttributeNames());
        names.removeAll(ALL_CONTAINER_ATTRIBUTES);
        for (String containerKey : containerKeys = this.dispatches.getLast().getType() == DispatchType.FORWARD ? FORWARD_KEYS : INCLUDE_KEYS) {
            if (this.getAttribute(containerKey) == null) continue;
            names.add(containerKey);
        }
        return Collections.enumeration(names);
    }

    public final void setAttribute(String s, Object o) {
        if (s != null && ALL_CONTAINER_ATTRIBUTES.contains(s)) {
            return;
        }
        ((PortletRequestImpl)this.preq).getAttributes().setAttribute(s, o);
    }

    public final void removeAttribute(String s) {
        this.setAttribute(s, null);
    }

    public final Locale getLocale() {
        return this.preq.getLocale();
    }

    public final Enumeration getLocales() {
        return this.preq.getLocales();
    }

    public boolean isSecure() {
        return this.preq.isSecure();
    }

    public final String getAuthType() {
        return this.preq.getAuthType();
    }

    public final String getContextPath() {
        return this.preq.getContextPath();
    }

    public final String getRemoteUser() {
        return this.preq.getRemoteUser();
    }

    public final Principal getUserPrincipal() {
        return this.preq.getUserPrincipal();
    }

    public final String getRequestedSessionId() {
        return this.preq.getRequestedSessionId();
    }

    public final boolean isRequestedSessionIdValid() {
        return this.preq.isRequestedSessionIdValid();
    }

    public final Cookie[] getCookies() {
        return this.preq.getCookies();
    }

    public final String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name must not be null");
        }
        String[] values = this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public final Enumeration getParameterNames() {
        return Tools.toEnumeration(this.parameters.keySet().iterator());
    }

    public final String[] getParameterValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name must not be null");
        }
        String[] values = this.parameters.get(name);
        if (values != null) {
            return (String[])values.clone();
        }
        return null;
    }

    public final Map getParameterMap() {
        return this.parameters;
    }

    public abstract String getCharacterEncoding();

    public abstract void setCharacterEncoding(String var1) throws UnsupportedEncodingException;

    public abstract String getContentType();

    public abstract ServletInputStream getInputStream() throws IOException;

    public abstract BufferedReader getReader() throws IOException;

    public abstract int getContentLength();

    public abstract String getMethod();

    public final String getHeader(String s) {
        return this.preq.getProperty(s);
    }

    public final Enumeration getHeaders(String s) {
        return this.preq.getProperties(s);
    }

    public final Enumeration getHeaderNames() {
        return this.preq.getPropertyNames();
    }

    public final long getDateHeader(String s) {
        return 0L;
    }

    public final int getIntHeader(String s) {
        return 0;
    }

    public final RequestDispatcher getRequestDispatcher(String s) {
        return new DispatchedRequestDispatcher(this.dreq.getRequestDispatcher(s), s);
    }

    public final boolean isUserInRole(String s) {
        return this.preq.isUserInRole(s);
    }

    public final HttpSession getSession(boolean b) {
        return this.getSession(b, this.sessionScope);
    }

    public final HttpSession getSession() {
        return this.getSession(true);
    }

    public final boolean isRequestedSessionIdFromCookie() {
        return this.dreq.isRequestedSessionIdFromCookie();
    }

    public final boolean isRequestedSessionIdFromURL() {
        return this.dreq.isRequestedSessionIdFromURL();
    }

    public final boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public final String getProtocol() {
        return "HTTP/1.1";
    }

    public final void setRequest(ServletRequest servletRequest) {
        this.dreq.setRequest(servletRequest);
    }

    public ServletRequest getRequest() {
        return this.dreq.getRequest();
    }

    void pushDispatch(Dispatch dispatch) {
        this.dispatches.addLast(dispatch);
        if (this.dispatches.size() == 2) {
            String[] infos = new String[INCLUDE_KEYS.length];
            for (int i = 0; i < INCLUDE_KEYS.length; ++i) {
                infos[i] = (String)this.preq.getAttribute(INCLUDE_KEYS[i]);
            }
            this.infos = infos;
        }
    }

    void popDispatch() {
        if (this.dispatches.size() == 2) {
            this.infos = null;
        }
        this.dispatches.removeLast();
    }

    private HttpSession getSession(boolean create, int scope) {
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session == null) {
            if (create) {
                PortletSession portletSession = this.preq.getPortletSession();
                this.session = new DispatchedHttpSession(this, portletSession, scope);
            } else {
                PortletSession portletSession = this.preq.getPortletSession(false);
                if (portletSession != null) {
                    this.session = new DispatchedHttpSession(this, portletSession, scope);
                }
            }
        }
        return this.session;
    }

    static {
        ALL_CONTAINER_ATTRIBUTES.addAll(Tools.toSet((Object[])INCLUDE_KEYS));
        ALL_CONTAINER_ATTRIBUTES.addAll(Tools.toSet((Object[])FORWARD_KEYS));
    }

    public static final class Render
    extends Mime {
        public Render(Dispatch dispatch, RenderRequest rreq, HttpServletRequestWrapper dreq, ServletContext servletContext) {
            super(dispatch, (PortletRequest)rreq, dreq, servletContext);
        }

        @Override
        public String getMethod() {
            return "GET";
        }
    }

    public static final class Event
    extends Mime {
        private final EventRequest ereq;

        public Event(Dispatch dispatch, EventRequest ereq, HttpServletRequestWrapper dreq, ServletContext servletContext) {
            super(dispatch, (PortletRequest)ereq, dreq, servletContext);
            this.ereq = ereq;
        }

        @Override
        public String getMethod() {
            return this.ereq.getMethod();
        }
    }

    public static abstract class Mime
    extends DispatchedHttpServletRequest {
        public Mime(Dispatch dispatch, PortletRequest preq, HttpServletRequestWrapper dreq, ServletContext servletContext) {
            super(dispatch, preq, dreq, servletContext);
        }

        @Override
        public final String getCharacterEncoding() {
            return null;
        }

        @Override
        public final void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        }

        @Override
        public final String getContentType() {
            return null;
        }

        @Override
        public final ServletInputStream getInputStream() throws IOException {
            return null;
        }

        @Override
        public final BufferedReader getReader() throws IOException {
            return null;
        }

        @Override
        public final int getContentLength() {
            return 0;
        }
    }

    public static final class Resource
    extends ClientData {
        public Resource(Dispatch dispatch, ResourceRequest rreq, HttpServletRequestWrapper dreq, ServletContext servletContext) {
            super(dispatch, (ClientDataRequest)rreq, dreq, servletContext);
        }
    }

    public static final class Action
    extends ClientData {
        public Action(Dispatch dispatch, ActionRequest areq, HttpServletRequestWrapper dreq, ServletContext servletContext) {
            super(dispatch, (ClientDataRequest)areq, dreq, servletContext);
        }
    }

    public static abstract class ClientData
    extends DispatchedHttpServletRequest {
        private PortletServletInputStream in;
        private final ClientDataRequest cdreq;

        public ClientData(Dispatch dispatch, ClientDataRequest cdreq, HttpServletRequestWrapper dreq, ServletContext servletContext) {
            super(dispatch, (PortletRequest)cdreq, dreq, servletContext);
            this.cdreq = cdreq;
        }

        @Override
        public final String getCharacterEncoding() {
            return this.cdreq.getCharacterEncoding();
        }

        @Override
        public final void setCharacterEncoding(String s) throws UnsupportedEncodingException {
            this.cdreq.setCharacterEncoding(s);
        }

        @Override
        public final String getContentType() {
            return this.cdreq.getContentType();
        }

        @Override
        public final ServletInputStream getInputStream() throws IOException {
            if (this.in == null) {
                this.in = new PortletServletInputStream(this.cdreq);
            }
            return this.in;
        }

        @Override
        public final BufferedReader getReader() throws IOException {
            return this.cdreq.getReader();
        }

        @Override
        public final int getContentLength() {
            return this.cdreq.getContentLength();
        }

        @Override
        public final String getMethod() {
            return this.cdreq.getMethod();
        }

        private static final class PortletServletInputStream
        extends ServletInputStream {
            private final InputStream in;

            private PortletServletInputStream(ClientDataRequest req) throws IOException {
                this.in = req.getPortletInputStream();
            }

            public final int read() throws IOException {
                return this.in.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        }
    }
}

