/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.automatic.translation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.automatic.translation.api.AutomaticTranslationComponentPlugin;
import org.exoplatform.automatic.translation.api.AutomaticTranslationService;
import org.exoplatform.automatic.translation.api.dto.AutomaticTranslationConfiguration;
import org.exoplatform.automatic.translation.api.dto.AutomaticTranslationEvent;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AutomaticTranslationServiceImpl
implements AutomaticTranslationService {
    private static final String AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR = "automaticTranslationActiveConnector";
    private static final String EXO_TRANSLATION_EVENT_TRANSLATE = "exo.automatic-translation.event.translate";
    private static final String FEATURE_NAME = "automatic-translation";
    private Map<String, AutomaticTranslationComponentPlugin> translationConnectors = new HashMap<String, AutomaticTranslationComponentPlugin>();
    private static final Log LOG = ExoLogger.getLogger(AutomaticTranslationServiceImpl.class);
    SettingService settingService;
    ExoFeatureService exoFeatureService;
    ListenerService listenerService;

    public AutomaticTranslationServiceImpl(SettingService settingService, ExoFeatureService exoFeatureService, ListenerService listenerService) {
        this.settingService = settingService;
        this.exoFeatureService = exoFeatureService;
        this.listenerService = listenerService;
    }

    public void addConnector(AutomaticTranslationComponentPlugin translationConnector) {
        this.translationConnectors.put(translationConnector.getName(), translationConnector);
    }

    public Map<String, AutomaticTranslationComponentPlugin> getConnectors() {
        return this.translationConnectors;
    }

    public AutomaticTranslationConfiguration getConfiguration() {
        String activeConnector = this.getActiveConnector();
        AutomaticTranslationConfiguration configuration = new AutomaticTranslationConfiguration(new ArrayList(), activeConnector);
        this.getConnectors().forEach((name, connector) -> {
            if (name.equals(activeConnector)) {
                configuration.setActiveApiKey(connector.getApiKey());
                configuration.addConnector(name, connector.getDescription(), connector.getApiKey());
            } else {
                configuration.addConnector(name, connector.getDescription(), null);
            }
        });
        return configuration;
    }

    public String getActiveConnector() {
        SettingValue value = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR);
        return value != null && value.getValue() != null && !value.getValue().toString().isEmpty() && this.translationConnectors.get(value.getValue().toString()) != null ? value.getValue().toString() : null;
    }

    public boolean isFeatureActive() {
        boolean isActiveFeature = this.exoFeatureService.isActiveFeature(FEATURE_NAME);
        boolean isActiveConnector = this.getActiveConnector() != null;
        boolean haveApiKey = isActiveConnector && this.translationConnectors.get(this.getActiveConnector()).getApiKey() != null && !this.translationConnectors.get(this.getActiveConnector()).getApiKey().isEmpty();
        return isActiveFeature && isActiveConnector && haveApiKey;
    }

    public void setActiveConnector(String name) {
        String finalName;
        if (!this.exoFeatureService.isActiveFeature(FEATURE_NAME)) {
            throw new RuntimeException("Unable to change automatic translation connector as feature is not active");
        }
        if (name == null) {
            name = "";
        }
        if (!(finalName = name).isBlank() && !this.translationConnectors.keySet().stream().anyMatch(connectorName -> connectorName.equals(finalName))) {
            throw new RuntimeException("Unable to change automatic translation connector as provided connector name do not exists");
        }
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR, new SettingValue((Object)name));
    }

    public void setApiKey(String connector, String apikey) {
        AutomaticTranslationComponentPlugin connectorPlugin = this.translationConnectors.get(connector);
        if (connectorPlugin == null) {
            throw new RuntimeException("Provided connector do not exists " + connector);
        }
        connectorPlugin.setApiKey(apikey);
    }

    public String translate(String message, Locale targetLang, String contentType, long spaceId) {
        String activeConnector = this.getActiveConnector();
        if (activeConnector == null) {
            throw new RuntimeException("Automatic Translation No active connector configured");
        }
        if (this.translationConnectors.get(activeConnector) == null) {
            throw new RuntimeException("Automatic Translation Connector " + activeConnector + " not found");
        }
        String translatedMessage = this.translationConnectors.get(activeConnector).translate(message, targetLang);
        if (translatedMessage != null) {
            try {
                AutomaticTranslationEvent event = new AutomaticTranslationEvent();
                event.setSpaceId(spaceId);
                event.setMessageLength(message.length());
                event.setTargetLanguage(targetLang.getLanguage());
                event.setConnectorName(this.translationConnectors.get(activeConnector).getName());
                event.setContentType(contentType);
                this.listenerService.broadcast(EXO_TRANSLATION_EVENT_TRANSLATE, (Object)this, (Object)event);
            }
            catch (Exception e) {
                LOG.error("Unable to broadcast event {}", new Object[]{EXO_TRANSLATION_EVENT_TRANSLATE, e});
            }
        }
        return translatedMessage;
    }
}

