/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class VersionHistoryUtils {
    protected static final Log log = ExoLogger.getLogger(VersionHistoryUtils.class);
    private static final int DOCUMENT_AUTO_DEFAULT_VERSION_MAX = 0;
    private static final int DOCUMENT_AUTO_DEFAULT_VERSION_EXPIRED = 0;
    public static final String NT_FILE = "nt:file";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    public static final String WEB_CONTENT = "exo:webContent";
    public static final String MIX_DISPLAY_VERSION_NAME = "mix:versionDisplayName";
    public static final String MAX_VERSION_PROPERTY = "exo:maxVersion";
    public static final String LIST_VERSION_PROPERTY = "exo:versionList";
    public static final String VERSION_SEPARATOR = ":";
    private static String maxAllowVersionProp = "jcr.documents.versions.max";
    private static String expirationTimeProp = "jcr.documents.versions.expiration";
    private static int maxAllowVersion;
    private static long maxLiveTime;

    public static Version createVersion(Node nodeVersioning) throws Exception {
        if (!nodeVersioning.isNodeType(NT_FILE) && !nodeVersioning.isNodeType(WEB_CONTENT)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Version history is not impact with non-nt:file documents, there'is not any version created.");
            }
            return null;
        }
        if (!nodeVersioning.isNodeType(MIX_VERSIONABLE)) {
            if (nodeVersioning.canAddMixin(MIX_VERSIONABLE)) {
                nodeVersioning.addMixin(MIX_VERSIONABLE);
                nodeVersioning.save();
            }
            return null;
        }
        Version version = null;
        if (!nodeVersioning.isCheckedOut()) {
            nodeVersioning.checkout();
            version = nodeVersioning.getBaseVersion();
        } else {
            version = nodeVersioning.checkin();
            nodeVersioning.checkout();
        }
        if (version != null && nodeVersioning.isNodeType(MIX_DISPLAY_VERSION_NAME)) {
            int maxVersion = 0;
            if (nodeVersioning.hasProperty(MAX_VERSION_PROPERTY)) {
                maxVersion = (int)nodeVersioning.getProperty(MAX_VERSION_PROPERTY).getLong();
                nodeVersioning.setProperty(MAX_VERSION_PROPERTY, (long)(maxVersion + 1));
            }
            String newRef = version.getName() + VERSION_SEPARATOR + maxVersion;
            ArrayList<Value> newValues = new ArrayList<Value>();
            if (nodeVersioning.hasProperty(LIST_VERSION_PROPERTY)) {
                Value[] values = nodeVersioning.getProperty(LIST_VERSION_PROPERTY).getValues();
                newValues.addAll(Arrays.asList(values));
            }
            Value value2add = nodeVersioning.getSession().getValueFactory().createValue(newRef);
            newValues.add(value2add);
            nodeVersioning.setProperty(LIST_VERSION_PROPERTY, newValues.toArray(new Value[newValues.size()]));
            nodeVersioning.save();
        }
        if (maxAllowVersion != 0 || maxLiveTime != 0L) {
            VersionHistoryUtils.removeRedundant(nodeVersioning);
        }
        nodeVersioning.save();
        return version;
    }

    public static void removeVersion(Node node, String versionName) throws RepositoryException {
        VersionHistory versionHistory = node.getVersionHistory();
        if (node.getBaseVersion().getName().equals(versionName)) {
            if (node.canAddMixin(MIX_DISPLAY_VERSION_NAME)) {
                int maxVersion = Integer.parseInt(versionName) + 1;
                node.addMixin(MIX_DISPLAY_VERSION_NAME);
                node.setProperty(MAX_VERSION_PROPERTY, (long)maxVersion);
            } else {
                VersionHistoryUtils.removeRefVersionName(node, versionName);
            }
            node.save();
        } else if (node.isNodeType(MIX_DISPLAY_VERSION_NAME)) {
            VersionHistoryUtils.removeRefVersionName(node, versionName);
            node.save();
        }
        versionHistory.removeVersion(versionName);
    }

    public static int getVersion(Node node) {
        String currentVersion = null;
        try {
            if (node.isNodeType(MIX_DISPLAY_VERSION_NAME) && node.hasProperty(MAX_VERSION_PROPERTY)) {
                int max = (int)node.getProperty(MAX_VERSION_PROPERTY).getLong();
                return max - 1;
            }
            currentVersion = node.getBaseVersion().getName();
            if (currentVersion.contains("jcr:rootVersion")) {
                currentVersion = "0";
            }
        }
        catch (Exception e) {
            currentVersion = "0";
        }
        return Integer.parseInt(currentVersion);
    }

    private static void removeRedundant(Node nodeVersioning) throws Exception {
        VersionHistory versionHistory = nodeVersioning.getVersionHistory();
        String baseVersion = nodeVersioning.getBaseVersion().getName();
        String rootVersion = nodeVersioning.getVersionHistory().getRootVersion().getName();
        VersionIterator versions = versionHistory.getAllVersions();
        Date currentDate = new Date();
        HashMap<String, String> lstVersions = new HashMap<String, String>();
        ArrayList<String> lstVersionTime = new ArrayList<String>();
        while (versions.hasNext()) {
            Version version = versions.nextVersion();
            if (rootVersion.equals(version.getName()) || baseVersion.equals(version.getName())) continue;
            if (maxLiveTime != 0L && currentDate.getTime() - version.getCreated().getTime().getTime() > maxLiveTime) {
                versionHistory.removeVersion(version.getName());
                continue;
            }
            lstVersions.put(String.valueOf(version.getCreated().getTimeInMillis()), version.getName());
            lstVersionTime.add(String.valueOf(version.getCreated().getTimeInMillis()));
        }
        if (maxAllowVersion <= lstVersionTime.size() && maxAllowVersion != 0) {
            Collections.sort(lstVersionTime);
            String[] lsts = lstVersionTime.toArray(new String[lstVersionTime.size()]);
            for (int j = 0; j <= lsts.length - maxAllowVersion; ++j) {
                versionHistory.removeVersion((String)lstVersions.get(lsts[j]));
            }
        }
    }

    private static void removeRefVersionName(Node node, String versionName) throws RepositoryException {
        if (node.hasProperty(LIST_VERSION_PROPERTY) && node.hasProperty(LIST_VERSION_PROPERTY)) {
            Value[] values = node.getProperty(LIST_VERSION_PROPERTY).getValues();
            ArrayList<Value> newValues = new ArrayList<Value>();
            for (Value value : values) {
                if (value.getString().split(VERSION_SEPARATOR)[0].equals(versionName)) continue;
                newValues.add(value);
            }
            node.setProperty(LIST_VERSION_PROPERTY, newValues.toArray(new Value[newValues.size()]));
        }
    }

    static {
        try {
            maxAllowVersion = Integer.parseInt(System.getProperty(maxAllowVersionProp));
            maxLiveTime = Integer.parseInt(System.getProperty(expirationTimeProp));
            if (maxAllowVersion < 0) {
                maxAllowVersion = 0;
            }
            if (maxLiveTime < 0L) {
                maxLiveTime = 0L;
            }
        }
        catch (NumberFormatException nex) {
            maxAllowVersion = 0;
            maxLiveTime = 0L;
        }
        maxLiveTime = maxLiveTime * 24L * 60L * 60L * 1000L;
    }
}

