/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link;

import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.exoplatform.services.cms.link.ItemLinkAware;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeIteratorLinkAware;
import org.exoplatform.services.cms.link.NodeTypeLinkAware;
import org.exoplatform.services.cms.link.PropertyIteratorLinkAware;
import org.exoplatform.services.cms.link.PropertyLinkAware;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;

public class NodeLinkAware
extends ItemLinkAware
implements ExtendedNode {
    public static final String EXO_RESTORE_LOCATION = "exo:restoreLocation";
    private static final Log LOG = ExoLogger.getLogger((String)NodeLinkAware.class.getName());
    private final NodeLocation nodeLocation;
    private volatile NodeLocation targetNodeLocation;

    public NodeLinkAware(String originalWorkspace, String virtualPath, Node node) {
        super(originalWorkspace, virtualPath, (Item)node);
        this.nodeLocation = NodeLocation.getNodeLocationByNode(node);
    }

    public String getRealPath() {
        return this.nodeLocation.getPath();
    }

    public Node getRealNode() {
        return NodeLocation.getNodeByLocation(this.nodeLocation);
    }

    public NodeLinkAware getTargetNode() throws RepositoryException {
        return new NodeLinkAware(this.originalWorkspaceName, this.virtualPath, this.getTarget());
    }

    public Session getNodeSession() throws RepositoryException {
        return this.getRealNode().getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getTarget() throws RepositoryException {
        Node targetNode = null;
        if (this.targetNodeLocation == null) {
            NodeLinkAware nodeLinkAware = this;
            synchronized (nodeLinkAware) {
                if (this.targetNodeLocation == null) {
                    Node node;
                    LinkManager linkManager = LinkUtils.getLinkManager();
                    targetNode = linkManager.isLink((Item)(node = this.getRealNode())) ? linkManager.getTarget(node) : node;
                }
            }
        }
        return targetNode;
    }

    private Node getTargetReachable() throws RepositoryException {
        block4: {
            try {
                return this.getTarget();
            }
            catch (AccessDeniedException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Cannot access to the target of the node " + this.nodeLocation.getPath()));
                }
            }
            catch (ItemNotFoundException e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)("The target of the node " + this.nodeLocation.getPath() + " doesn't exist anymore"));
            }
        }
        return null;
    }

    private ExtendedNode getExtendedTarget() throws RepositoryException {
        return (ExtendedNode)this.getTarget();
    }

    private ExtendedNode getExtendedRealNode() {
        return (ExtendedNode)this.getRealNode();
    }

    private String getVirtualPath(String relativePath) {
        return LinkUtils.createPath(this.virtualPath, relativePath);
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.getTarget().addMixin(mixinName);
    }

    public Node addNode(String relPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return new NodeLinkAware(this.originalWorkspaceName, this.getVirtualPath(relPath), this.getTarget().addNode(relPath));
    }

    public Node addNode(String relPath, String primaryNodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        return new NodeLinkAware(this.originalWorkspaceName, this.getVirtualPath(relPath), this.getTarget().addNode(relPath, primaryNodeTypeName));
    }

    public boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        return this.getTarget().canAddMixin(mixinName);
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.getTarget().cancelMerge(version);
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        return this.getTarget().checkin();
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.getTarget().checkout();
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.getTarget().doneMerge(version);
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.getTarget().getBaseVersion();
    }

    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        return this.getTarget().getCorrespondingNodePath(workspaceName);
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        return this.getTarget().getDefinition();
    }

    public int getIndex() throws RepositoryException {
        return this.getRealNode().getIndex();
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        return this.getTarget().getLock();
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        return this.getTarget().getMixinNodeTypes();
    }

    public Node getNode(String relPath) throws PathNotFoundException, RepositoryException {
        return new NodeLinkAware(this.originalWorkspaceName, this.getVirtualPath(relPath), (Node)LinkUtils.getNodeFinder().getItem(this.getNodeSession(), this.getVirtualPath(relPath)));
    }

    public NodeIterator getNodes() throws RepositoryException {
        return new NodeIteratorLinkAware(this.originalWorkspaceName, this.virtualPath, this.getTarget().getNodes());
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        return new NodeIteratorLinkAware(this.originalWorkspaceName, this.virtualPath, this.getTarget().getNodes(namePattern));
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        return ItemLinkAware.newInstance(this.originalWorkspaceName, this.getVirtualPath(super.getName()), this.getTarget().getPrimaryItem());
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        return new NodeTypeLinkAware(this);
    }

    public PropertyIterator getProperties() throws RepositoryException {
        return new PropertyIteratorLinkAware(this.originalWorkspaceName, this.virtualPath, this.getTarget().getProperties());
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        return new PropertyIteratorLinkAware(this.originalWorkspaceName, this.virtualPath, this.getTarget().getProperties(namePattern));
    }

    public Property getProperty(String relPath) throws PathNotFoundException, RepositoryException {
        String path = this.getVirtualPath(relPath);
        return new PropertyLinkAware(this.originalWorkspaceName, path, (Property)LinkUtils.getNodeFinder().getItem(this.getOriginalSession(), path));
    }

    public PropertyIterator getReferences() throws RepositoryException {
        return this.getTarget().getReferences();
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.getTarget().getUUID();
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.getTarget().getVersionHistory();
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        try {
            return LinkUtils.getNodeFinder().getItem(this.getOriginalSession(), this.getVirtualPath(relPath)) instanceof Node;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public boolean hasNodes() throws RepositoryException {
        return this.getTarget().hasNodes();
    }

    public boolean hasProperties() throws RepositoryException {
        return this.getTarget().hasProperties();
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        try {
            return LinkUtils.getNodeFinder().getItem(this.getOriginalSession(), this.getVirtualPath(relPath)) instanceof Property;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public boolean holdsLock() throws RepositoryException {
        Node node = this.getTargetReachable();
        return node == null ? false : node.holdsLock();
    }

    public boolean isCheckedOut() throws RepositoryException {
        Node node = this.getTargetReachable();
        return node == null ? false : node.isCheckedOut();
    }

    public boolean isLocked() throws RepositoryException {
        Node node = this.getTargetReachable();
        return node == null ? false : node.isLocked();
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        if (EXO_RESTORE_LOCATION.equals(nodeTypeName)) {
            return this.getRealNode().isNodeType(nodeTypeName);
        }
        Node node = this.getTargetReachable();
        return node == null ? false : node.isNodeType(nodeTypeName);
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        return this.getTarget().lock(isDeep, isSessionScoped);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return this.getTarget().merge(srcWorkspace, bestEffort);
    }

    public void orderBefore(String srcChildRelPath, String destChildRelPath) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        this.getTarget().orderBefore(srcChildRelPath, destChildRelPath);
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.getTarget().removeMixin(mixinName);
    }

    public void restore(String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.getTarget().restore(versionName, removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.getTarget().restore(version, removeExisting);
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.getTarget().restore(version, relPath, removeExisting);
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.getTarget().restoreByLabel(versionLabel, removeExisting);
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, value);
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, values);
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, values);
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, value);
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, value);
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, value);
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, value);
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, value);
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, value);
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, value);
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, value, type);
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, values, type);
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, values, type);
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.getTarget().setProperty(name, value, type);
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.getTarget().unlock();
    }

    public void update(String srcWorkspaceName) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        this.getTarget().update(srcWorkspaceName);
    }

    @Override
    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.getTarget().save();
    }

    public void checkPermission(String actions) throws AccessControlException, RepositoryException {
        this.getExtendedRealNode().checkPermission(actions);
    }

    public void clearACL() throws RepositoryException, AccessControlException {
        this.getExtendedRealNode().clearACL();
    }

    public AccessControlList getACL() throws RepositoryException {
        return this.getExtendedRealNode().getACL();
    }

    public boolean isNodeType(InternalQName name) throws RepositoryException {
        ExtendedNode node = (ExtendedNode)this.getTargetReachable();
        return node == null ? false : node.isNodeType(name);
    }

    public Lock lock(boolean isDeep, long timeOut) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        return this.getExtendedTarget().lock(isDeep, timeOut);
    }

    public void removePermission(String identity) throws RepositoryException, AccessControlException {
        this.getExtendedRealNode().removePermission(identity);
    }

    public void removePermission(String identity, String permission) throws RepositoryException, AccessControlException {
        this.getExtendedRealNode().removePermission(identity, permission);
    }

    public void setPermission(String identity, String[] permission) throws RepositoryException, AccessControlException {
        this.getExtendedRealNode().setPermission(identity, permission);
    }

    public void setPermissions(Map<String, String[]> permissions) throws RepositoryException, AccessControlException {
        this.getExtendedRealNode().setPermissions(permissions);
    }

    public String getIdentifier() throws RepositoryException {
        ExtendedNode node = (ExtendedNode)this.getTarget();
        return node.getIdentifier();
    }

    public NodeIterator getNodesLazily() throws RepositoryException {
        ExtendedNode node = (ExtendedNode)this.getTarget();
        return node.getNodesLazily();
    }

    public NodeIterator getNodesLazily(int pageSize) throws RepositoryException {
        ExtendedNode node = (ExtendedNode)this.getTarget();
        return node.getNodesLazily(pageSize);
    }

    public long getNodesCount() throws RepositoryException {
        ExtendedNode node = (ExtendedNode)this.getTarget();
        return node.getNodesCount();
    }
}

