/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.FileAccessor;
import com.datical.liquibase.ext.checks.config.FileAccessor$FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.IFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.Yaml;

public class CheckSettingsConfigHelper {
    public static final String LIQUIBASE_CHECKS_SETTINGS_CONF = "liquibase.checks-settings.conf";
    private final String checkSettingsFilename;
    private String autoUpdate;
    private final IFileAccessor fileAccessor;
    private final Yaml yaml = new Yaml();

    public CheckSettingsConfigHelper(String string, String string2) {
        this.fileAccessor = new FileAccessor();
        this.checkSettingsFilename = StringUtil.isEmpty(string) ? LIQUIBASE_CHECKS_SETTINGS_CONF : string;
        this.autoUpdate = string2;
    }

    public CheckSettingsConfig read(List<AbstractLiquibaseRule> list) {
        boolean bl2;
        CheckSettingsConfig checkSettingsConfig;
        Object object;
        try {
            object = this.fileAccessor.loadFileContents(this.checkSettingsFilename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = Scope.getCurrentScope().getUI().prompt(this.checkSettingsFilename + " does not exist." + System.lineSeparator() + "Would you like to create it? (Y/n)", "Y", (string, clazz) -> {
                if (string == null || !string.equalsIgnoreCase("y") && !string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("n") && !string.equalsIgnoreCase("no")) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class);
            if (string2 != null && (string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes"))) {
                this.write(CheckSettingsConfig.generateDefaultConfigFromRules(list));
                Scope.getCurrentScope().getUI().sendMessage(this.checkSettingsFilename + " successfully created!");
                FileAccessor$FileAccessorDTO fileAccessor$FileAccessorDTO = this.fileAccessor.loadFileContents(this.checkSettingsFilename);
                return (CheckSettingsConfig)this.yaml.loadAs(fileAccessor$FileAccessorDTO.contents, CheckSettingsConfig.class);
            }
            Scope.getCurrentScope().getUI().sendMessage("No changes have been made to default check configuration.");
            return null;
        }
        try {
            checkSettingsConfig = (CheckSettingsConfig)this.yaml.loadAs(((FileAccessor$FileAccessorDTO)object).contents, CheckSettingsConfig.class);
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to read the quality checks config file", exception);
            throw new CommandExecutionException("Liquibase cannot read '" + this.checkSettingsFilename + "'. The file may be corrupted or an incompatible version. Delete or rename the existing liquibase.checks-settings.conf. Generate a new liquibase.checks-settings.conf by running 'liquibase checks show'.");
        }
        Object object2 = checkSettingsConfig.getRules();
        if (!((FileAccessor$FileAccessorDTO)object).versioned) {
            object2.forEach(abstractConfigurableRule -> abstractConfigurableRule.setSeverity(SeverityEnum.INFO));
            this.write(checkSettingsConfig);
        }
        if (((FileAccessor$FileAccessorDTO)object).encoded) {
            this.write(checkSettingsConfig);
        }
        boolean bl3 = bl2 = this.autoUpdate == null || !this.autoUpdate.equalsIgnoreCase("off");
        if (!this.upToDate(list, (List<AbstractConfigurableRule>)object2)) {
            if (this.autoUpdate == null) {
                object2 = Scope.getCurrentScope().getUI().prompt(System.lineSeparator() + "New Quality Checks are available." + System.lineSeparator() + "Do you want auto-backup and update '" + this.checkSettingsFilename + "' with the new checks? (Y/n/s)", "Y", (string, clazz) -> {
                    if (!(string != null && (string.equalsIgnoreCase("y") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("s") || string.equalsIgnoreCase("skip")))) {
                        throw new IllegalArgumentException();
                    }
                    return string;
                }, String.class).toLowerCase();
                if (((String)object2).startsWith("n")) {
                    this.updatePropertiesFile("\nliquibase.command.autoUpdate=off\n");
                    bl2 = false;
                } else if (((String)object2).startsWith("s")) {
                    bl2 = false;
                }
            }
            if (bl2) {
                File comparable = CheckSettingsConfigHelper.calcBackupFile(new File(this.checkSettingsFilename));
                object = "Quality Checks Version: 1.0\nIMPORTANT: DO NOT MODIFY THIS FILE DIRECTLY. UNRECOVERABLE and UNSUPPORTED ERRORS ARE LIKELY IF YOU EDIT THIS FILE DIRECTLY.\nThis file is created and modified by running commands in the Liquibase CLI.\nFor help using quality checks, visit the documentation at https://docs.liquibase.com/quality-checks\n\n-----------------------------------------------------------------------------------------------\n" + ((FileAccessor$FileAccessorDTO)object).contents;
                FileAccessor.makeBackup(comparable, (String)object, null);
            }
        }
        for (AbstractLiquibaseRule abstractLiquibaseRule : list) {
            object = checkSettingsConfig.getRuleById(abstractLiquibaseRule.getId());
            if (object == null || ((AbstractConfigurableRule)object).getSeverity() == abstractLiquibaseRule.getSeverity()) continue;
            abstractLiquibaseRule.setSeverity(((AbstractConfigurableRule)object).getSeverity());
        }
        if (!bl2) {
            return checkSettingsConfig;
        }
        if (this.addMissingRules(list, checkSettingsConfig)) {
            this.write(checkSettingsConfig);
        }
        this.sortRulesByPriority(list, checkSettingsConfig);
        return checkSettingsConfig;
    }

    private void updatePropertiesFile(String object) {
        String string = LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getCurrentConfiguredValue().getValue();
        File file = null;
        if (string != null) {
            file = new File(string);
        }
        if (file == null) {
            return;
        }
        string = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        Throwable throwable = null;
        try {
            randomAccessFile.seek(file.length());
            randomAccessFile.write(((String)object).getBytes(string));
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    randomAccessFile.close();
                }
                throw throwable3;
            }
        }
        randomAccessFile.close();
        return;
    }

    private boolean upToDate(List<AbstractLiquibaseRule> list, List<AbstractConfigurableRule> list2) {
        return list.stream().allMatch(abstractLiquibaseRule -> list2.stream().anyMatch(abstractConfigurableRule -> abstractLiquibaseRule.getId().equals(abstractConfigurableRule.getId())));
    }

    private static File calcBackupFile(File file) {
        int n2 = 1;
        Object object = Pattern.compile("(.*).backup.([0-9])+$").matcher(file.getName());
        if (((Matcher)object).matches()) {
            String string = ((Matcher)object).group(2);
            n2 = Integer.parseInt(string) + 1;
            object = new File(file.getParentFile(), file.getName().replaceAll("backup\\." + CheckSettingsConfigHelper.newVersion(Integer.parseInt(string)), "backup." + CheckSettingsConfigHelper.newVersion(n2)));
        } else {
            object = new File(file.getParentFile(), file.getName() + ".backup." + CheckSettingsConfigHelper.newVersion(1));
        }
        boolean bl2 = true;
        while (bl2) {
            bl2 = ((File)object).exists();
            if (!bl2) continue;
            object = new File(file.getParentFile(), file.getName() + ".backup." + CheckSettingsConfigHelper.newVersion(++n2));
        }
        return object;
    }

    private static String newVersion(int n2) {
        if (n2 < 10) {
            return "0".concat(String.valueOf(n2));
        }
        return Integer.toString(n2);
    }

    public CheckSettingsConfigHelper(IFileAccessor iFileAccessor) {
        this.fileAccessor = iFileAccessor;
        this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
    }

    private void sortRulesByPriority(List<AbstractLiquibaseRule> object, CheckSettingsConfig checkSettingsConfig) {
        ArrayList<AbstractConfigurableRule> arrayList = new ArrayList<AbstractConfigurableRule>(checkSettingsConfig.getRules().size());
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
                arrayList.addAll(checkSettingsConfig.getExecutableRulesByRuleId(abstractLiquibaseRule.getId()));
            }
        }
        CheckSettingsConfig checkSettingsConfig2 = checkSettingsConfig;
        checkSettingsConfig2.setUnrecognizedRules(checkSettingsConfig2.getRules().stream().filter(abstractConfigurableRule -> !arrayList.contains(abstractConfigurableRule)).collect(Collectors.toList()));
        checkSettingsConfig.setRules(arrayList);
    }

    private boolean addMissingRules(List<AbstractLiquibaseRule> object, CheckSettingsConfig checkSettingsConfig) {
        boolean bl2 = false;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
                if (checkSettingsConfig.getRuleById(abstractLiquibaseRule.getId()) != null) continue;
                bl2 = checkSettingsConfig.getRules().add(AbstractConfigurableRule.fromRuleImplementation(abstractLiquibaseRule));
            }
        }
        return bl2;
    }

    public void write(CheckSettingsConfig object) {
        object = this.yaml.dump(object);
        this.fileAccessor.writeFileContents(this.checkSettingsFilename, (String)object);
    }
}

