/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.measure.Unit;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.ChannelDecoder;
import org.apache.sis.internal.netcdf.impl.DimensionInfo;
import org.apache.sis.internal.netcdf.impl.GridInfo;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.HyperRectangleReader;
import org.apache.sis.internal.storage.io.Region;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;

final class VariableInfo
extends Variable
implements Comparable<VariableInfo> {
    private static final String[] DESCRIPTION_ATTRIBUTES = new String[]{"long_name", "description", "title", "standard_name"};
    private final HyperRectangleReader reader;
    private final String name;
    final DimensionInfo[] dimensions;
    private long offsetToNextRecord;
    private final Map<String, Object> attributes;
    private final DataType dataType;
    GridInfo grid;
    boolean isCoordinateSystemAxis;
    private transient Vector values;
    private final String[] meanings;

    VariableInfo(Decoder decoder, ChannelDataInput channelDataInput, String string, DimensionInfo[] dimensionInfoArray, Map<String, Object> map, DataType dataType, int n, long l) throws DataStoreContentException {
        super(decoder);
        Object object;
        this.name = string;
        this.dimensions = dimensionInfoArray;
        this.attributes = map;
        Object object2 = this.getAttributeValue("_Unsigned", "_unsigned");
        if (object2 instanceof String) {
            dataType = dataType.unsigned(Boolean.valueOf((String)object2));
        }
        this.dataType = dataType;
        if (dataType != null && (this.offsetToNextRecord = (long)dataType.size()) != 0L) {
            for (int i = 0; i < dimensionInfoArray.length; ++i) {
                DimensionInfo dimensionInfo = dimensionInfoArray[i];
                if (!dimensionInfo.isUnlimited) {
                    this.offsetToNextRecord = Math.multiplyExact(this.offsetToNextRecord, dimensionInfo.length());
                    continue;
                }
                if (i == 0) continue;
                throw new DataStoreContentException(this.getLocale(), "netCDF", channelDataInput.filename, null);
            }
            this.reader = new HyperRectangleReader(dataType.number, channelDataInput, l);
        } else {
            this.reader = null;
        }
        if (n != -1) {
            long l2 = this.paddedSize();
            long l3 = Integer.toUnsignedLong(n);
            if (l3 != l2) {
                if (l2 != 0L) {
                    this.warning(ChannelDecoder.class, "readVariables", (short)8, this.getFilename(), string, l3 - l2);
                }
                if (l3 > this.offsetToNextRecord) {
                    this.offsetToNextRecord = l3;
                }
            }
        }
        if (dimensionInfoArray.length == 1) {
            Object object3 = this.getAttributeValue("_CoordinateAliasForDimension", "_coordinatealiasfordimension");
            if (object3 == null && (object3 = this.getAttributeValue("_CoordinateVariableAlias", "_coordinatevariablealias")) == null) {
                object3 = string;
            }
            this.isCoordinateSystemAxis = dimensionInfoArray[0].name.equals(object3);
        }
        if (!map.isEmpty() && (object = map.remove("flag_meanings")) != null) {
            this.meanings = (String[])CharSequences.split((CharSequence)object.toString(), (char)' ');
            return;
        }
        this.meanings = null;
    }

    private long paddedSize() {
        return Math.addExact(this.offsetToNextRecord, 3L) & 0xFFFFFFFFFFFFFFFCL;
    }

    static void complete(VariableInfo[] variableInfoArray) {
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
        VariableInfo[] variableInfoArray2 = new VariableInfo[variableInfoArray.length];
        int n = 0;
        long l = 0L;
        boolean bl = false;
        for (VariableInfo variableInfo : variableInfoArray) {
            hashSet.addAll(Arrays.asList(variableInfo.getCoordinateVariables()));
            if (!variableInfo.isUnlimited()) continue;
            long l2 = variableInfo.paddedSize();
            variableInfoArray2[n++] = variableInfo;
            bl |= l2 == 0L;
            l = Math.addExact(l, l2);
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                variableInfoArray2[i].offsetToNextRecord = -1L;
            }
        } else if (n == 1) {
            variableInfoArray2[0].offsetToNextRecord = 0L;
        } else {
            for (int i = 0; i < n; ++i) {
                variableInfoArray2[i].offsetToNextRecord = l - variableInfoArray2[i].offsetToNextRecord;
            }
        }
        if (!hashSet.isEmpty()) {
            for (VariableInfo variableInfo : variableInfoArray) {
                if (!hashSet.remove(variableInfo.name)) continue;
                variableInfo.isCoordinateSystemAxis = true;
                if (hashSet.isEmpty()) break;
            }
        }
    }

    @Override
    public String getFilename() {
        String string;
        if (this.reader != null && (string = this.reader.filename()) != null) {
            return string;
        }
        return super.getFilename();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        for (String string : DESCRIPTION_ATTRIBUTES) {
            String string2 = this.getAttributeAsString(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    @Override
    protected String getUnitsString() {
        return this.getAttributeAsString("units");
    }

    @Override
    protected Unit<?> parseUnit(String string) {
        Matcher matcher = TIME_UNIT_PATTERN.matcher(string);
        if (matcher.matches()) {
            this.epoch = StandardDateFormat.parseInstantUTC((CharSequence)matcher.group(2));
            string = matcher.group(1);
        }
        return Units.valueOf((String)string);
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    final boolean isEnumeration() {
        return this.meanings != null;
    }

    @Override
    protected boolean isUnlimited() {
        return this.dimensions.length != 0 && this.dimensions[0].isUnlimited;
    }

    @Override
    protected boolean isCoordinateSystemAxis() {
        return this.isCoordinateSystemAxis;
    }

    final String getAxisType() {
        Object object = this.getAttributeValue("_CoordinateAxisType", "_coordinateaxistype");
        return object instanceof String ? (String)object : null;
    }

    final CharSequence[] getCoordinateVariables() {
        return CharSequences.split((CharSequence)this.getAttributeAsString("coordinates"), (char)' ');
    }

    @Override
    protected Grid getGrid(Variable.Adjustment adjustment) throws IOException, DataStoreException {
        if (this.grid == null) {
            this.decoder.getGrids();
            if (this.grid == null) {
                this.grid = (GridInfo)super.getGrid(adjustment);
            }
        }
        return this.grid;
    }

    @Override
    public List<Dimension> getGridDimensions() {
        return UnmodifiableArrayList.wrap((Object[])this.dimensions);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public Class<?> getAttributeType(String string) {
        return Classes.getClass((Object)this.getAttributeValue(string));
    }

    private Object getAttributeValue(String string, String string2) {
        Object object = this.getAttributeValue(string);
        if (object == null) {
            object = this.attributes.get(string2);
        }
        return object;
    }

    @Override
    protected Object getAttributeValue(String string) {
        return this.attributes.get(string);
    }

    final void setValues(Object object) {
        int n;
        Vector vector = VariableInfo.createDecimalVector(object, this.dataType.isUnsigned);
        double d = 0.0;
        if (Numbers.isFloat((Class)vector.getElementType()) && (n = vector.size() - 1) >= 0) {
            double d2 = vector.doubleValue(0);
            double d3 = vector.doubleValue(n);
            double d4 = Math.abs((d3 - d2) / (double)n);
            if (!Double.isNaN(d4)) {
                double d5 = Math.ulp(Math.max(Math.abs(d2), Math.abs(d3)));
                d = Math.min(d4, d5);
            }
        }
        this.values = vector.compress(d);
        this.values = (Vector)SHARED_VECTORS.unique((Object)this.values);
    }

    @Override
    public Vector read() throws IOException, DataStoreContentException {
        if (this.values == null) {
            float[] fArray;
            if (this.reader == null) {
                throw new DataStoreContentException(this.unknownType());
            }
            int n = this.dimensions.length;
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                lArray2[i] = this.dimensions[n - 1 - i].length();
                nArray[i] = 1;
            }
            Region region = new Region(lArray2, lArray, lArray2, nArray);
            this.applyUnlimitedDimensionStride(region);
            Object object = this.reader.read(region);
            this.replaceNaN(object);
            if (object instanceof double[] && (fArray = ArraysExt.copyAsFloatsIfLossless((double[])((double[])object))) != null) {
                object = fArray;
            }
            this.setValues(object);
        }
        return this.values;
    }

    private void applyUnlimitedDimensionStride(Region region) throws DataStoreContentException {
        if (this.isUnlimited()) {
            int n = this.reader.dataSize();
            if (this.offsetToNextRecord < 0L || this.offsetToNextRecord % (long)n != 0L) {
                throw new DataStoreContentException(this.resources().getString((short)6, this.getFilename(), this.name));
            }
            region.increaseStride(this.dimensions.length - 1, this.offsetToNextRecord / (long)n);
        }
    }

    @Override
    public Vector read(GridExtent gridExtent, int[] nArray) throws IOException, DataStoreException {
        if (this.reader == null) {
            throw new DataStoreContentException(this.unknownType());
        }
        if (this.values != null) {
            throw new DataStoreException();
        }
        int n = this.dimensions.length;
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        long[] lArray3 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray2[i] = gridExtent.getLow(i);
            lArray3[i] = Math.incrementExact(gridExtent.getHigh(i));
            lArray[i] = this.dimensions[n - 1 - i].length();
        }
        Region region = new Region(lArray, lArray2, lArray3, nArray);
        this.applyUnlimitedDimensionStride(region);
        Object object = this.reader.read(region);
        this.replaceNaN(object);
        return Vector.create((Object)object, (boolean)this.dataType.isUnsigned);
    }

    @Override
    protected double coordinateForAxis(int n, int n2) throws IOException, DataStoreException {
        assert (n >= 0 && n < this.dimensions[0].length) : n;
        assert (n2 >= 0 && n2 < this.dimensions[1].length) : n2;
        long l = this.dimensions[1].length();
        return this.read().doubleValue(Math.toIntExact((long)n2 + l * (long)n));
    }

    final String meaning(int n) {
        return n >= 0 && n < this.meanings.length ? this.meanings[n] : null;
    }

    private String unknownType() {
        return this.resources().getString((short)5, this.getFilename(), this.name, (Object)this.dataType);
    }

    @Override
    public int compareTo(VariableInfo variableInfo) {
        int n = Long.compare(this.reader.origin, variableInfo.reader.origin);
        if (n == 0) {
            n = this.name.compareTo(variableInfo.name);
        }
        return n;
    }
}

