/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.onboarding;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.login.UIParamsExtension;
import org.exoplatform.web.security.security.SecureRandomService;

public class OnboardingUIParamsForRegister
implements UIParamsExtension {
    public static final String ONBOARDING_ENABLED_PARAM = "enabled";
    public static final String ONBOARDING_REGISTER_ENABLED = "onboardingRegisterEnabled";
    public static final String ONBOARDING_REGISTER_TOKEN = "onboardingRegisterToken";
    private static final List<String> EXTENSION_NAMES = Arrays.asList("RegisterExtension");
    private SecureRandomService secureRandomService;
    private boolean registerEnabled;

    public OnboardingUIParamsForRegister(SecureRandomService secureRandomService, InitParams params) {
        this.secureRandomService = secureRandomService;
        if (params != null && params.containsKey((Object)ONBOARDING_ENABLED_PARAM)) {
            this.registerEnabled = Boolean.parseBoolean(params.getValueParam(ONBOARDING_ENABLED_PARAM).getValue());
        }
    }

    @Override
    public List<String> getExtensionNames() {
        return EXTENSION_NAMES;
    }

    @Override
    public Map<String, Object> extendParameters(ControllerContext controllerContext, String extensionName) {
        if (this.registerEnabled) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("registerEnabled", true);
            params.put(ONBOARDING_REGISTER_ENABLED, true);
            if (controllerContext.getRequest().getAttribute("onBoardingEmailSent") == Boolean.TRUE) {
                params.put("onBoardingEmailSent", true);
            }
            params.put(ONBOARDING_REGISTER_TOKEN, this.generateRegisterToken(controllerContext.getRequest().getSession(true)));
            return params;
        }
        return Collections.emptyMap();
    }

    public String generateRegisterToken(HttpSession session) {
        Object token = this.getRegisterToken(session);
        if (token != null) {
            return token;
        }
        SecureRandom secureRandom = this.secureRandomService.getSecureRandom();
        token = secureRandom.nextLong() + "-" + secureRandom.nextLong() + "-" + secureRandom.nextLong();
        session.setAttribute(ONBOARDING_REGISTER_TOKEN, token);
        return token;
    }

    public String getRegisterToken(HttpSession session) {
        return session == null ? null : (String)session.getAttribute(ONBOARDING_REGISTER_TOKEN);
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }
}

