/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.CNDStreamReader;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.CNDStreamWriter;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.UpdateNodeTypeObserver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CNDNodeTypeDataPersister
implements NodeTypeDataPersister {
    private static final Log LOG = ExoLogger.getLogger(CNDNodeTypeDataPersister.class);
    private final InputStream is;
    private final OutputStream os;
    private final NamespaceRegistryImpl namespaceRegistry;

    public CNDNodeTypeDataPersister(InputStream is, OutputStream os, NamespaceRegistryImpl namespaceRegistry) {
        this.is = is;
        this.os = os;
        this.namespaceRegistry = namespaceRegistry;
    }

    public CNDNodeTypeDataPersister(OutputStream os, NamespaceRegistryImpl namespaceRegistry) {
        this(null, os, namespaceRegistry);
    }

    public CNDNodeTypeDataPersister(InputStream is, NamespaceRegistryImpl namespaceRegistry) {
        this(is, null, namespaceRegistry);
    }

    public CNDNodeTypeDataPersister(OutputStream os) {
        this(null, os, new NamespaceRegistryImpl());
    }

    public CNDNodeTypeDataPersister(InputStream is) {
        this(is, null, new NamespaceRegistryImpl());
    }

    @Override
    public void addNodeType(NodeTypeData nodeType) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public boolean hasNodeType(InternalQName nodeTypeName) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public boolean isStorageFilled() {
        return true;
    }

    @Override
    public void addNodeTypes(List<NodeTypeData> nodeTypes) throws RepositoryException {
        new CNDStreamWriter(this.namespaceRegistry).write(nodeTypes, this.os);
    }

    @Override
    public void removeNodeType(NodeTypeData nodeType) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public List<NodeTypeData> getAllNodeTypes() throws RepositoryException {
        return new CNDStreamReader(this.namespaceRegistry).read(this.is);
    }

    @Override
    public void update(List<NodeTypeData> nodeTypes, UpdateNodeTypeObserver observer) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public NodeTypeData getNodeType(InternalQName nodeTypeName) throws RepositoryException {
        return null;
    }
}

