/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.ManagedAppRegistration;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ManagedAppRegistrationRequestBuilder;

public class ManagedAppRegistrationCollectionRequest
extends BaseCollectionRequest<ManagedAppRegistrationCollectionResponse, IManagedAppRegistrationCollectionPage>
implements IManagedAppRegistrationCollectionRequest {
    public ManagedAppRegistrationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedAppRegistrationCollectionResponse.class, IManagedAppRegistrationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedAppRegistrationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ManagedAppRegistrationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedAppRegistrationCollectionPage get() throws ClientException {
        ManagedAppRegistrationCollectionResponse response = (ManagedAppRegistrationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedAppRegistration newManagedAppRegistration, ICallback<ManagedAppRegistration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedAppRegistrationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedAppRegistration, callback);
    }

    @Override
    public ManagedAppRegistration post(ManagedAppRegistration newManagedAppRegistration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedAppRegistrationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedAppRegistration);
    }

    @Override
    public IManagedAppRegistrationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IManagedAppRegistrationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IManagedAppRegistrationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IManagedAppRegistrationCollectionPage buildFromResponse(ManagedAppRegistrationCollectionResponse response) {
        ManagedAppRegistrationCollectionRequestBuilder builder = response.nextLink != null ? new ManagedAppRegistrationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedAppRegistrationCollectionPage page = new ManagedAppRegistrationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

