/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;

public class RangeSet<E extends Comparable<? super E>>
extends AbstractSet<Range<E>>
implements CheckedContainer<Range<E>>,
SortedSet<Range<E>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7493555225994855486L;
    protected final Class<E> elementType;
    private final byte elementCode;
    protected final boolean isMinIncluded;
    protected final boolean isMaxIncluded;
    private Object array;
    private transient int length;
    private transient int modCount;

    protected RangeSet(Class<E> clazz, boolean bl, boolean bl2) {
        ArgumentChecks.ensureNonNull("elementType", clazz);
        assert (Comparable.class.isAssignableFrom(clazz)) : clazz;
        this.elementType = clazz;
        this.elementCode = Numbers.getEnumConstant(clazz);
        this.isMinIncluded = bl;
        this.isMaxIncluded = bl2;
        if (!bl && !bl2) {
            throw new IllegalArgumentException("Open intervals are not yet supported.");
        }
    }

    public static <E extends Comparable<? super E>> RangeSet<E> create(Class<E> clazz, boolean bl, boolean bl2) {
        ArgumentChecks.ensureNonNull("elementType", clazz);
        if (Number.class.isAssignableFrom(clazz)) {
            return new Numeric<E>(clazz, bl, bl2);
        }
        return new RangeSet<E>(clazz, bl, bl2);
    }

    @Override
    public final Class<Range<E>> getElementType() {
        return Range.class;
    }

    @Override
    public Comparator<Range<E>> comparator() {
        return Compare.INSTANCE;
    }

    @Override
    public void clear() {
        if (this.array instanceof Object[]) {
            Arrays.fill((Object[])this.array, 0, this.length, null);
        }
        this.length = 0;
        ++this.modCount;
    }

    @Override
    public int size() {
        assert ((this.length & 1) == 0);
        return this.length >>> 1;
    }

    private void reallocate() {
        if (this.length == 0) {
            this.array = null;
        } else {
            Object object = this.array;
            this.array = Array.newInstance(object.getClass().getComponentType(), this.length);
            System.arraycopy(object, 0, this.array, 0, this.length);
        }
    }

    public final void trimToSize() {
        if (this.array != null && Array.getLength(this.array) != this.length) {
            this.reallocate();
            assert (this.isSorted());
        }
    }

    private void insertAt(int n, E e, E e2) {
        Object object = this.array;
        int n2 = Array.getLength(object);
        if (this.length + 2 > n2) {
            this.array = Array.newInstance(object.getClass().getComponentType(), 2 * Math.max(n2, 8));
            System.arraycopy(object, 0, this.array, 0, n);
        }
        System.arraycopy(object, n, this.array, n + 2, this.length - n);
        Array.set(this.array, n, e);
        Array.set(this.array, n + 1, e2);
        this.length += 2;
        ++this.modCount;
    }

    private void removeAt(int n, int n2) {
        int n3 = this.length;
        System.arraycopy(this.array, n2, this.array, n, n3 - n2);
        this.length -= n2 - n;
        if (this.array instanceof Object[]) {
            Arrays.fill((Object[])this.array, this.length, n3, null);
        }
        ++this.modCount;
    }

    private boolean isSorted() {
        if (this.array == null) {
            return true;
        }
        boolean bl = this.isMinIncluded | this.isMaxIncluded;
        switch (this.elementCode) {
            case 9: {
                return ArraysExt.isSorted((double[])this.array, bl);
            }
            case 8: {
                return ArraysExt.isSorted((float[])this.array, bl);
            }
            case 6: {
                return ArraysExt.isSorted((long[])this.array, bl);
            }
            case 5: {
                return ArraysExt.isSorted((int[])this.array, bl);
            }
            case 4: {
                return ArraysExt.isSorted((short[])this.array, bl);
            }
            case 3: {
                return ArraysExt.isSorted((byte[])this.array, bl);
            }
            case 2: {
                return ArraysExt.isSorted((char[])this.array, bl);
            }
        }
        return ArraysExt.isSorted((Comparable[])((Comparable[])this.array), (boolean)bl);
    }

    final int binarySearch(E e, int n, int n2) {
        switch (this.elementCode) {
            case 9: {
                return Arrays.binarySearch((double[])this.array, n, n2, (Double)e);
            }
            case 8: {
                return Arrays.binarySearch((float[])this.array, n, n2, ((Float)e).floatValue());
            }
            case 6: {
                return Arrays.binarySearch((long[])this.array, n, n2, (Long)e);
            }
            case 5: {
                return Arrays.binarySearch((int[])this.array, n, n2, (Integer)e);
            }
            case 4: {
                return Arrays.binarySearch((short[])this.array, n, n2, (Short)e);
            }
            case 3: {
                return Arrays.binarySearch((byte[])this.array, n, n2, (Byte)e);
            }
            case 2: {
                return Arrays.binarySearch((char[])this.array, n, n2, ((Character)e).charValue());
            }
        }
        return Arrays.binarySearch((Object[])this.array, n, n2, e);
    }

    private static <E extends Comparable<? super E>> void ensureOrdered(E e, E e2) {
        if (e.compareTo(e2) > 0) {
            throw new IllegalArgumentException(Errors.format((short)60, e, e2));
        }
    }

    @Override
    public boolean add(Range<E> range) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("range", range);
        if (range.isEmpty()) {
            return false;
        }
        if (range.isMinIncluded() != this.isMinIncluded || range.isMaxIncluded() != this.isMaxIncluded) {
            throw new IllegalArgumentException(Errors.format((short)45, "range", range));
        }
        return this.add(range.getMinValue(), range.getMaxValue());
    }

    public boolean add(E e, E e2) throws IllegalArgumentException {
        int n;
        ArgumentChecks.ensureNonNull("minValue", e);
        ArgumentChecks.ensureNonNull("maxValue", e2);
        if (this.array == null) {
            RangeSet.ensureOrdered(e, e2);
            Class<Object> clazz = this.elementType;
            if (clazz != Boolean.class) {
                clazz = Numbers.wrapperToPrimitive(clazz);
            }
            this.array = Array.newInstance(clazz, 8);
            Array.set(this.array, 0, e);
            Array.set(this.array, 1, e2);
            this.length = 2;
            ++this.modCount;
            return true;
        }
        int n2 = this.modCount;
        int n3 = this.binarySearch(e, 0, this.length);
        int n4 = this.binarySearch(e2, n3 >= 0 ? n3 : ~n3, this.length);
        if (n3 < 0 && ((n3 ^= 0xFFFFFFFF) & 1) == 0) {
            if (n3 == ~n4) {
                RangeSet.ensureOrdered(e, e2);
                this.insertAt(n3, e, e2);
                return true;
            }
            Array.set(this.array, n3, e);
            ++this.modCount;
        }
        n3 &= 0xFFFFFFFE;
        if (n4 < 0 && ((n4 ^= 0xFFFFFFFF) & 1) == 0) {
            Array.set(this.array, --n4, e2);
            ++this.modCount;
        }
        n4 |= 1;
        assert (this.getValue(n3).compareTo(e2) <= 0);
        assert (this.getValue(n4).compareTo(e) >= 0);
        if ((n = n4 - ++n3) != 0) {
            this.removeAt(n3, n4);
        }
        assert (Array.getLength(this.array) >= this.length && (this.length & 1) == 0) : this.length;
        return n2 != this.modCount;
    }

    @Override
    public boolean remove(Object object) {
        Range range;
        if (object instanceof Range && (range = (Range)object).getElementType() == this.elementType) {
            if (range.isMinIncluded() == this.isMaxIncluded || range.isMaxIncluded() == this.isMinIncluded) {
                throw new IllegalArgumentException(Errors.format((short)45, "object", range));
            }
            return this.remove(range.getMinValue(), range.getMaxValue());
        }
        return false;
    }

    public boolean remove(E e, E e2) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("minValue", e);
        ArgumentChecks.ensureNonNull("maxValue", e2);
        if (this.length == 0) {
            return false;
        }
        RangeSet.ensureOrdered(e, e2);
        int n = this.binarySearch(e, 0, this.length);
        int n2 = this.binarySearch(e2, n >= 0 ? n : ~n, this.length);
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        if ((n & 1) == 0) {
            if ((n2 & 1) == 0) {
                this.removeAt(n, n2);
            } else {
                this.removeAt(n, n2 & 0xFFFFFFFE);
                Array.set(this.array, n, e2);
            }
        } else if ((n2 & 1) == 0) {
            this.removeAt(n + 1, n2);
            Array.set(this.array, n, e);
        } else if (n == n2) {
            this.insertAt(n2 + 1, e2, this.getValue(n2));
            Array.set(this.array, n, e);
        } else {
            int n3 = n2 - n;
            assert (n3 >= 2) : n3;
            if (n3 > 2) {
                this.removeAt(n + 1, n2 & 0xFFFFFFFE);
            }
            Array.set(this.array, n, e);
            Array.set(this.array, n + 1, e2);
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        Range range;
        if (object instanceof Range && (range = (Range)object).getElementType() == this.elementType) {
            return this.contains(range, false);
        }
        return false;
    }

    public boolean contains(Range<E> range, boolean bl) {
        ArgumentChecks.ensureNonNull("range", range);
        if (bl) {
            int n;
            if (range.isMinIncluded() && !range.isMaxIncluded() && (n = this.binarySearch(range.getMinValue(), 0, this.length)) >= 0 && (n & 1) == 0) {
                return this.getValue(n + 1).compareTo(range.getMaxValue()) == 0;
            }
        } else if (!range.isEmpty()) {
            int n = this.binarySearch(range.getMinValue(), 0, this.length);
            if (n < 0 ? ((n ^= 0xFFFFFFFF) & 1) == 0 : (n & 1) == 0 && !this.isMinIncluded && range.isMinIncluded()) {
                return false;
            }
            int n2 = this.binarySearch(range.getMaxValue(), n, this.length);
            if (n2 < 0 ? ((n2 ^= 0xFFFFFFFF) & 1) == 0 : (n2 & 1) != 0 && !this.isMaxIncluded && range.isMaxIncluded()) {
                return false;
            }
            return n2 - n <= 1;
        }
        return false;
    }

    @Override
    public Range<E> first() throws NoSuchElementException {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.getRange(0);
    }

    @Override
    public Range<E> last() throws NoSuchElementException {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.getRange(this.length - 2);
    }

    public SortedSet<Range<E>> intersect(Range<E> range) {
        ArgumentChecks.ensureNonNull("subRange", range);
        return new SubSet(range);
    }

    @Override
    public SortedSet<Range<E>> subSet(Range<E> range, Range<E> range2) {
        ArgumentChecks.ensureNonNull("lower", range);
        ArgumentChecks.ensureNonNull("upper", range2);
        E e = range2.getMinValue();
        if (e == null) {
            throw new IllegalArgumentException(Errors.format((short)45, "upper", range2));
        }
        return this.intersect(new Range<E>(this.elementType, range.getMinValue(), range.isMinIncluded(), e, !range2.isMinIncluded()));
    }

    @Override
    public SortedSet<Range<E>> headSet(Range<E> range) {
        ArgumentChecks.ensureNonNull("upper", range);
        E e = range.getMinValue();
        if (e == null) {
            throw new IllegalArgumentException(Errors.format((short)45, "upper", range));
        }
        return this.intersect(new Range<Object>((Class<Object>)this.elementType, null, false, e, !range.isMinIncluded()));
    }

    @Override
    public SortedSet<Range<E>> tailSet(Range<E> range) {
        ArgumentChecks.ensureNonNull("lower", range);
        return this.intersect(new Range<Object>((Class<Object>)this.elementType, range.getMinValue(), range.isMinIncluded(), null, false));
    }

    @Override
    public Iterator<Range<E>> iterator() {
        return new Iter(this.length);
    }

    public int indexOfRange(E e) {
        int n = this.binarySearch(e, 0, this.length);
        if (n < 0 ? ((n ^= 0xFFFFFFFF) & 1) == 0 : !((n & 1) != 0 ? this.isMaxIncluded : this.isMinIncluded)) {
            return -1;
        }
        return n /= 2;
    }

    public long getMinLong(int n) throws IndexOutOfBoundsException, ClassCastException {
        if ((n *= 2) >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Array.getLong(this.array, n);
    }

    public double getMinDouble(int n) throws IndexOutOfBoundsException, ClassCastException {
        if ((n *= 2) >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Array.getDouble(this.array, n);
    }

    public long getMaxLong(int n) throws IndexOutOfBoundsException, ClassCastException {
        if ((n *= 2) >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Array.getLong(this.array, n + 1);
    }

    public double getMaxDouble(int n) throws IndexOutOfBoundsException, ClassCastException {
        if ((n *= 2) >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Array.getDouble(this.array, n + 1);
    }

    final E getValue(int n) {
        assert (n >= 0 && n < this.length) : n;
        return (E)((Comparable)this.elementType.cast(Array.get(this.array, n)));
    }

    final Range<E> getRange(int n) {
        return this.newRange(this.getValue(n), this.getValue(n + 1));
    }

    protected Range<E> newRange(E e, E e2) {
        return new Range<E>(this.elementType, e, this.isMinIncluded, e2, this.isMaxIncluded);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RangeSet) {
            RangeSet rangeSet = (RangeSet)object;
            if (this.length != rangeSet.length || this.elementType != rangeSet.elementType || this.isMinIncluded != rangeSet.isMinIncluded || this.isMaxIncluded != rangeSet.isMaxIncluded) {
                return false;
            }
            this.trimToSize();
            rangeSet.trimToSize();
            Object object2 = this.array;
            Object object3 = rangeSet.array;
            switch (this.elementCode) {
                case 9: {
                    return Arrays.equals((double[])object2, (double[])object3);
                }
                case 8: {
                    return Arrays.equals((float[])object2, (float[])object3);
                }
                case 6: {
                    return Arrays.equals((long[])object2, (long[])object3);
                }
                case 5: {
                    return Arrays.equals((int[])object2, (int[])object3);
                }
                case 4: {
                    return Arrays.equals((short[])object2, (short[])object3);
                }
                case 3: {
                    return Arrays.equals((byte[])object2, (byte[])object3);
                }
                case 2: {
                    return Arrays.equals((char[])object2, (char[])object3);
                }
            }
            return Arrays.equals((Object[])object2, (Object[])object3);
        }
        return super.equals(object);
    }

    public RangeSet<E> clone() {
        RangeSet rangeSet;
        try {
            rangeSet = (RangeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        rangeSet.reallocate();
        return rangeSet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.trimToSize();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.array != null) {
            this.length = Array.getLength(this.array);
            assert (this.isSorted());
        }
    }

    private static final class Numeric<E extends Number>
    extends RangeSet<E> {
        private static final long serialVersionUID = 5603640102714482527L;

        Numeric(Class<E> clazz, boolean bl, boolean bl2) {
            super(clazz, bl, bl2);
        }

        @Override
        protected Range<E> newRange(E e, E e2) {
            return new NumberRange<E>(this.elementType, e, this.isMinIncluded, e2, this.isMaxIncluded);
        }
    }

    private class Iter
    implements Iterator<Range<E>> {
        int modCount;
        final int upper;
        int position;
        boolean canRemove;

        Iter(int n) {
            this.upper = n;
            this.modCount = RangeSet.this.modCount;
        }

        @Override
        public final boolean hasNext() {
            return this.position < this.upper;
        }

        @Override
        public Range<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Range range = RangeSet.this.getRange(this.position);
            if (RangeSet.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.position += 2;
            this.canRemove = true;
            return range;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (RangeSet.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            RangeSet.this.removeAt(this.position - 2, this.position);
            this.modCount = RangeSet.this.modCount;
            this.canRemove = false;
        }
    }

    private final class SubIter
    extends Iter {
        private final Range<E> subRange;
        private final int lower;

        SubIter(Range<E> range, int n, int n2) {
            super(n2);
            this.subRange = range;
            this.lower = n;
            this.position = n;
        }

        private boolean isFirstOrLast() {
            return this.position <= this.lower + 2 || this.position >= this.upper;
        }

        @Override
        public Range<E> next() {
            Range range = super.next();
            if (this.isFirstOrLast()) {
                range = this.subRange.intersect(range);
            }
            return range;
        }

        @Override
        public void remove() {
            if (this.isFirstOrLast()) {
                super.remove();
                return;
            }
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (RangeSet.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            RangeSet.this.remove(this.subRange.intersect(RangeSet.this.getRange(this.position - 2)));
            this.canRemove = false;
        }
    }

    private final class SubSet
    extends AbstractSet<Range<E>>
    implements SortedSet<Range<E>>,
    Serializable {
        private static final long serialVersionUID = 3093791428299754372L;
        private Range<E> subRange;
        private transient int lower;
        private transient int upper;
        private transient int modCount;

        SubSet(Range<E> range) {
            this.subRange = range;
            if (range.isEmpty()) {
                throw new IllegalArgumentException(Errors.format((short)45, "subRange", range));
            }
            this.modCount = RangeSet.this.modCount - 1;
        }

        private void updateBounds() {
            if (this.modCount != RangeSet.this.modCount) {
                int n = 0;
                int n2 = RangeSet.this.length;
                Object e = this.subRange.getMinValue();
                Object e2 = this.subRange.getMaxValue();
                if (e != null) {
                    n = RangeSet.this.binarySearch(e, 0, n2);
                    if (n < 0) {
                        n ^= 0xFFFFFFFF;
                    }
                    n &= 0xFFFFFFFE;
                }
                if (e2 != null) {
                    if ((n2 = RangeSet.this.binarySearch(e2, n, n2)) < 0) {
                        n2 ^= 0xFFFFFFFF;
                    }
                    n2 = n2 + 1 & 0xFFFFFFFE;
                }
                this.lower = n;
                this.upper = n2;
                this.modCount = RangeSet.this.modCount;
            }
        }

        @Override
        public Comparator<Range<E>> comparator() {
            return RangeSet.this.comparator();
        }

        @Override
        public void clear() {
            RangeSet.this.remove(this.subRange);
        }

        @Override
        public int size() {
            this.updateBounds();
            return this.upper - this.lower >> 1;
        }

        @Override
        public boolean add(Range<E> range) {
            boolean bl = RangeSet.this.add(range);
            this.subRange = this.subRange.union(range);
            return bl;
        }

        @Override
        public boolean remove(Object range) {
            Range range2;
            if (range instanceof Range && (range2 = (Range)range).getElementType() == RangeSet.this.elementType) {
                range = this.subRange.intersect(range2);
            }
            return RangeSet.this.remove(range);
        }

        @Override
        public boolean contains(Object object) {
            Range range;
            if (object instanceof Range && (range = (Range)object).getElementType() == RangeSet.this.elementType && !this.subRange.contains(range)) {
                return false;
            }
            return RangeSet.this.contains(object);
        }

        @Override
        public Range<E> first() {
            this.updateBounds();
            if (this.lower == this.upper) {
                throw new NoSuchElementException();
            }
            return this.subRange.intersect(RangeSet.this.getRange(this.lower));
        }

        @Override
        public Range<E> last() {
            this.updateBounds();
            if (this.lower == this.upper) {
                throw new NoSuchElementException();
            }
            return this.subRange.intersect(RangeSet.this.getRange(this.upper - 2));
        }

        @Override
        public SortedSet<Range<E>> subSet(Range<E> range, Range<E> range2) {
            range = this.subRange.intersect(range);
            range2 = this.subRange.intersect(range2);
            return RangeSet.this.subSet(range, range2);
        }

        @Override
        public SortedSet<Range<E>> headSet(Range<E> range) {
            range = this.subRange.intersect(range);
            return RangeSet.this.headSet(range);
        }

        @Override
        public SortedSet<Range<E>> tailSet(Range<E> range) {
            range = this.subRange.intersect(range);
            return RangeSet.this.tailSet(range);
        }

        @Override
        public Iterator<Range<E>> iterator() {
            this.updateBounds();
            return new SubIter(this.subRange, this.lower, this.upper);
        }
    }

    private static final class Compare<E extends Comparable<? super E>>
    implements Comparator<Range<E>>,
    Serializable {
        private static final long serialVersionUID = 8688450091923783564L;
        static final Compare INSTANCE = new Compare();

        private Compare() {
        }

        @Override
        public int compare(Range<E> range, Range<E> range2) {
            boolean bl;
            int n = range.getMinValue().compareTo(range2.getMinValue());
            int n2 = range.getMaxValue().compareTo(range2.getMaxValue());
            if (n == 0) {
                bl = range.isMinIncluded();
                if (range2.isMinIncluded() != bl) {
                    int n3 = n = bl ? -1 : 1;
                }
            }
            if (n2 == 0) {
                bl = range.isMaxIncluded();
                if (range2.isMaxIncluded() != bl) {
                    int n4 = n2 = bl ? 1 : -1;
                }
            }
            if (n == n2) {
                return n2;
            }
            if (n == 0) {
                return n2;
            }
            if (n2 == 0) {
                return n;
            }
            throw new IllegalArgumentException(Errors.format((short)132, range, range2));
        }

        Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

