/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.portlet;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.gatein.portal.controller.resource.ResourceScope;

public class GenericDispatchedViewPortlet
extends GenericPortlet {
    private String viewDispatchedPath;
    private String jsModule;
    private String jsToAppend;
    private boolean useJSManagerLoading;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.viewDispatchedPath = config.getInitParameter("portlet-view-dispatched-file-path");
        String useJSManager = config.getInitParameter("use-js-manager");
        if (StringUtils.isNotBlank((CharSequence)useJSManager)) {
            this.useJSManagerLoading = Boolean.parseBoolean(useJSManager);
            this.jsModule = config.getInitParameter("js-manager-jsModule");
            if (StringUtils.isBlank((CharSequence)this.jsModule)) {
                this.jsModule = ResourceScope.PORTLET + "/" + this.getPortletContext().getPortletContextName() + "/" + this.getPortletConfig().getPortletName();
            }
            this.jsToAppend = config.getInitParameter("js-manager-javascript-content");
            if (StringUtils.isBlank((CharSequence)this.jsToAppend)) {
                String alias = this.getPortletName();
                this.jsToAppend = alias + " && " + alias + ".init && " + alias + ".init();";
            } else if (!StringUtils.endsWith((CharSequence)this.jsToAppend.trim(), (CharSequence)";")) {
                this.jsToAppend = this.jsToAppend + ";";
            }
        }
        if (StringUtils.isBlank((CharSequence)this.viewDispatchedPath)) {
            throw new IllegalStateException("Portlet init parameter 'portlet-view-dispatched-file-path' is mandatory");
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRequestDispatcher prd = this.getPortletContext().getRequestDispatcher(this.viewDispatchedPath);
        PortletPreferences preferences = request.getPreferences();
        if (preferences != null) {
            Set preferencesEntries = preferences.getMap().entrySet();
            for (Map.Entry entry : preferencesEntries) {
                request.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        prd.include(request, response);
        if (this.useJSManagerLoading) {
            PortalRequestContext portalRequestContext = (PortalRequestContext)RequestContext.getCurrentInstance();
            JavascriptManager javascriptManager = portalRequestContext.getJavascriptManager();
            String alias = this.getPortletName();
            javascriptManager.require(this.jsModule, alias).addScripts(this.jsToAppend);
        }
    }
}

