/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.dialect.gtmpl;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import juzu.impl.template.spi.TemplateStub;
import juzu.impl.template.spi.juzu.dialect.gtmpl.BindingImpl;
import juzu.impl.template.spi.juzu.dialect.gtmpl.Foo;
import juzu.template.TemplateExecutionException;
import juzu.template.TemplateRenderContext;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyTemplateStub
extends TemplateStub {
    private Class<?> scriptClass = null;
    private HashMap<Integer, Foo> locationTable = null;

    public GroovyTemplateStub(ClassLoader loader, String templateId) {
        super(loader, templateId);
    }

    @Override
    public void doInit(ClassLoader loader) {
        String fqn = this.id + "_";
        try {
            this.scriptClass = loader.loadClass(fqn);
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (NoClassDefFoundError ignore) {
            // empty catch block
        }
        if (this.scriptClass == null) {
            CompilerConfiguration config = new CompilerConfiguration();
            String script = this.getScript(loader, fqn);
            GroovyCodeSource gcs = new GroovyCodeSource(new String(script.getBytes()), "myscript", "/groovy/shell");
            GroovyClassLoader gcl = new GroovyClassLoader(loader, config);
            try {
                this.scriptClass = gcl.parseClass(gcs, false);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("handle me gracefully", e);
            }
        }
        try {
            String simpleName;
            String prefix;
            int pos = this.id.lastIndexOf(46);
            if (pos != -1) {
                prefix = this.id.substring(0, pos + 1);
                simpleName = this.id.substring(pos + 1);
            } else {
                prefix = "";
                simpleName = this.id;
            }
            String constantsName = prefix + "C" + simpleName;
            Class<?> constants = this.scriptClass.getClassLoader().loadClass(constantsName);
            this.locationTable = (HashMap)constants.getField("TABLE").get(null);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Handle me gracefully", e);
        }
    }

    public String getScript(ClassLoader loader, String fqn) {
        try {
            String path = fqn.replace('.', '/') + ".groovy";
            URL url = loader.getResource(path);
            if (url != null) {
                byte[] buffer = new byte[256];
                InputStream in = url.openStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int l = in.read(buffer);
                while (l != -1) {
                    baos.write(buffer, 0, l);
                    l = in.read(buffer);
                }
                return baos.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getClassName() {
        return this.scriptClass != null ? this.scriptClass.getName() : null;
    }

    @Override
    public void doRender(TemplateRenderContext renderContext) throws TemplateExecutionException, IOException {
        BindingImpl binding = new BindingImpl(renderContext);
        Script script = InvokerHelper.createScript(this.scriptClass, (Binding)binding);
        try {
            script.run();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw this.buildRuntimeException(e);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw this.buildRuntimeException(e);
        }
    }

    private TemplateExecutionException buildRuntimeException(Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        Foo firstItem = null;
        for (int i = 0; i < trace.length; ++i) {
            int templateLineNumber;
            StackTraceElement element = trace[i];
            if (!element.getClassName().equals(this.scriptClass.getName())) continue;
            int lineNumber = element.getLineNumber();
            Foo item = this.locationTable.get(lineNumber);
            if (item != null) {
                templateLineNumber = item.getPosition().getLine();
                if (firstItem == null) {
                    firstItem = item;
                }
            } else {
                templateLineNumber = -1;
            }
            trace[i] = element = new StackTraceElement(element.getClassName(), element.getMethodName(), element.getFileName(), templateLineNumber);
        }
        t.setStackTrace(trace);
        if (firstItem != null) {
            return new TemplateExecutionException(this.id, firstItem.getPosition(), firstItem.getValue(), t);
        }
        return new TemplateExecutionException(this.id, null, null, t);
    }
}

