/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.rest;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="v1/membershipTypes")
public class MembershipTypeRestResourcesV1
implements ResourceContainer {
    private OrganizationService organizationService;
    private UserACL userACL;

    public MembershipTypeRestResourcesV1(OrganizationService organizationService, UserACL userACL) {
        this.organizationService = organizationService;
        this.userACL = userACL;
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets membership types", httpMethod="GET", response=Response.class, produces="application/json", notes="This returns the list of membership types")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="User not authorized to call this endpoint"), @ApiResponse(code=500, message="Internal server error")})
    public Response getMembershipType() throws Exception {
        Collection membershipTypes = this.organizationService.getMembershipTypeHandler().findMembershipTypes();
        return Response.ok((Object)membershipTypes).build();
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new membership type", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="User not authorized to call this endpoint"), @ApiResponse(code=500, message="Internal server error")})
    public Response createMembershipType(MembershipTypeImpl membershipType) throws Exception {
        if (membershipType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Membership type object is required").build();
        }
        if (StringUtils.isBlank((String)membershipType.getName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:MANDATORY").build();
        }
        if (membershipType.getName().length() > 30 || membershipType.getName().length() < 3) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:LENGTH_INVALID").build();
        }
        if (StringUtils.isBlank((String)membershipType.getDescription())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"DESCRIPTION:MANDATORY").build();
        }
        if (membershipType.getDescription().length() > 255 || membershipType.getDescription().length() < 3) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"DESCRIPTION:LENGTH_INVALID").build();
        }
        if (this.organizationService.getMembershipTypeHandler().findMembershipType(membershipType.getName()) != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:ALREADY_EXISTS").build();
        }
        membershipType.setCreatedDate(new Date());
        membershipType.setModifiedDate(new Date());
        membershipType.setOwner(ConversationState.getCurrent().getIdentity().getUserId());
        this.organizationService.getMembershipTypeHandler().createMembershipType((MembershipType)membershipType, true);
        return Response.noContent().build();
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Updates an existing membership type", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="User not authorized to call this endpoint"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateMembershipType(MembershipTypeImpl membershipType) throws Exception {
        if (membershipType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Membership type object is required").build();
        }
        if (StringUtils.isBlank((String)membershipType.getName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:MANDATORY").build();
        }
        if (this.organizationService.getMembershipTypeHandler().findMembershipType(membershipType.getName()) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"NAME:NOT_FOUND").build();
        }
        membershipType.setModifiedDate(new Date());
        membershipType.setOwner(ConversationState.getCurrent().getIdentity().getUserId());
        this.organizationService.getMembershipTypeHandler().saveMembershipType((MembershipType)membershipType, true);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{membershipType}")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Deletes an existing membership type", httpMethod="DELETE", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="User not authorized to call this endpoint"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteMembershipType(@ApiParam(value="Membership type name", required=true) @PathParam(value="membershipType") String membershipType) throws Exception {
        if (StringUtils.isBlank((String)membershipType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:MANDATORY").build();
        }
        if (this.userACL.getMandatoryMSTypes() != null && this.userACL.getMandatoryMSTypes().contains(membershipType) || StringUtils.equals((String)this.userACL.getMakableMT(), (String)membershipType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MandatoryMembershipType").build();
        }
        if (this.organizationService.getMembershipTypeHandler().findMembershipType(membershipType) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"NAME:NOT_FOUND").build();
        }
        this.organizationService.getMembershipTypeHandler().removeMembershipType(membershipType, true);
        return Response.noContent().build();
    }
}

