/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.twitter;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.spi.InteractionState;
import org.gatein.security.oauth.spi.OAuthCodec;
import org.gatein.security.oauth.twitter.TwitterAccessTokenContext;
import org.gatein.security.oauth.twitter.TwitterProcessor;
import org.gatein.security.oauth.utils.OAuthPersistenceUtils;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterProcessorImpl
implements TwitterProcessor {
    private static Log log = ExoLogger.getLogger(TwitterProcessorImpl.class);
    private final String redirectURL;
    private final String clientID;
    private final String clientSecret;
    private final TwitterFactory twitterFactory;
    private final int chunkLength;

    public TwitterProcessorImpl(ExoContainerContext context, InitParams params) {
        this.clientID = params.getValueParam("clientId").getValue();
        this.clientSecret = params.getValueParam("clientSecret").getValue();
        String redirectURLParam = params.getValueParam("redirectURL").getValue();
        if (this.clientID == null || this.clientID.length() == 0 || this.clientID.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientId' needs to be provided. The value should be clientId of your Twitter application");
        }
        if (this.clientSecret == null || this.clientSecret.length() == 0 || this.clientSecret.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientSecret' needs to be provided. The value should be clientSecret of your Twitter application");
        }
        this.redirectURL = redirectURLParam == null || redirectURLParam.length() == 0 ? "http://localhost:8080/" + context.getName() + "/twitterAuth" : redirectURLParam.replaceAll("@@portal.container.name@@", context.getName());
        this.chunkLength = OAuthPersistenceUtils.getChunkLength(params);
        if (log.isDebugEnabled()) {
            log.debug((Object)("configuration: clientId=" + this.clientID + ", clientSecret=" + this.clientSecret + ", redirectURL=" + this.redirectURL + ", chunkLength=" + this.chunkLength));
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.setOAuthConsumerKey(this.clientID).setOAuthConsumerSecret(this.clientSecret);
        this.twitterFactory = new TwitterFactory(builder.build());
    }

    @Override
    public InteractionState<TwitterAccessTokenContext> processOAuthInteraction(HttpServletRequest request, HttpServletResponse response) throws IOException, OAuthException {
        Twitter twitter = this.twitterFactory.getInstance();
        HttpSession session = request.getSession();
        RequestToken requestToken = (RequestToken)session.getAttribute("_twitterRequestToken");
        try {
            if (requestToken == null) {
                requestToken = twitter.getOAuthRequestToken(this.redirectURL);
                session.setAttribute("_twitterRequestToken", (Object)requestToken);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"RequestToken obtained from twitter. Redirecting to Twitter for authorization");
                }
                response.sendRedirect(requestToken.getAuthenticationURL());
                return new InteractionState<Object>(InteractionState.State.AUTH, null);
            }
            String verifier = request.getParameter("oauth_verifier");
            if (request.getParameter("denied") != null) {
                throw new OAuthException(OAuthExceptionCode.USER_DENIED_SCOPE, "User denied scope on Twitter authorization page");
            }
            AccessToken accessToken = twitter.getOAuthAccessToken(requestToken, verifier);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Twitter accessToken: " + accessToken));
            }
            session.removeAttribute("_twitterRequestToken");
            TwitterAccessTokenContext accessTokenContext = new TwitterAccessTokenContext(accessToken.getToken(), accessToken.getTokenSecret());
            return new InteractionState<TwitterAccessTokenContext>(InteractionState.State.FINISH, accessTokenContext);
        }
        catch (TwitterException twitterException) {
            throw new OAuthException(OAuthExceptionCode.TWITTER_ERROR, (Throwable)twitterException);
        }
    }

    @Override
    public InteractionState<TwitterAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String scope) throws IOException, OAuthException {
        throw new OAuthException(OAuthExceptionCode.TWITTER_ERROR, "This is currently not supported for Twitter");
    }

    @Override
    public <C> C getAuthorizedSocialApiObject(TwitterAccessTokenContext accessToken, Class<C> socialApiObjectType) {
        if (Twitter.class.equals(socialApiObjectType)) {
            return socialApiObjectType.cast(this.getAuthorizedTwitterInstance(accessToken));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Class '" + socialApiObjectType + "' not supported by this processor"));
        }
        return null;
    }

    @Override
    public Twitter getAuthorizedTwitterInstance(TwitterAccessTokenContext accessTokenContext) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.setOAuthConsumerKey(this.clientID).setOAuthConsumerSecret(this.clientSecret);
        builder.setOAuthAccessToken(accessTokenContext.getAccessToken());
        builder.setOAuthAccessTokenSecret(accessTokenContext.getAccessTokenSecret());
        return new TwitterFactory(builder.build()).getInstance();
    }

    @Override
    public void saveAccessTokenAttributesToUserProfile(UserProfile userProfile, OAuthCodec codec, TwitterAccessTokenContext accessToken) {
        String encodedAccessToken = codec.encodeString(accessToken.getAccessToken());
        String encodedAccessTokenSecret = codec.encodeString(accessToken.getAccessTokenSecret());
        OAuthPersistenceUtils.saveLongAttribute(encodedAccessToken, userProfile, "user.social-info.twitter.accessToken", false, this.chunkLength);
        OAuthPersistenceUtils.saveLongAttribute(encodedAccessTokenSecret, userProfile, "user.social-info.twitter.accessTokenSecret", false, this.chunkLength);
    }

    @Override
    public TwitterAccessTokenContext getAccessTokenFromUserProfile(UserProfile userProfile, OAuthCodec codec) {
        String encodedAccessToken = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.twitter.accessToken", false);
        String encodedAccessTokenSecret = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.twitter.accessTokenSecret", false);
        String decodedAccessToken = codec.decodeString(encodedAccessToken);
        String decodedAccessTokenSecret = codec.decodeString(encodedAccessTokenSecret);
        if (decodedAccessToken == null || decodedAccessTokenSecret == null) {
            return null;
        }
        return new TwitterAccessTokenContext(decodedAccessToken, decodedAccessTokenSecret);
    }

    @Override
    public TwitterAccessTokenContext validateTokenAndUpdateScopes(TwitterAccessTokenContext accessToken) throws OAuthException {
        try {
            Twitter twitter = this.getAuthorizedTwitterInstance(accessToken);
            twitter.verifyCredentials();
            return accessToken;
        }
        catch (TwitterException tw) {
            if (tw.getStatusCode() == 401) {
                throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, "Error when verifying twitter access token: " + tw.getMessage(), (Throwable)tw);
            }
            throw new OAuthException(OAuthExceptionCode.IO_ERROR, "IO Error when obtaining tokenInfo: " + ((Object)((Object)tw)).getClass() + ": " + tw.getMessage(), (Throwable)tw);
        }
    }

    @Override
    public void removeAccessTokenFromUserProfile(UserProfile userProfile) {
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.twitter.accessToken", false);
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.twitter.accessTokenSecret", false);
    }

    @Override
    public void revokeToken(TwitterAccessTokenContext accessToken) {
    }
}

