/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.jpa.storage.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.jpa.EditorConfigDAO;
import org.exoplatform.onlyoffice.jpa.EditorConfigStorage;
import org.exoplatform.onlyoffice.jpa.entities.EditorConfigEntity;
import org.exoplatform.onlyoffice.jpa.storage.impl.RDBMSEditorConfigStorageImpl$AjcClosure1;
import org.exoplatform.onlyoffice.jpa.storage.impl.RDBMSEditorConfigStorageImpl$AjcClosure3;
import org.exoplatform.onlyoffice.jpa.storage.impl.RDBMSEditorConfigStorageImpl$AjcClosure5;
import org.exoplatform.onlyoffice.jpa.storage.impl.RDBMSEditorConfigStorageImpl$AjcClosure7;

public class RDBMSEditorConfigStorageImpl
implements EditorConfigStorage {
    private final EditorConfigDAO editorConfigDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public RDBMSEditorConfigStorageImpl(EditorConfigDAO editorConfigDAO) {
        this.editorConfigDAO = editorConfigDAO;
    }

    @Override
    @ExoTransactional
    public Map<String, Config> getConfigsByKey(String key) {
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        RDBMSEditorConfigStorageImpl$AjcClosure1 rDBMSEditorConfigStorageImpl$AjcClosure1 = new RDBMSEditorConfigStorageImpl$AjcClosure1(objectArray);
        return (Map)ExoTransactionalAspect.aspectOf().around(rDBMSEditorConfigStorageImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Map<String, Config> getConfigsByDocId(String docId) {
        String string = docId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        RDBMSEditorConfigStorageImpl$AjcClosure3 rDBMSEditorConfigStorageImpl$AjcClosure3 = new RDBMSEditorConfigStorageImpl$AjcClosure3(objectArray);
        return (Map)ExoTransactionalAspect.aspectOf().around(rDBMSEditorConfigStorageImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void saveConfig(String key, Config config, boolean isNew) {
        String string = key;
        Config config2 = config;
        boolean bl = isNew;
        Object[] objectArray = new Object[]{string, config2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, config2, Conversions.booleanObject((boolean)bl), joinPoint};
        RDBMSEditorConfigStorageImpl$AjcClosure5 rDBMSEditorConfigStorageImpl$AjcClosure5 = new RDBMSEditorConfigStorageImpl$AjcClosure5(objectArray2);
        ExoTransactionalAspect.aspectOf().around(rDBMSEditorConfigStorageImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @Override
    public void saveConfig(List<String> keys, Config config, boolean isNew) {
        this.saveConfig("", config, isNew);
    }

    @Override
    @ExoTransactional
    public void deleteConfig(String key, Config config) {
        String string = key;
        Config config2 = config;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)config2);
        Object[] objectArray = new Object[]{this, string, config2, joinPoint};
        RDBMSEditorConfigStorageImpl$AjcClosure7 rDBMSEditorConfigStorageImpl$AjcClosure7 = new RDBMSEditorConfigStorageImpl$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(rDBMSEditorConfigStorageImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @Override
    public void deleteConfig(List<String> keys, Config config) {
        this.deleteConfig("", config);
    }

    private EditorConfigEntity buildFromDTO(Config config) {
        EditorConfigEntity result = new EditorConfigEntity();
        result.setId(config.getDatabaseId());
        result.setDocumentId(config.getDocId());
        result.setWorkspace(config.getWorkspace());
        result.setPath(config.getPath());
        result.setDocumentType(config.getDocumentType());
        result.setDocumentServerUrl(config.getDocumentserverUrl());
        result.setPlatformRestUrl(config.getPlatformRestUrl());
        result.setEditorUrl(config.getEditorUrl());
        result.setDownloadUrl(config.getDownloadUrl());
        result.setExplorerUrl(config.getExplorerUrl());
        result.setActivity(config.isActivity());
        result.setError(config.getError());
        result.setOpen(config.isOpen());
        result.setClosing(config.isClosing());
        result.setOpenedTime(config.getOpenedTime());
        result.setClosedTime(config.getClosedTime());
        result.setEditorPageLastModifier(config.getEditorPage().getLastModifier());
        result.setEditorPageLastModified(config.getEditorPage().getLastModified());
        result.setEditorPageDisplayPath(config.getEditorPage().getDisplayPath());
        result.setEditorPageComment(config.getEditorPage().getComment());
        result.setEditorPageDrive(config.getEditorPage().getDrive());
        result.setEditorPageRenamedAllowed(config.getEditorPage().getRenameAllowed());
        result.setDocumentFileType(config.getDocument().getFileType());
        result.setDocumentKey(config.getDocument().getKey());
        result.setDocumentTitle(config.getDocument().getTitle());
        result.setDocumentUrl(config.getDocument().getUrl());
        result.setDocumentInfoOwner(config.getDocument().getInfo().getOwner());
        result.setDocumentInfoUploaded(config.getDocument().getInfo().getUploaded());
        result.setDocumentInfoFolder(config.getDocument().getInfo().getFolder());
        result.setPermissionAllowEdit(config.getDocument().getPermissions().isEdit());
        result.setEditorCallbackUrl(config.getEditorConfig().getCallbackUrl());
        result.setEditorLang(config.getEditorConfig().getLang());
        result.setEditorMode(config.getEditorConfig().getMode());
        result.setEditorUserUserid(config.getEditorConfig().getUser().getId());
        result.setEditorUserName(config.getEditorConfig().getUser().getName());
        result.setEditorUserLastModified(config.getEditorConfig().getUser().getLastModified());
        result.setEditorUserLastSaved(config.getEditorConfig().getUser().getLastSaved());
        result.setEditorUserLinkSaved(config.getEditorConfig().getUser().getLinkSaved());
        result.setEditorUserDownloadLink(config.getEditorConfig().getUser().getDownloadLink());
        return result;
    }

    private Config buildFromEntity(EditorConfigEntity entity) {
        Config.Builder builder = Config.editor(entity.getDocumentServerUrl(), entity.getDocumentType(), entity.getWorkspace(), entity.getPath(), entity.getDocumentId());
        builder.owner(entity.getEditorUserUserid());
        builder.fileType(entity.getDocumentFileType());
        builder.uploaded(entity.getDocumentInfoUploaded());
        builder.displayPath(entity.getEditorPageDisplayPath());
        builder.comment(entity.getEditorPageComment());
        builder.drive(entity.getEditorPageDrive());
        builder.renameAllowed(entity.isEditorPageRenamedAllowed());
        builder.isActivity(entity.isActivity());
        builder.folder(entity.getDocumentInfoFolder());
        builder.lang(entity.getEditorLang());
        builder.mode(entity.getEditorMode());
        builder.title(entity.getDocumentTitle());
        builder.userId(entity.getEditorUserUserid());
        builder.userName(entity.getEditorUserName());
        builder.lastModifier(entity.getEditorPageLastModifier());
        builder.lastModified(entity.getEditorPageLastModified());
        builder.key(entity.getDocumentKey());
        builder.generateUrls(entity.getPlatformRestUrl());
        builder.editorUrl(entity.getEditorUrl());
        builder.explorerUri(entity.getExplorerUrl());
        builder.secret(this.getDocumentServiceSecret());
        builder.setAllowEdition(entity.isPermissionAllowEdit());
        Config result = builder.build();
        result.setError(entity.getError());
        result.setDatabaseId(entity.getId());
        result.setOpen(entity.isOpen());
        result.setClosing(entity.isClosing());
        result.setOpenedTime(entity.getOpenedTime());
        result.setClosedTime(entity.getClosedTime());
        result.getEditorConfig().getUser().setLastModified(entity.getEditorUserLastModified());
        result.getEditorConfig().getUser().setLastSaved(entity.getEditorUserLastSaved());
        result.getEditorConfig().getUser().setLinkSaved(entity.getEditorUserLinkSaved());
        result.getEditorConfig().getUser().setDownloadLink(entity.getEditorUserDownloadLink());
        return result;
    }

    private String getDocumentServiceSecret() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OnlyofficeEditorService editorService = (OnlyofficeEditorService)container.getComponentInstanceOfType(OnlyofficeEditorService.class);
        return editorService.getDocumentServiceSecret();
    }

    static {
        RDBMSEditorConfigStorageImpl.ajc$preClinit();
    }

    static /* synthetic */ Map getConfigsByKey_aroundBody0(RDBMSEditorConfigStorageImpl ajc$this, String key, JoinPoint joinPoint) {
        List<EditorConfigEntity> entities = ajc$this.editorConfigDAO.getConfigByKey(key);
        return entities.stream().collect(Collectors.toMap(EditorConfigEntity::getEditorUserUserid, ajc$this::buildFromEntity));
    }

    static /* synthetic */ Map getConfigsByDocId_aroundBody2(RDBMSEditorConfigStorageImpl ajc$this, String docId, JoinPoint joinPoint) {
        List<EditorConfigEntity> entities = ajc$this.editorConfigDAO.getConfigByDocId(docId);
        return entities.stream().collect(Collectors.toConcurrentMap(EditorConfigEntity::getEditorUserUserid, ajc$this::buildFromEntity));
    }

    static /* synthetic */ void saveConfig_aroundBody4(RDBMSEditorConfigStorageImpl ajc$this, String key, Config config, boolean isNew, JoinPoint joinPoint) {
        if (isNew) {
            EditorConfigEntity entity = ajc$this.buildFromDTO(config);
            ajc$this.editorConfigDAO.create(entity);
            config.setDatabaseId(entity.getId());
        } else {
            EditorConfigEntity entity = (EditorConfigEntity)ajc$this.editorConfigDAO.find(config.getDatabaseId());
            if (entity != null) {
                entity = ajc$this.buildFromDTO(config);
                ajc$this.editorConfigDAO.update(entity);
            } else {
                throw new RuntimeException("Unable to save OO Config");
            }
        }
    }

    static /* synthetic */ void deleteConfig_aroundBody6(RDBMSEditorConfigStorageImpl ajc$this, String key, Config config, JoinPoint joinPoint) {
        EditorConfigEntity entity = (EditorConfigEntity)ajc$this.editorConfigDAO.find(config.getDatabaseId());
        if (entity != null) {
            ajc$this.editorConfigDAO.delete(entity);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RDBMSEditorConfigStorageImpl.java", RDBMSEditorConfigStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfigsByKey", "org.exoplatform.onlyoffice.jpa.storage.impl.RDBMSEditorConfigStorageImpl", "java.lang.String", "key", "", "java.util.Map"), 27);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfigsByDocId", "org.exoplatform.onlyoffice.jpa.storage.impl.RDBMSEditorConfigStorageImpl", "java.lang.String", "docId", "", "java.util.Map"), 36);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveConfig", "org.exoplatform.onlyoffice.jpa.storage.impl.RDBMSEditorConfigStorageImpl", "java.lang.String:org.exoplatform.onlyoffice.Config:boolean", "key:config:isNew", "", "void"), 46);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteConfig", "org.exoplatform.onlyoffice.jpa.storage.impl.RDBMSEditorConfigStorageImpl", "java.lang.String:org.exoplatform.onlyoffice.Config", "key:config", "", "void"), 69);
    }
}

