/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.page;

import java.io.Serializable;
import java.util.HashMap;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;

public class PageKey
implements Serializable {
    private static final long serialVersionUID = -5005776237959733435L;
    private static final HashMap<String, SiteType> map = new HashMap();
    final SiteKey site;
    final String name;
    private String ref;

    public static PageKey parse(String s) throws NullPointerException, IllegalArgumentException {
        int pos2;
        SiteType siteType;
        if (s == null) {
            throw new NullPointerException("No null string argument allowed");
        }
        int pos1 = s.indexOf("::");
        if (pos1 != -1 && (siteType = map.get(s.substring(0, pos1))) != null && (pos2 = s.indexOf("::", pos1 += 2)) != -1) {
            String siteName = s.substring(pos1, pos2);
            if ((pos2 += 2) > pos1 && pos2 < s.length()) {
                String pageName = s.substring(pos2);
                return siteType.key(siteName).page(pageName);
            }
        }
        throw new IllegalArgumentException("Invalid page reference: " + s);
    }

    public PageKey(SiteKey site, String name) throws NullPointerException {
        if (site == null) {
            throw new NullPointerException("No null site accepted");
        }
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        this.site = site;
        this.name = name;
        this.ref = null;
    }

    public SiteKey getSite() {
        return this.site;
    }

    public String getName() {
        return this.name;
    }

    public PageKey sibling(String name) {
        return new PageKey(this.site, name);
    }

    public String format() {
        if (this.ref == null) {
            this.ref = this.site.getType().getName() + "::" + this.site.getName() + "::" + this.name;
        }
        return this.ref;
    }

    public int hashCode() {
        return this.site.getName().hashCode() ^ this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass().equals(obj.getClass())) {
            PageKey that = (PageKey)obj;
            return this.site.getName().equals(that.site.getName()) && this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        return "PageKey[site=" + this.site + ",name=" + this.name + "]";
    }

    static {
        map.put("portal", SiteType.PORTAL);
        map.put("group", SiteType.GROUP);
        map.put("user", SiteType.USER);
    }
}

