/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.ColumnLink;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ColumnLinkCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ColumnLinkCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ColumnLinkCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ColumnLinkRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IColumnLinkCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IColumnLinkCollectionRequest;

public class ColumnLinkCollectionRequest
extends BaseCollectionRequest<ColumnLinkCollectionResponse, IColumnLinkCollectionPage>
implements IColumnLinkCollectionRequest {
    public ColumnLinkCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ColumnLinkCollectionResponse.class, IColumnLinkCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IColumnLinkCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ColumnLinkCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IColumnLinkCollectionPage get() throws ClientException {
        ColumnLinkCollectionResponse response = (ColumnLinkCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ColumnLink newColumnLink, ICallback<ColumnLink> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ColumnLinkRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newColumnLink, callback);
    }

    @Override
    public ColumnLink post(ColumnLink newColumnLink) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ColumnLinkRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newColumnLink);
    }

    @Override
    public IColumnLinkCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IColumnLinkCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IColumnLinkCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IColumnLinkCollectionPage buildFromResponse(ColumnLinkCollectionResponse response) {
        ColumnLinkCollectionRequestBuilder builder = response.nextLink != null ? new ColumnLinkCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ColumnLinkCollectionPage page = new ColumnLinkCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

