/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DriveItem;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DriveItemCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DriveItemCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DriveItemCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DriveItemRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDriveItemCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDriveItemCollectionRequest;

public class DriveItemCollectionRequest
extends BaseCollectionRequest<DriveItemCollectionResponse, IDriveItemCollectionPage>
implements IDriveItemCollectionRequest {
    public DriveItemCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItemCollectionResponse.class, IDriveItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DriveItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemCollectionPage get() throws ClientException {
        DriveItemCollectionResponse response = (DriveItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DriveItem newDriveItem, ICallback<DriveItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDriveItem, callback);
    }

    @Override
    public DriveItem post(DriveItem newDriveItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDriveItem);
    }

    @Override
    public IDriveItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDriveItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IDriveItemCollectionPage buildFromResponse(DriveItemCollectionResponse response) {
        DriveItemCollectionRequestBuilder builder = response.nextLink != null ? new DriveItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveItemCollectionPage page = new DriveItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

