/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;

public abstract class AbstractJdbcStoreConfiguration
extends AbstractStoreConfiguration {
    static final AttributeDefinition<Boolean> MANAGE_CONNECTION_FACTORY = AttributeDefinition.builder((String)"manageConnectionFactory", (Object)true).immutable().build();
    static final AttributeDefinition<DatabaseType> DIALECT = AttributeDefinition.builder((String)"databaseType", null, DatabaseType.class).immutable().build();
    static final AttributeDefinition<Integer> DB_MAJOR_VERSION = AttributeDefinition.builder((String)"databaseMajorVersion", null, Integer.class).immutable().build();
    static final AttributeDefinition<Integer> DB_MINOR_VERSION = AttributeDefinition.builder((String)"databaseMinorVersion", null, Integer.class).immutable().build();
    private final Attribute<Boolean> manageConnectionFactory;
    private final Attribute<DatabaseType> dialect;
    private final Attribute<Integer> dbMajorVersion;
    private final Attribute<Integer> dbMinorVersion;
    private final ConnectionFactoryConfiguration connectionFactory;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AbstractJdbcStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{MANAGE_CONNECTION_FACTORY, DIALECT, DB_MAJOR_VERSION, DB_MINOR_VERSION});
    }

    protected AbstractJdbcStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, ConnectionFactoryConfiguration connectionFactory) {
        super(attributes, async, singletonStore);
        this.connectionFactory = connectionFactory;
        this.manageConnectionFactory = attributes.attribute(MANAGE_CONNECTION_FACTORY);
        this.dialect = attributes.attribute(DIALECT);
        this.dbMajorVersion = attributes.attribute(DB_MAJOR_VERSION);
        this.dbMinorVersion = attributes.attribute(DB_MINOR_VERSION);
    }

    public ConnectionFactoryConfiguration connectionFactory() {
        return this.connectionFactory;
    }

    public boolean manageConnectionFactory() {
        return (Boolean)this.manageConnectionFactory.get();
    }

    public DatabaseType dialect() {
        return (DatabaseType)((Object)this.dialect.get());
    }

    public Integer dbMajorVersion() {
        return (Integer)this.dbMajorVersion.get();
    }

    public Integer dbMinorVersion() {
        return (Integer)this.dbMinorVersion.get();
    }

    public String toString() {
        return "AbstractJdbcStoreConfiguration [connectionFactory=" + this.connectionFactory + ", attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.connectionFactory == null ? 0 : this.connectionFactory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractJdbcStoreConfiguration other = (AbstractJdbcStoreConfiguration)((Object)obj);
        return !(this.connectionFactory == null ? other.connectionFactory != null : !this.connectionFactory.equals(other.connectionFactory));
    }
}

