/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.infinispan.generic;

import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.infinispan.AbstractExoCache;
import org.exoplatform.services.cache.impl.infinispan.ExoCacheCreator;
import org.exoplatform.services.cache.impl.infinispan.generic.GenericExoCacheConfig;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;

public class GenericExoCacheCreator
implements ExoCacheCreator {
    protected String defaultStrategy = "LRU";
    protected long defaultMaxIdle = -1L;
    protected long defaultWakeUpInterval = 5000L;
    protected Set<String> implementations;

    @Override
    public Set<String> getExpectedImplementations() {
        return this.implementations;
    }

    @Override
    public Class<? extends ExoCacheConfig> getExpectedConfigType() {
        return GenericExoCacheConfig.class;
    }

    @Override
    public ExoCache<Serializable, Object> create(ExoCacheConfig config, ConfigurationBuilder confBuilder, Callable<Cache<Serializable, Object>> cacheGetter) throws ExoCacheInitException {
        if (config instanceof GenericExoCacheConfig) {
            GenericExoCacheConfig gConfig = (GenericExoCacheConfig)config;
            return this.create(config, confBuilder, cacheGetter, gConfig.getStrategy(), gConfig.getMaxSize(), gConfig.getLiveTime(), gConfig.getMaxIdle() == 0L ? this.defaultMaxIdle : gConfig.getMaxIdle(), gConfig.getWakeUpInterval() == 0L ? this.defaultWakeUpInterval : gConfig.getWakeUpInterval());
        }
        long period = config.getLiveTime();
        return this.create(config, confBuilder, cacheGetter, config.getImplementation() == null ? this.defaultStrategy : config.getImplementation(), config.getMaxSize(), period > 0L ? period * 1000L : -1L, this.defaultMaxIdle, this.defaultWakeUpInterval);
    }

    private ExoCache<Serializable, Object> create(ExoCacheConfig config, ConfigurationBuilder confBuilder, Callable<Cache<Serializable, Object>> cacheGetter, String strategy, int maxEntries, long lifespan, long maxIdle, long wakeUpInterval) throws ExoCacheInitException {
        EvictionStrategy es;
        EvictionStrategy evictionStrategy = es = strategy == null || strategy.length() == 0 ? null : EvictionStrategy.valueOf((String)strategy.toUpperCase(Locale.ENGLISH));
        if (es == null) {
            es = EvictionStrategy.LRU;
        }
        confBuilder.eviction().strategy(EvictionStrategy.valueOf((String)strategy)).maxEntries(maxEntries).expiration().lifespan(lifespan).maxIdle(maxIdle).wakeUpInterval(wakeUpInterval);
        try {
            return new GenericExoCache(config, cacheGetter.call());
        }
        catch (Exception e) {
            throw new ExoCacheInitException("Cannot create the cache '" + config.getName() + "'", (Throwable)e);
        }
    }

    public static class GenericExoCache
    extends AbstractExoCache<Serializable, Object> {
        public GenericExoCache(ExoCacheConfig config, Cache<Serializable, Object> cache) {
            super(config, cache);
        }

        public void setMaxSize(int max) {
            throw new UnsupportedOperationException("The configuration of the cache cannot not be modified");
        }

        public void setLiveTime(long period) {
            throw new UnsupportedOperationException("The configuration of the cache cannot not be modified");
        }

        public int getMaxSize() {
            return Math.toIntExact(this.cache.getCacheConfiguration().eviction().maxEntries());
        }

        public long getLiveTime() {
            return this.cache.getCacheConfiguration().expiration().lifespan();
        }

        @Managed
        @ManagedName(value="MaxIdle")
        @ManagedDescription(value="Maximum idle time a cache entry will be maintained in the cache. If the idle time is exceeded, the entry will be expired cluster-wide. -1 means the entries never expire.")
        public long getMaxIdle() {
            return this.cache.getCacheConfiguration().expiration().maxIdle();
        }

        @Managed
        @ManagedName(value="WakeUpInterval")
        @ManagedDescription(value="Interval between subsequent eviction runs. If you wish to disable the periodic eviction process altogether, set wakeupInterval to -1.")
        public long getWakeUpInterval() {
            return this.cache.getCacheConfiguration().expiration().wakeUpInterval();
        }
    }
}

