/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class JAASGroup
implements Group,
Serializable {
    private static final long serialVersionUID = -1224998629739318069L;
    public static final String ROLES = "Roles";
    private String name = null;
    private HashSet members = null;

    public JAASGroup(String n) {
        this.name = n;
        this.members = new HashSet();
    }

    public synchronized boolean addMember(Principal principal) {
        return this.members.add(principal);
    }

    public synchronized boolean removeMember(Principal principal) {
        return this.members.remove(principal);
    }

    public boolean isMember(Principal principal) {
        Enumeration en = this.members();
        while (en.hasMoreElements()) {
            Principal principal1 = (Principal)en.nextElement();
            if (!principal1.getName().equals(principal.getName())) continue;
            return true;
        }
        return false;
    }

    public Enumeration members() {
        class MembersEnumeration
        implements Enumeration {
            private Iterator itor;

            public MembersEnumeration(Iterator itor) {
                this.itor = itor;
            }

            @Override
            public boolean hasMoreElements() {
                return this.itor.hasNext();
            }

            public Object nextElement() {
                return this.itor.next();
            }
        }
        return new MembersEnumeration(this.members.iterator());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Group)) {
            return false;
        }
        return ((Group)object).getName().equals(this.getName());
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }
}

