/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;

public class StringCommonUtils {
    private static final int BUFFER_SIZE = 32;
    public static final String EMPTY_STR = "";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String AMP_NUMBER = "&#";
    public static final String LESS_THAN = "&lt;";
    public static final String GREATER_THAN = "&gt;";
    public static final String QUOT = "&quot;";
    public static final String AMP_SPACE = "&nbsp;";
    public static final String AMP_HEX = "&#x26;";
    public static final String AMP = "&amp;";
    private static List<String> tokens = new ArrayList<String>();
    private static Map<String, String> charcodes = new HashMap<String, String>();
    private static List<String> ignoreLessThanAndGreaterThan = Arrays.asList("&lt;", "&gt;", "&amp;");
    private static int[] CHAR_CODES = new int[]{48, 32, 65, 57, 97, 90, 127, 122, 39};

    public static InputStream compress(String string) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gos = new GZIPOutputStream(os);
        gos.write(string.getBytes());
        gos.close();
        byte[] compressed = os.toByteArray();
        os.close();
        return new ByteArrayInputStream(compressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(InputStream is) throws IOException {
        GZIPInputStream gis = new GZIPInputStream(is, 32);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] data = new byte[32];
            while ((bytesRead = gis.read(data)) != -1) {
                buffer.write(data, 0, bytesRead);
            }
            String string = new String(buffer.toByteArray());
            return string;
        }
        finally {
            gis.close();
            is.close();
            buffer.close();
        }
    }

    public static String encodeSpecialCharInSearchTerm(String s) {
        String charIgnore = "&#<>[]/:?\"'=.,*$%()\\+@!^*-}{;`~_";
        if (StringUtils.isNotBlank((String)s)) {
            int i = 0;
            while (charIgnore.indexOf(String.valueOf(s.charAt(i))) >= 0) {
                if (++i != s.length()) continue;
                charIgnore = EMPTY_STR;
                break;
            }
        }
        if (StringUtils.isNotBlank((String)charIgnore)) {
            charIgnore = "&</>!#:?=.,+;~`_";
        }
        return StringCommonUtils.encodeSpecialCharToHTMLnumber(s, charIgnore, true);
    }

    public static String encodeSpecialCharForSimpleInput(String s) {
        if (StringUtils.isNotBlank((String)s)) {
            while (s.indexOf("  ") >= 0) {
                s = StringUtils.replace((String)s, (String)"  ", (String)SPACE).trim();
            }
        }
        String charIgnore = "!#:?=.,+;~`_";
        return StringCommonUtils.encodeSpecialCharToHTMLnumber(s, charIgnore, true);
    }

    public static String encodeSpecialCharInHTML(String s) {
        String charIgnore = "&#<>[]/:?\"=.,*$%()\\+@!^*-}{;`~_";
        return StringCommonUtils.encodeSpecialCharToHTMLnumber(s, charIgnore, false);
    }

    public static boolean isContainSpecialCharacter(String s) {
        if (StringUtils.isBlank((String)s)) {
            return false;
        }
        String charIgnore = "&#<>[]/:?\"=.,*$%()\\+@!^*-}{;`~_";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charIgnore.indexOf(String.valueOf(c)) < 0) continue;
            return true;
        }
        return false;
    }

    public static String encodeSpecialCharToHTMLnumber(String s, String charIgnore, boolean isTitle) {
        if (StringUtils.isBlank((String)s)) {
            return EMPTY_STR;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charIgnore.indexOf(String.valueOf(c)) >= 0) {
                builder.append(c);
                continue;
            }
            int t = s.codePointAt(i);
            if (t < CHAR_CODES[0] && t > CHAR_CODES[1] || t < CHAR_CODES[2] && t > CHAR_CODES[3] || t < CHAR_CODES[4] && t > CHAR_CODES[5] || t < CHAR_CODES[6] && t > CHAR_CODES[7]) {
                if (isTitle && (t == 60 || t == 62)) {
                    if (t == 60) {
                        builder.append(LESS_THAN);
                        continue;
                    }
                    if (t != 62) continue;
                    builder.append(GREATER_THAN);
                    continue;
                }
                builder.append(AMP_NUMBER).append(t).append(SEMICOLON);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String decodeSpecialCharToHTMLnumber(String s, List<String> lIgnore) {
        if (StringUtils.isBlank((String)s)) {
            return s;
        }
        for (String token : tokens) {
            if (lIgnore.contains(token)) continue;
            while (token != null && s.indexOf(token) >= 0) {
                s = StringUtils.replace((String)s, (String)token, (String)charcodes.get(token));
            }
        }
        return s;
    }

    public static String decodeSpecialCharToHTMLnumber(String s) {
        return StringCommonUtils.decodeSpecialCharToHTMLnumber(s, new ArrayList<String>());
    }

    public static String decodeSpecialCharToHTMLnumberIgnore(String str) {
        return StringCommonUtils.decodeSpecialCharToHTMLnumber(str, ignoreLessThanAndGreaterThan);
    }

    static {
        if (tokens.isEmpty()) {
            for (int t = 0; t < 0x10FFFF; ++t) {
                if (!(t < CHAR_CODES[0] && t > CHAR_CODES[1] || t < CHAR_CODES[2] && t > CHAR_CODES[3] || t < CHAR_CODES[4] && t > CHAR_CODES[5]) && (t >= CHAR_CODES[6] || t <= CHAR_CODES[7])) continue;
                String token = AMP_NUMBER + t + SEMICOLON;
                tokens.add(token);
                charcodes.put(token, String.valueOf(Character.toChars(t)[0]));
            }
            tokens.add(LESS_THAN);
            charcodes.put(LESS_THAN, "<");
            tokens.add(GREATER_THAN);
            charcodes.put(GREATER_THAN, ">");
            tokens.add(QUOT);
            charcodes.put(QUOT, "\"");
            tokens.add(AMP_SPACE);
            charcodes.put(AMP_SPACE, SPACE);
            tokens.add(AMP_HEX);
            charcodes.put(AMP_HEX, "&");
            tokens.add(AMP);
            charcodes.put(AMP, "&");
        }
    }
}

