/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.model.GettingStartedStep;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GettingStartedService {
    private static final Log LOG = ExoLogger.getLogger(GettingStartedService.class);
    public static final String AVATAR_STEP_KEY = "avatar";
    public static final String SPACES_STEP_KEY = "spaces";
    public static final String CONTACTS_STEP_KEY = "contacts";
    public static final String ACTIVITIES_STEP_KEY = "activities";
    public static final Scope APP_SCOPE = Scope.APPLICATION.id("GettingStarted");
    public static final String USER_SETTING_NAME = "gettingStartedStatus";
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private RelationshipManager relationshipManager;
    private ActivityManager activityService;
    private SettingService settingService;

    public GettingStartedService(IdentityManager identityManager, SpaceService spaceService, RelationshipManager relationshipManager, ActivityManager activityService, SettingService settingService) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.relationshipManager = relationshipManager;
        this.activityService = activityService;
        this.settingService = settingService;
    }

    public List<GettingStartedStep> getUserSteps(String userId) {
        boolean hideGettingStarted;
        if (StringUtils.isBlank((String)userId)) {
            throw new IllegalArgumentException("userId is mandatory");
        }
        SettingValue settingValue = this.settingService.get(Context.USER.id(userId), APP_SCOPE, USER_SETTING_NAME);
        boolean hadCompletedSteps = settingValue != null && settingValue.getValue() != null;
        boolean bl = hideGettingStarted = hadCompletedSteps && !Boolean.parseBoolean(settingValue.getValue().toString());
        if (hideGettingStarted) {
            return Collections.emptyList();
        }
        if (hadCompletedSteps && !hideGettingStarted) {
            return this.addStepsStatuses(true, true, true, true);
        }
        boolean hasAvatar = this.hasAvatar(userId);
        boolean hasContacts = this.hasContacts(userId);
        boolean hasSpaces = this.hasSpaces(userId);
        boolean hasActivities = this.hasActivities(userId);
        List<GettingStartedStep> gettingStartedSteps = this.addStepsStatuses(hasAvatar, hasContacts, hasSpaces, hasActivities);
        if (hasAvatar && hasContacts && hasSpaces && hasActivities) {
            this.markGettingStartedAsCompleted(userId);
        }
        return gettingStartedSteps;
    }

    public void markGettingStartedAsCompleted(String userId) {
        this.settingService.set(Context.USER.id(userId), APP_SCOPE, USER_SETTING_NAME, SettingValue.create((Boolean)true));
    }

    public void hideGettingStartedApplication(String userId) {
        this.settingService.set(Context.USER.id(userId), APP_SCOPE, USER_SETTING_NAME, SettingValue.create((Boolean)false));
    }

    private List<GettingStartedStep> addStepsStatuses(boolean hasAvatar, boolean hasContacts, boolean hasSpaces, boolean hasActivities) {
        ArrayList<GettingStartedStep> gettingStartedSteps = new ArrayList<GettingStartedStep>();
        this.addAvatarStepStatus(gettingStartedSteps, hasAvatar);
        this.addContactStepStatus(gettingStartedSteps, hasContacts);
        this.addSpaceStepStatus(gettingStartedSteps, hasSpaces);
        this.addActivityStepStatus(gettingStartedSteps, hasActivities);
        return gettingStartedSteps;
    }

    private void addActivityStepStatus(List<GettingStartedStep> gettingStartedSteps, boolean hasActivities) {
        GettingStartedStep stepActivities = new GettingStartedStep();
        stepActivities.setName(ACTIVITIES_STEP_KEY);
        stepActivities.setStatus(Boolean.valueOf(hasActivities));
        gettingStartedSteps.add(stepActivities);
    }

    private void addSpaceStepStatus(List<GettingStartedStep> gettingStartedSteps, boolean hasSpaces) {
        GettingStartedStep stepSpaces = new GettingStartedStep();
        stepSpaces.setName(SPACES_STEP_KEY);
        stepSpaces.setStatus(Boolean.valueOf(hasSpaces));
        gettingStartedSteps.add(stepSpaces);
    }

    private void addContactStepStatus(List<GettingStartedStep> gettingStartedSteps, boolean hasContacts) {
        GettingStartedStep stepContact = new GettingStartedStep();
        stepContact.setName(CONTACTS_STEP_KEY);
        stepContact.setStatus(Boolean.valueOf(hasContacts));
        gettingStartedSteps.add(stepContact);
    }

    private void addAvatarStepStatus(List<GettingStartedStep> gettingStartedSteps, boolean hasAvatar) {
        GettingStartedStep stepAvatar = new GettingStartedStep();
        stepAvatar.setName(AVATAR_STEP_KEY);
        stepAvatar.setStatus(Boolean.valueOf(hasAvatar));
        gettingStartedSteps.add(stepAvatar);
    }

    private boolean hasAvatar(String userId) {
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
            Profile profile = identity.getProfile();
            return profile.hasAvatar();
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in gettingStarted REST service: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean hasSpaces(String userId) {
        try {
            ListAccess accessibleSpaces = this.spaceService.getAccessibleSpacesWithListAccess(userId);
            return accessibleSpaces != null && accessibleSpaces.getSize() > 0;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error when cheking user spaces: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean hasContacts(String userId) {
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
            ListAccess confirmedContacts = this.relationshipManager.getConnections(identity);
            return confirmedContacts != null && confirmedContacts.getSize() > 0;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error when checking user activity: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean hasActivities(String userId) {
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
            RealtimeListAccess activities = this.activityService.getActivitiesWithListAccess(identity);
            int activitiesCount = activities.getSize();
            if (activitiesCount != 0) {
                return true;
            }
            if (this.hasAvatar(userId) && this.hasContacts(userId) && this.hasSpaces(userId) && activitiesCount >= 5) {
                return true;
            }
            if (this.hasAvatar(userId) && this.hasContacts(userId) && !this.hasSpaces(userId) && activitiesCount >= 4) {
                return true;
            }
            if (this.hasAvatar(userId) && !this.hasContacts(userId) && this.hasSpaces(userId) && activitiesCount >= 3) {
                return true;
            }
            if (!this.hasAvatar(userId) && this.hasContacts(userId) && this.hasSpaces(userId) && activitiesCount >= 4) {
                return true;
            }
            if (!this.hasAvatar(userId) && !this.hasContacts(userId) && this.hasSpaces(userId) && activitiesCount >= 2) {
                return true;
            }
            return !this.hasAvatar(userId) && !this.hasContacts(userId) && !this.hasSpaces(userId) && activitiesCount >= 1;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in gettingStarted REST service: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }
}

