/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.internal.util.AbstractMapEntry;
import org.apache.sis.internal.util.Bag;
import org.apache.sis.internal.util.SetOfUnknownSize;
import org.apache.sis.io.TableAppender;
import org.apache.sis.util.resources.Errors;

public abstract class AbstractMap<K, V>
implements Map<K, V> {
    protected AbstractMap() {
    }

    @Override
    public int size() {
        int n = 0;
        EntryIterator<K, V> entryIterator = this.entryIterator();
        while (entryIterator.next() && ++n != Integer.MAX_VALUE) {
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return !this.entryIterator().next();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        EntryIterator<K, V> entryIterator = this.entryIterator();
        if (entryIterator != null) {
            while (entryIterator.next()) {
                if (!entryIterator.getValue().equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V getOrDefault(Object object, V v) {
        Object v2 = this.get(object);
        return v2 != null ? v2 : v;
    }

    static String message(boolean bl) {
        return Errors.format(bl ? (short)162 : 153, bl ? "add" : Map.class);
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(AbstractMap.message(false));
    }

    @Override
    public V remove(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(AbstractMap.message(false));
    }

    @Override
    public V put(K k, V v) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(AbstractMap.message(false));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws UnsupportedOperationException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected boolean addKey(K k) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(AbstractMap.message(true));
    }

    protected boolean addValue(V v) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(AbstractMap.message(true));
    }

    @Override
    public Set<K> keySet() {
        return new SetOfUnknownSize<K>(){

            @Override
            public void clear() {
                AbstractMap.this.clear();
            }

            @Override
            public boolean isEmpty() {
                return AbstractMap.this.isEmpty();
            }

            @Override
            public int size() {
                return AbstractMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return AbstractMap.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                return AbstractMap.this.remove(object) != null;
            }

            @Override
            public boolean add(K k) {
                return AbstractMap.this.addKey(k);
            }

            @Override
            public Iterator<K> iterator() {
                EntryIterator entryIterator = AbstractMap.this.entryIterator();
                return entryIterator != null ? new Keys(entryIterator) : Collections.emptyIterator();
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set set = (Set)object;
                EntryIterator entryIterator = AbstractMap.this.entryIterator();
                if (entryIterator == null) {
                    return set.isEmpty();
                }
                int n = 0;
                while (entryIterator.next()) {
                    if (!set.contains(entryIterator.getKey())) {
                        return false;
                    }
                    ++n;
                }
                return n == set.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new Bag<V>(){

            @Override
            public void clear() {
                AbstractMap.this.clear();
            }

            @Override
            public boolean isEmpty() {
                return AbstractMap.this.isEmpty();
            }

            @Override
            public int size() {
                return AbstractMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return AbstractMap.this.containsValue(object);
            }

            @Override
            public boolean add(V v) {
                return AbstractMap.this.addValue(v);
            }

            @Override
            public Iterator<V> iterator() {
                EntryIterator entryIterator = AbstractMap.this.entryIterator();
                return entryIterator != null ? new Values(entryIterator) : Collections.emptyIterator();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetOfUnknownSize<Map.Entry<K, V>>(){

            @Override
            public void clear() {
                AbstractMap.this.clear();
            }

            @Override
            public boolean isEmpty() {
                return AbstractMap.this.isEmpty();
            }

            @Override
            public int size() {
                return AbstractMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                Map.Entry entry;
                Object v;
                if (object instanceof Map.Entry && (v = AbstractMap.this.get((entry = (Map.Entry)object).getKey())) != null) {
                    return v.equals(entry.getValue());
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                EntryIterator entryIterator = AbstractMap.this.entryIterator();
                return entryIterator != null ? new Entries(entryIterator) : Collections.emptyIterator();
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set set = (Set)object;
                EntryIterator entryIterator = AbstractMap.this.entryIterator();
                if (entryIterator == null) {
                    return set.isEmpty();
                }
                int n = 0;
                while (entryIterator.next()) {
                    if (!set.contains(entryIterator.getEntry())) {
                        return false;
                    }
                    ++n;
                }
                return n == set.size();
            }
        };
    }

    protected abstract EntryIterator<K, V> entryIterator();

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        EntryIterator<K, V> entryIterator = this.entryIterator();
        if (entryIterator == null) {
            return map.isEmpty();
        }
        int n = 0;
        while (entryIterator.next()) {
            if (!entryIterator.getValue().equals(map.get(entryIterator.getKey()))) {
                return false;
            }
            ++n;
        }
        return n == map.size();
    }

    @Override
    public int hashCode() {
        int n = 0;
        EntryIterator<K, V> entryIterator = this.entryIterator();
        if (entryIterator != null) {
            while (entryIterator.next()) {
                n += Objects.hashCode(entryIterator.getKey()) ^ Objects.hashCode(entryIterator.getValue());
            }
        }
        return n;
    }

    public String toString() {
        TableAppender tableAppender = new TableAppender(" = ");
        tableAppender.setMultiLinesCells(true);
        EntryIterator<K, V> entryIterator = this.entryIterator();
        if (entryIterator != null) {
            while (entryIterator.next()) {
                tableAppender.append(String.valueOf(entryIterator.getKey()));
                tableAppender.nextColumn();
                tableAppender.append(AbstractMapEntry.firstLine(entryIterator.getValue()));
                tableAppender.nextLine();
            }
        }
        return tableAppender.toString();
    }

    private static final class Entries<K, V>
    extends Iter<K, V>
    implements Iterator<Map.Entry<K, V>> {
        Entries(EntryIterator<K, V> entryIterator) {
            super(entryIterator);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.entry().getEntry();
        }
    }

    private static final class Values<K, V>
    extends Iter<K, V>
    implements Iterator<V> {
        Values(EntryIterator<K, V> entryIterator) {
            super(entryIterator);
        }

        @Override
        public V next() {
            return this.entry().getValue();
        }
    }

    private static final class Keys<K, V>
    extends Iter<K, V>
    implements Iterator<K> {
        Keys(EntryIterator<K, V> entryIterator) {
            super(entryIterator);
        }

        @Override
        public K next() {
            return this.entry().getKey();
        }
    }

    private static abstract class Iter<K, V> {
        private final EntryIterator<K, V> iterator;
        private byte hasNext;
        private static final byte TRUE = 1;
        private static final byte FALSE = 2;
        private static final byte AFTER_NEXT = 3;

        Iter(EntryIterator<K, V> entryIterator) {
            this.iterator = entryIterator;
        }

        public final boolean hasNext() {
            switch (this.hasNext) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            boolean bl = this.iterator.next();
            this.hasNext = (byte)(bl ? 1 : 2);
            return bl;
        }

        final EntryIterator<K, V> entry() {
            if (this.hasNext()) {
                this.hasNext = (byte)3;
                return this.iterator;
            }
            throw new NoSuchElementException();
        }

        public final void remove() {
            if (this.hasNext != 3) {
                throw new IllegalStateException();
            }
            this.hasNext = 0;
            this.iterator.remove();
        }
    }

    protected static class IteratorAdapter<K, V>
    extends EntryIterator<K, V> {
        protected Iterator<Map.Entry<K, V>> it;
        protected Map.Entry<K, V> entry;
        protected V value;

        public IteratorAdapter(Map<K, V> map) {
            this.it = map.entrySet().iterator();
        }

        @Override
        protected boolean next() {
            do {
                if (!this.it.hasNext()) {
                    return false;
                }
                this.entry = this.it.next();
                this.value = this.entry.getValue();
            } while (this.value == null);
            return true;
        }

        @Override
        protected K getKey() {
            return this.entry.getKey();
        }

        @Override
        protected V getValue() {
            return this.value;
        }
    }

    protected final class KeyIterator
    extends EntryIterator<K, V> {
        private final K[] keys;
        private int index = -1;
        private V value;

        @SafeVarargs
        public KeyIterator(K ... KArray) {
            this.keys = KArray;
        }

        @Override
        protected boolean next() {
            while (++this.index < this.keys.length) {
                this.value = AbstractMap.this.get(this.keys[this.index]);
                if (this.value == null) continue;
                return true;
            }
            return false;
        }

        @Override
        protected K getKey() {
            return this.keys[this.index];
        }

        @Override
        protected V getValue() {
            return this.value;
        }
    }

    protected static abstract class EntryIterator<K, V> {
        protected EntryIterator() {
        }

        protected abstract boolean next();

        protected abstract K getKey();

        protected abstract V getValue();

        protected Map.Entry<K, V> getEntry() {
            return new AbstractMap.SimpleImmutableEntry<K, V>(this.getKey(), this.getValue());
        }

        protected void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException(AbstractMap.message(false));
        }
    }
}

