/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.addons.gamification.service.RealizationsService;
import org.exoplatform.addons.gamification.service.dto.configuration.GamificationActionsHistoryDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.GamificationActionsHistoryRestEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.HistoryStatus;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.TypeRule;
import org.exoplatform.addons.gamification.service.mapper.GamificationActionsHistoryMapper;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/gamification/realizations/api")
@Api(value="/gamification/realizations/api", description="Manages users realizations")
@RolesAllowed(value={"administrators"})
public class RealizationsRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RealizationsRest.class);
    private RealizationsService realizationsService;
    private static final String DELIMITER = ",";
    private static final String SEPARATOR = "\n";
    private SimpleDateFormat formater = new SimpleDateFormat("yy-MM-dd_HH-mm-ss");
    private static final String HEADER = "Date,Creator,Action ID,Action label,Action type,Program,Program label,Points,Status,Grantee,Spaces";

    public RealizationsRest(RealizationsService realizationsService) {
        this.realizationsService = realizationsService;
    }

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="allRealizations")
    @ApiOperation(value="Retrieves the list of challenges available for an owner", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAllRealizations(@ApiParam(value="result fromDate", required=true) @QueryParam(value="fromDate") String fromDate, @ApiParam(value="result toDate", required=true) @QueryParam(value="toDate") String toDate, @ApiParam(value="Offset of result", required=false) @DefaultValue(value="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit of result", required=false) @DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        if (limit <= 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        try {
            List<GamificationActionsHistoryDTO> gActionsHistoryList = this.realizationsService.getAllRealizationsByDate(fromDate, toDate, offset, limit);
            return Response.ok(GamificationActionsHistoryMapper.toRestEntities(gActionsHistoryList)).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of Realizations", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="updateRealizations")
    @ApiOperation(value="Updates an existing realization", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=404, message="Object not found"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateRealizations(@ApiParam(value="id of realization", required=true) @QueryParam(value="realizationId") String realizationId, @ApiParam(value="new status of realization", required=true) @QueryParam(value="status") String status, @ApiParam(value="new action Label of realization", required=false) @QueryParam(value="actionLabel") String actionLabel, @ApiParam(value="new points of realization", required=false) @QueryParam(value="points") Long points, @ApiParam(value="new domain of realization", required=false) @QueryParam(value="domain") String domain) {
        String currentUser = Utils.getCurrentUser();
        try {
            GamificationActionsHistoryDTO gamificationActionsHistoryDTO = this.realizationsService.updateRealizationStatus(Long.valueOf(realizationId), HistoryStatus.valueOf(status), actionLabel, points, domain);
            return Response.ok((Object)GamificationActionsHistoryMapper.toRestEntity(gamificationActionsHistoryDTO)).build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to update a not existing realization '{}'", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"realization not found").build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating a challenge", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/vnd.ms-excel"})
    @Path(value="getExport")
    @ApiOperation(value="Gets CSV report", httpMethod="GET", response=Response.class, notes="Given a a csv file of actions")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getReport(@ApiParam(value="result fromDate", required=true) @QueryParam(value="fromDate") String fromDate, @ApiParam(value="result toDate", required=true) @QueryParam(value="toDate") String toDate) {
        try {
            List<GamificationActionsHistoryDTO> gActionsHistoryList = this.realizationsService.getAllRealizationsByDate(fromDate, toDate, 0, 0);
            List<GamificationActionsHistoryRestEntity> gamificationActionsHistoryRestEntities = GamificationActionsHistoryMapper.toRestEntities(gActionsHistoryList);
            String csvString = this.computeXLSX(gamificationActionsHistoryRestEntities);
            Object filename = "report_Actions";
            filename = (String)filename + this.formater.format(new Date());
            File temp = File.createTempFile((String)filename, ".xlsx");
            temp.deleteOnExit();
            BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
            bw.write(csvString);
            bw.close();
            Response.ResponseBuilder response = Response.ok((Object)temp);
            response.header("Content-Disposition", (Object)("attachment; filename=" + (String)filename + ".xlsx"));
            return response.build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when creating temp file", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private String computeXLSX(List<GamificationActionsHistoryRestEntity> gamificationActionsHistoryRestEntities) {
        Locale locale = Utils.getCurrentUserLocale();
        StringBuilder sbResult = new StringBuilder();
        sbResult.append(HEADER);
        sbResult.append(SEPARATOR);
        gamificationActionsHistoryRestEntities.forEach(ga -> {
            try {
                String eventKey = "exoplatform.gamification.gamificationinformation.rule.title.";
                String actionLabelKey = "exoplatform.gamification.gamificationinformation.rule.description.";
                String domainTitleKey = "exoplatform.gamification.gamificationinformation.domain.";
                String actionId = "-";
                String actionLabel = "-";
                String domainTitle = "-";
                String domainDescription = "-";
                if (ga.getAction() != null) {
                    if (ga.getAction().getType() == TypeRule.AUTOMATIC) {
                        actionId = Utils.getI18NMessage(locale, eventKey + ga.getAction().getEvent().replace(" ", ""));
                        if (actionId == null) {
                            actionId = ga.getAction().getEvent();
                        }
                        actionId = Utils.escapeIllegalCharacterInMessage(actionId);
                    } else {
                        actionId = Utils.escapeIllegalCharacterInMessage(ga.getAction().getEvent());
                    }
                }
                actionLabel = (actionLabel = Utils.getI18NMessage(locale, actionLabelKey + ga.getActionLabel())) == null ? Utils.escapeIllegalCharacterInMessage(ga.getAction().getTitle()) : Utils.escapeIllegalCharacterInMessage(actionLabel);
                if (ga.getDomain() != null) {
                    domainTitle = Utils.getI18NMessage(locale, domainTitleKey + ga.getDomain().getTitle().replace(" ", ""));
                    domainDescription = Utils.getI18NMessage(locale, domainTitleKey + ga.getDomain().getDescription().replace(" ", ""));
                    if (domainTitle == null) {
                        domainTitle = ga.getDomain().getTitle();
                    }
                    if (domainDescription == null) {
                        domainDescription = ga.getDomain().getDescription();
                    }
                }
                domainTitle = Utils.escapeIllegalCharacterInMessage(domainTitle);
                domainDescription = Utils.escapeIllegalCharacterInMessage(domainDescription);
                sbResult.append(ga.getCreatedDate());
                sbResult.append(DELIMITER);
                sbResult.append(ga.getCreator() != null ? ga.getCreator() : ga.getEarner());
                sbResult.append(DELIMITER);
                sbResult.append(actionId);
                sbResult.append(DELIMITER);
                sbResult.append(actionLabel);
                sbResult.append(DELIMITER);
                sbResult.append(ga.getAction() != null ? ga.getAction().getType().name() : "-");
                sbResult.append(DELIMITER);
                sbResult.append(domainTitle);
                sbResult.append(DELIMITER);
                sbResult.append(domainDescription);
                sbResult.append(DELIMITER);
                sbResult.append(ga.getScore());
                sbResult.append(DELIMITER);
                sbResult.append(ga.getStatus());
                sbResult.append(DELIMITER);
                sbResult.append(ga.getEarner() != null ? ga.getEarner() : "-");
                sbResult.append(DELIMITER);
                sbResult.append(ga.getSpace() != null ? Utils.escapeIllegalCharacterInMessage(ga.getSpace()) : "-");
                sbResult.append(SEPARATOR);
            }
            catch (Exception e) {
                LOG.error((Object)"Error when computing to XLSX ", (Throwable)e);
            }
        });
        return sbResult.toString();
    }
}

