/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util;

import java.util.HashMap;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.util.ItemDataReader;

public class PropertyDataReader
extends ItemDataReader {
    private HashMap<InternalQName, PropertyInfo> propeties = new HashMap();

    public PropertyDataReader(NodeData parent, DataManager dataManager) {
        super(parent, dataManager);
    }

    public PropertyDataReader forProperty(InternalQName name, int type) {
        this.propeties.put(name, new PropertyInfo(name, type));
        return this;
    }

    public List<ValueData> getPropertyValues(InternalQName name) throws ValueFormatException, PathNotFoundException {
        return this.propeties.get((Object)name).getValues();
    }

    public ValueData getPropertyValue(InternalQName name) throws ValueFormatException, PathNotFoundException {
        return this.propeties.get((Object)name).getValueData();
    }

    public void read() throws RepositoryException {
        List<PropertyData> ndProps = this.dataManager.getChildPropertiesData(this.parent);
        for (PropertyData prop : ndProps) {
            PropertyInfo propInfo = this.propeties.get((Object)prop.getQPath().getName());
            if (propInfo == null) continue;
            List<ValueData> valueDataList = prop.getValues();
            if (prop.isMultiValued()) {
                propInfo.setValueDatas(valueDataList);
                continue;
            }
            if (valueDataList.size() <= 0) continue;
            propInfo.setValueData(valueDataList.get(0));
        }
    }

    private class PropertyInfo {
        private InternalQName propertyName = null;
        private boolean multiValued = false;
        private List<ValueData> mValueData = null;
        private List<Value> mValue = null;
        private ValueData valueData = null;
        private int type = 1;

        PropertyInfo(InternalQName propertyName, int type) {
            this.propertyName = propertyName;
            this.type = type;
        }

        public InternalQName getPropertyName() {
            return this.propertyName;
        }

        public boolean isMultiValued() {
            return this.multiValued;
        }

        public void setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
        }

        public List<ValueData> getValues() throws ValueFormatException, PathNotFoundException {
            if (this.multiValued) {
                if (this.mValueData != null) {
                    return this.mValueData;
                }
            } else if (this.valueData != null) {
                throw new ValueFormatException("Property " + PropertyDataReader.this.parent.getQPath().getAsString() + this.propertyName.getAsString() + " is multi-valued");
            }
            throw new PathNotFoundException("Property " + PropertyDataReader.this.parent.getQPath().getAsString() + this.propertyName.getAsString() + " not found (multi-valued)");
        }

        public void setValueDatas(List<ValueData> mValue) {
            this.mValueData = mValue;
            this.multiValued = true;
        }

        public ValueData getValueData() throws ValueFormatException, PathNotFoundException {
            if (!this.multiValued) {
                if (this.valueData != null) {
                    return this.valueData;
                }
            } else if (this.mValueData != null) {
                throw new ValueFormatException("Property " + PropertyDataReader.this.parent.getQPath().getAsString() + this.propertyName.getAsString() + " is single-valued");
            }
            throw new PathNotFoundException("Property " + PropertyDataReader.this.parent.getQPath().getAsString() + this.propertyName.getAsString() + " not found (single-valued)");
        }

        public void setValueData(ValueData value) {
            this.valueData = value;
            this.multiValued = false;
        }

        public int getType() {
            return this.type;
        }
    }
}

