/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.jodconverter.impl;

import java.io.File;
import java.util.Collections;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.artofsolving.jodconverter.document.DocumentFormatRegistry;
import org.artofsolving.jodconverter.document.SimpleDocumentFormatRegistry;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class JodConverterServiceImpl
implements JodConverterService,
Startable {
    private OfficeManager officeManager;
    private OfficeDocumentConverter documentConverter;
    private boolean enable;
    private static final Log LOG = ExoLogger.getLogger((String)JodConverterServiceImpl.class.getName());

    public JodConverterServiceImpl(InitParams initParams) throws Exception {
        block30: {
            this.officeManager = null;
            this.documentConverter = null;
            this.enable = false;
            String enableJod = System.getProperty("wcm.jodconverter.enable");
            this.enable = enableJod == null || enableJod.isEmpty() ? true : Boolean.parseBoolean(enableJod);
            if (this.enable) {
                DefaultOfficeManagerConfiguration configuration;
                block29: {
                    String maxTasksPerProcess;
                    block28: {
                        String retryTimeout;
                        block27: {
                            String taskExecutionTimeout;
                            block26: {
                                String taskQueueTimeout;
                                block25: {
                                    String officeHomeParam;
                                    block24: {
                                        officeHomeParam = initParams.getValueParam("officeHome").getValue();
                                        String portNumbers = initParams.getValueParam("port").getValue();
                                        taskQueueTimeout = initParams.getValueParam("taskQueueTimeout").getValue();
                                        taskExecutionTimeout = initParams.getValueParam("taskExecutionTimeout").getValue();
                                        maxTasksPerProcess = initParams.getValueParam("maxTasksPerProcess").getValue();
                                        retryTimeout = initParams.getValueParam("retryTimeout").getValue();
                                        configuration = new DefaultOfficeManagerConfiguration();
                                        if (portNumbers != null) {
                                            try {
                                                String[] portsList = portNumbers.split(",");
                                                int[] ports = new int[portsList.length];
                                                for (int i = 0; i < portsList.length; ++i) {
                                                    ports[i] = Integer.parseInt(portsList[i].trim());
                                                }
                                                configuration.setPortNumbers(ports);
                                            }
                                            catch (NumberFormatException nfe) {
                                                if (!LOG.isWarnEnabled()) break block24;
                                                LOG.warn((Object)"Wrong configuration ==> Use default portNumbers value of DefaultOfficeManagerConfiguration");
                                            }
                                        }
                                    }
                                    if (officeHomeParam != null && officeHomeParam.trim().length() != 0) {
                                        try {
                                            configuration.setOfficeHome(officeHomeParam);
                                        }
                                        catch (IllegalArgumentException iae) {
                                            if (!LOG.isWarnEnabled()) break block25;
                                            LOG.warn((Object)"Wrong configuration ==> Use default officeHome value of DefaultOfficeManagerConfiguration");
                                        }
                                    }
                                }
                                if (taskQueueTimeout != null) {
                                    try {
                                        configuration.setTaskQueueTimeout(Long.parseLong(taskQueueTimeout));
                                    }
                                    catch (NumberFormatException nfe) {
                                        if (!LOG.isWarnEnabled()) break block26;
                                        LOG.warn((Object)"Wrong configuration ==> Use default taskQueueTimeout value of DefaultOfficeManagerConfiguration");
                                    }
                                }
                            }
                            if (taskExecutionTimeout != null) {
                                try {
                                    configuration.setTaskExecutionTimeout(Long.parseLong(taskExecutionTimeout));
                                }
                                catch (NumberFormatException nfe) {
                                    if (!LOG.isWarnEnabled()) break block27;
                                    LOG.warn((Object)"Wrong configuration ==> Use default taskExecutionTimeout value of DefaultOfficeManagerConfiguration");
                                }
                            }
                        }
                        if (retryTimeout != null) {
                            try {
                                configuration.setRetryTimeout(Long.parseLong(retryTimeout));
                            }
                            catch (NumberFormatException nfe) {
                                if (!LOG.isWarnEnabled()) break block28;
                                LOG.warn((Object)"Wrong configuration ==> Use default retryTimeout value of DefaultOfficeManagerConfiguration");
                            }
                        }
                    }
                    if (maxTasksPerProcess != null) {
                        try {
                            configuration.setMaxTasksPerProcess(Integer.parseInt(maxTasksPerProcess));
                        }
                        catch (NumberFormatException nfe) {
                            if (!LOG.isWarnEnabled()) break block29;
                            LOG.warn((Object)"Wrong configuration ==> Use default maxTasksPerProcess value of DefaultOfficeManagerConfiguration");
                        }
                    }
                }
                try {
                    this.officeManager = configuration.buildOfficeManager();
                    this.documentConverter = new OfficeDocumentConverter(this.officeManager);
                    DocumentFormatRegistry documentFormatRegistry = this.documentConverter.getFormatRegistry();
                    if (documentFormatRegistry instanceof SimpleDocumentFormatRegistry) {
                        DocumentFormat jpg = new DocumentFormat("JPEG Image", "jpg", "image/jpeg");
                        jpg.setInputFamily(DocumentFamily.DRAWING);
                        jpg.setStoreProperties(DocumentFamily.TEXT, Collections.singletonMap("FilterName", "writer_jpg_Export"));
                        jpg.setStoreProperties(DocumentFamily.SPREADSHEET, Collections.singletonMap("FilterName", "writer_jpg_Export"));
                        jpg.setStoreProperties(DocumentFamily.PRESENTATION, Collections.singletonMap("FilterName", "impress_jpg_Export"));
                        jpg.setStoreProperties(DocumentFamily.DRAWING, Collections.singletonMap("FilterName", "draw_jpg_Export"));
                        ((SimpleDocumentFormatRegistry)documentFormatRegistry).addFormat(jpg);
                    } else {
                        LOG.warn((Object)"Can't add a specific document format for thumbnail generation from a Word Document.");
                    }
                }
                catch (IllegalStateException ise) {
                    if (!LOG.isErrorEnabled()) break block30;
                    LOG.equals(ise.getMessage());
                }
            }
        }
    }

    public void start() {
        block4: {
            if (!this.enable) {
                LOG.info((Object)"JODConverter is disabled. To view office files in Activity Stream or Content Explorer, you need to change EXO_JODCONVERTER_ENABLE=true in customization setting file");
                return;
            }
            try {
                if (this.officeManager != null) {
                    this.officeManager.start();
                }
            }
            catch (OfficeException oe) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Exception when start Office Service: ", (Throwable)oe);
            }
        }
    }

    public void stop() {
        block4: {
            if (!this.enable) {
                LOG.info((Object)"JODConverter is disabled. To view office files in Activity Stream or Content Explorer, you need to change EXO_JODCONVERTER_ENABLE=true in customization setting file");
                return;
            }
            try {
                if (this.officeManager != null) {
                    this.officeManager.stop();
                }
            }
            catch (OfficeException oe) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Exception when stop Office Service: ", (Throwable)oe);
            }
        }
    }

    @Override
    public boolean convert(File input, File output, String outputFormat) throws OfficeException {
        if (!this.enable) {
            LOG.debug((Object)"JodConverter is disabled so you cannot view this document! To enable it, please change wcm.jodconverter.enable=true in configuration.properties file");
            return false;
        }
        if (this.officeManager != null && this.officeManager.isRunning()) {
            if (this.documentConverter != null) {
                DocumentFormat documentFormat = this.documentConverter.getFormatRegistry().getFormatByExtension(outputFormat);
                if (documentFormat == null) {
                    LOG.warn("Can't convert file {} because no corresponding document conversion for extension '{}'", new Object[]{input.getPath(), outputFormat});
                    return false;
                }
                try {
                    this.documentConverter.convert(input, output, documentFormat);
                    return true;
                }
                catch (Exception e) {
                    LOG.warn("Failed to convert file {} to '{}'", new Object[]{input.getPath(), outputFormat, e});
                    return false;
                }
            }
            return false;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"this OfficeManager is currently stopped!");
        }
        return false;
    }
}

