/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.TableAppender;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;

final class SampleRangeFormat
extends RangeFormat {
    private static final int MAX_DIGITS = 6;
    private int[] numFractionDigits;
    private boolean hasPackedValues;
    private boolean hasQuantitative;
    private final Vocabulary words;
    private int currentIndex;

    SampleRangeFormat(Locale locale) {
        super(locale);
        this.words = Vocabulary.getResources((Locale)locale);
    }

    private void prepare(SampleDimension[] sampleDimensionArray) {
        int n = sampleDimensionArray.length;
        this.numFractionDigits = new int[n];
        this.hasPackedValues = false;
        this.hasQuantitative = false;
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            for (Category category : sampleDimensionArray[i].getCategories()) {
                NumberRange<?> numberRange = category.getSampleRange();
                NumberRange<?> numberRange2 = category.converted().range;
                double d = numberRange.getMinDouble(true);
                double d2 = numberRange.getMaxDouble(false);
                double d3 = numberRange2.getMinDouble(true);
                double d4 = numberRange2.getMaxDouble(false);
                boolean bl = Double.doubleToRawLongBits(d) != Double.doubleToRawLongBits(d3) | Double.doubleToRawLongBits(d2) != Double.doubleToRawLongBits(d4);
                this.hasPackedValues |= bl;
                double d5 = bl ? d2 - d : 256.0;
                double d6 = (d4 - d3) / d5;
                if (Double.isNaN(d6)) continue;
                this.hasQuantitative = true;
                int n3 = -Numerics.toExp10((int)Math.getExponent(d6));
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (n2 >= 6) {
                n2 = 6;
            }
            this.numFractionDigits[i] = n2;
        }
    }

    private String formatSample(Object object) {
        if (object instanceof Number) {
            return Numerics.useScientificNotationIfNeeded((Format)this.elementFormat, (Object)object, Format::format).concat("\u00a0");
        }
        if (object instanceof Range) {
            if (object instanceof MeasurementRange) {
                return this.formatMeasure((Range<?>)new NumberRange((Range)((MeasurementRange)object)));
            }
            return this.format(object);
        }
        return String.valueOf(object);
    }

    private String formatMeasure(Range<?> range) {
        NumberFormat numberFormat = (NumberFormat)this.elementFormat;
        int n = numberFormat.getMinimumFractionDigits();
        int n2 = numberFormat.getMaximumFractionDigits();
        int n3 = this.numFractionDigits[this.currentIndex];
        numberFormat.setMinimumFractionDigits(n3);
        numberFormat.setMaximumFractionDigits(n3);
        String string = this.format(range);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n2);
        return string;
    }

    String write(SampleDimension[] sampleDimensionArray) {
        this.prepare(sampleDimensionArray);
        StringBuilder stringBuilder = new StringBuilder(800);
        TableAppender tableAppender = new TableAppender((Appendable)stringBuilder, " \u2502 ");
        tableAppender.setMultiLinesCells(true);
        tableAppender.appendHorizontalSeparator();
        tableAppender.setCellAlignment((byte)0);
        if (this.hasPackedValues) {
            tableAppender.append((CharSequence)this.words.getString((short)158)).nextColumn();
        }
        if (this.hasQuantitative) {
            tableAppender.append((CharSequence)this.words.getString((short)157)).nextColumn();
        }
        tableAppender.append((CharSequence)this.words.getString((short)72)).nextLine();
        tableAppender.nextLine('\u2550');
        tableAppender.append('#');
        tableAppender.appendHorizontalSeparator();
        for (SampleDimension sampleDimensionArray2 : sampleDimensionArray) {
            for (Category category : sampleDimensionArray2.getCategories()) {
                if (this.hasPackedValues) {
                    tableAppender.setCellAlignment((byte)1);
                    tableAppender.append((CharSequence)this.formatSample(category.getRangeLabel()));
                    tableAppender.nextColumn();
                }
                tableAppender.setCellAlignment((byte)-1);
                if (this.hasQuantitative) {
                    Category category2 = category.converted();
                    String string = category2.isConvertedQualitative() ? String.valueOf(category2.getRangeLabel()) : this.formatMeasure((Range<?>)category2.getSampleRange());
                    tableAppender.append((CharSequence)string);
                    tableAppender.nextColumn();
                }
                tableAppender.append((CharSequence)category.getName().toString(this.getLocale()));
                tableAppender.nextLine();
            }
        }
        tableAppender.appendHorizontalSeparator();
        try {
            tableAppender.flush();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        int n = 0;
        String string = tableAppender.getLineSeparator();
        String string2 = string + '\u255e';
        for (SampleDimension sampleDimension : sampleDimensionArray) {
            int n2 = stringBuilder.indexOf(string2, n);
            if (n2 < 0) break;
            int n3 = SampleRangeFormat.replace(stringBuilder, n2 += string2.length(), '\u256a', '\u2567', '\u2561');
            int n4 = n3 - 2 - n2;
            n3 += string.length() + 2;
            GenericName genericName = sampleDimension.getName();
            String string3 = genericName != null ? genericName.toInternationalString().toString(this.getLocale()) : this.words.getString((short)108);
            if (string3.length() > n4) {
                string3 = string3.substring(0, n4);
            }
            n4 += n3;
            stringBuilder.replace(n3, n3 += string3.length(), string3);
            while (n3 < n4) {
                stringBuilder.setCharAt(n3++, ' ');
            }
            n = SampleRangeFormat.replace(stringBuilder, n3 + string.length() + 2, '\u253c', '\u252c', '\u2524');
        }
        return stringBuilder.toString();
    }

    private static int replace(StringBuilder stringBuilder, int n, char c, char c2, char c3) {
        char c4;
        do {
            if ((c4 = stringBuilder.charAt(n)) == c) {
                stringBuilder.setCharAt(n, c2);
            }
            ++n;
        } while (c4 != c3);
        return n;
    }
}

