/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.image.TransferType;
import org.apache.sis.image.WritablePixelIterator;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

class DefaultIterator
extends WritablePixelIterator {
    int tileX;
    int tileY;
    int x;
    int y;
    int currentLowerX;
    int currentUpperX;
    int currentUpperY;

    DefaultIterator(Raster raster, WritableRaster writableRaster, Rectangle rectangle, Dimension dimension) {
        super(raster, writableRaster, rectangle, dimension);
        this.currentLowerX = this.lowerX;
        this.currentUpperX = this.upperX;
        this.currentUpperY = this.upperY;
        this.x = Math.decrementExact(this.lowerX);
        this.y = this.lowerY;
    }

    DefaultIterator(RenderedImage renderedImage, WritableRenderedImage writableRenderedImage, Rectangle rectangle, Dimension dimension) {
        super(renderedImage, writableRenderedImage, rectangle, dimension);
        this.tileX = Math.decrementExact(this.tileLowerX);
        this.tileY = this.tileLowerY;
        this.currentLowerX = this.lowerX;
        this.currentUpperX = this.lowerX;
        this.currentUpperY = this.lowerY;
        this.x = Math.decrementExact(this.lowerX);
        this.y = this.lowerY;
        if (this.tileUpperY == Integer.MAX_VALUE) {
            throw new ArithmeticException(Errors.format((short)188, (Object)32));
        }
    }

    @Override
    public void rewind() {
        this.close();
        if (this.image == null) {
            this.tileX = 0;
            this.tileY = 0;
            this.currentUpperX = this.upperX;
            this.currentUpperY = this.upperY;
        } else {
            this.tileX = this.tileLowerX - 1;
            this.tileY = this.tileLowerY;
            this.currentUpperX = this.lowerX;
            this.currentUpperY = this.lowerY;
        }
        this.currentLowerX = this.lowerX;
        this.x = this.lowerX - 1;
        this.y = this.lowerY;
    }

    @Override
    public Optional<SequenceType> getIterationOrder() {
        if (this.image == null || this.tileUpperX - this.tileLowerX <= 1 && this.tileUpperY - this.tileLowerY <= 1) {
            return Optional.of(SequenceType.LINEAR);
        }
        return Optional.empty();
    }

    @Override
    public Point getPosition() {
        int n;
        if (this.x < this.lowerX) {
            n = 37;
        } else if (this.tileY >= this.tileUpperY) {
            n = 36;
        } else {
            return new Point(this.x, this.y);
        }
        throw new IllegalStateException(Resources.format((short)n));
    }

    @Override
    public void moveTo(int n, int n2) {
        if (n < this.lowerX || n >= this.upperX || n2 < this.lowerY || n2 >= this.upperY) {
            throw new IndexOutOfBoundsException(Resources.format((short)47, n, n2));
        }
        if (this.image != null) {
            int n3 = Math.floorDiv(n - this.tileGridXOffset, this.tileWidth);
            int n4 = Math.floorDiv(n2 - this.tileGridYOffset, this.tileHeight);
            if (n3 != this.tileX || n4 != this.tileY) {
                this.close();
                this.tileX = n3;
                this.tileY = n4;
                if (this.fetchTile() > n2 || this.currentLowerX > n) {
                    throw new RasterFormatException(Resources.format((short)35, this.tileX, this.tileY));
                }
            }
        }
        this.x = n;
        this.y = n2;
    }

    @Override
    public boolean next() {
        if (++this.x >= this.currentUpperX) {
            if (++this.y >= this.currentUpperY) {
                this.close();
                if (++this.tileX >= this.tileUpperX) {
                    if (++this.tileY >= this.tileUpperY) {
                        this.endOfIteration();
                        return false;
                    }
                    this.tileX = this.tileLowerX;
                }
                this.y = this.fetchTile();
            }
            this.x = this.currentLowerX;
        }
        return true;
    }

    final int fetchTile() {
        this.currentRaster = null;
        if (this.destination != null) {
            this.destRaster = this.destination.getWritableTile(this.tileX, this.tileY);
            if (this.destination == this.image) {
                this.currentRaster = this.destRaster;
            }
        }
        if (this.currentRaster == null) {
            this.currentRaster = this.image.getTile(this.tileX, this.tileY);
        }
        int n = this.currentRaster.getMinX();
        int n2 = this.currentRaster.getMinY();
        this.currentLowerX = Math.max(this.lowerX, n);
        this.currentUpperX = Math.min(this.upperX, n + this.tileWidth);
        this.currentUpperY = Math.min(this.upperY, n2 + this.tileHeight);
        if (this.currentRaster.getNumBands() != this.numBands) {
            throw new RasterFormatException(Resources.format((short)35, this.tileX, this.tileY));
        }
        return Math.max(this.lowerY, n2);
    }

    final void endOfIteration() {
        boolean bl = this.tileY > Math.max(this.tileUpperY, this.tileLowerY + 1);
        this.x = this.currentUpperX - 1;
        this.y = this.currentUpperY - 1;
        this.tileX = this.tileUpperX - 1;
        this.tileY = this.tileUpperY;
        if (bl) {
            throw new IllegalStateException(Resources.format((short)36));
        }
    }

    @Override
    public int getSample(int n) {
        return this.currentRaster.getSample(this.x, this.y, n);
    }

    @Override
    public float getSampleFloat(int n) {
        return this.currentRaster.getSampleFloat(this.x, this.y, n);
    }

    @Override
    public double getSampleDouble(int n) {
        return this.currentRaster.getSampleDouble(this.x, this.y, n);
    }

    @Override
    public void setSample(int n, int n2) {
        this.destRaster.setSample(this.x, this.y, n, n2);
    }

    @Override
    public void setSample(int n, float f) {
        this.destRaster.setSample(this.x, this.y, n, f);
    }

    @Override
    public void setSample(int n, double d) {
        this.destRaster.setSample(this.x, this.y, n, d);
    }

    @Override
    public int[] getPixel(int[] nArray) {
        return this.currentRaster.getPixel(this.x, this.y, nArray);
    }

    @Override
    public float[] getPixel(float[] fArray) {
        return this.currentRaster.getPixel(this.x, this.y, fArray);
    }

    @Override
    public double[] getPixel(double[] dArray) {
        return this.currentRaster.getPixel(this.x, this.y, dArray);
    }

    @Override
    public void setPixel(int[] nArray) {
        this.destRaster.setPixel(this.x, this.y, nArray);
    }

    @Override
    public void setPixel(float[] fArray) {
        this.destRaster.setPixel(this.x, this.y, fArray);
    }

    @Override
    public void setPixel(double[] dArray) {
        this.destRaster.setPixel(this.x, this.y, dArray);
    }

    @Override
    public <T extends Buffer> PixelIterator.Window<T> createWindow(TransferType<T> transferType) {
        ArgumentChecks.ensureNonNull((String)"type", transferType);
        int n = this.numBands * this.windowWidth * this.windowHeight;
        int n2 = n - this.numBands * Math.min(this.windowWidth, this.windowHeight);
        switch (transferType.dataBufferType) {
            case 3: {
                return new IntWindow(new int[n], new int[n2]);
            }
            case 4: {
                return new FloatWindow(new float[n], new float[n2]);
            }
            case 5: {
                return new DoubleWindow(new double[n], new double[n2]);
            }
        }
        throw new AssertionError(transferType);
    }

    final void update(WindowBase<?> windowBase, Object object) {
        boolean bl;
        Raster raster = this.currentRaster;
        int n = raster.getMinX() - this.x + raster.getWidth();
        int n2 = raster.getMinY() - this.y + raster.getHeight();
        int n3 = Math.min(this.windowWidth, n);
        int n4 = Math.min(this.windowHeight, n2);
        boolean bl2 = bl = n3 == this.windowWidth;
        if (bl && n4 == this.windowHeight) {
            Object object2 = windowBase.getPixels(raster, this.x, this.y, n3, n4, true);
            if (object2 != object) {
                System.arraycopy(object2, 0, object, 0, this.numBands * n3 * n4);
            }
            return;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.tileX;
        int n9 = this.tileY;
        int n10 = this.windowWidth * this.numBands;
        int n11 = n;
        while (true) {
            if (n3 > 0 && n4 > 0) {
                int n12;
                Object object3 = windowBase.getPixels(raster, this.x + n6, this.y + n7, n3, n4, false);
                if (bl) {
                    n12 = n10 * n4;
                    System.arraycopy(object3, 0, object, n5, n12);
                    n5 += n12;
                } else {
                    n12 = this.numBands * n3;
                    int n13 = n12 * n4;
                    for (int i = 0; i < n13; i += n12) {
                        System.arraycopy(object3, i, object, n5, n12);
                        n5 += n10;
                    }
                }
            }
            if (n < this.windowWidth) {
                n6 = n;
                n += this.tileWidth;
                ++n8;
            } else {
                if (n2 >= this.windowHeight) {
                    return;
                }
                n7 = n2;
                n2 += this.tileHeight;
                ++n9;
                n8 = this.tileX;
                n = n11;
                n6 = 0;
            }
            raster = this.image.getTile(n8, n9);
            n5 = (n7 * this.windowWidth + n6) * this.numBands;
            n3 = Math.min(this.windowWidth, n) - n6;
            n4 = Math.min(this.windowHeight, n2) - n7;
            bl = n3 == this.windowWidth;
        }
    }

    @Override
    public final void close() {
        if (this.destination != null && this.destRaster != null) {
            this.destRaster = null;
            this.destination.releaseWritableTile(this.tileX, this.tileY);
        }
    }

    private final class DoubleWindow
    extends WindowBase<DoubleBuffer> {
        private final double[] data;
        private final double[] transfer;

        DoubleWindow(double[] dArray, double[] dArray2) {
            super(DoubleBuffer.wrap(dArray).asReadOnlyBuffer());
            this.data = dArray;
            this.transfer = dArray2;
        }

        @Override
        Object getPixels(Raster raster, int n, int n2, int n3, int n4, boolean bl) {
            return raster.getPixels(n, n2, n3, n4, bl ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((DoubleBuffer)this.values).clear();
            DefaultIterator.this.update(this, this.data);
        }
    }

    private final class FloatWindow
    extends WindowBase<FloatBuffer> {
        private final float[] data;
        private final float[] transfer;

        FloatWindow(float[] fArray, float[] fArray2) {
            super(FloatBuffer.wrap(fArray).asReadOnlyBuffer());
            this.data = fArray;
            this.transfer = fArray2;
        }

        @Override
        Object getPixels(Raster raster, int n, int n2, int n3, int n4, boolean bl) {
            return raster.getPixels(n, n2, n3, n4, bl ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((FloatBuffer)this.values).clear();
            DefaultIterator.this.update(this, this.data);
        }
    }

    private final class IntWindow
    extends WindowBase<IntBuffer> {
        private final int[] data;
        private final int[] transfer;

        IntWindow(int[] nArray, int[] nArray2) {
            super(IntBuffer.wrap(nArray).asReadOnlyBuffer());
            this.data = nArray;
            this.transfer = nArray2;
        }

        @Override
        Object getPixels(Raster raster, int n, int n2, int n3, int n4, boolean bl) {
            return raster.getPixels(n, n2, n3, n4, bl ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((IntBuffer)this.values).clear();
            DefaultIterator.this.update(this, this.data);
        }
    }

    private static abstract class WindowBase<T extends Buffer>
    extends PixelIterator.Window<T> {
        WindowBase(T t) {
            super(t);
        }

        abstract Object getPixels(Raster var1, int var2, int var3, int var4, int var5, boolean var6);
    }
}

