/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;

public abstract class OptionalDependency
extends SystemListener {
    private final String dependency;

    protected OptionalDependency(String string, String string2) {
        super(string);
        this.dependency = string2;
        SystemListener.add(this);
    }

    @Override
    protected void classpathChanged() {
        SystemListener.remove(this);
    }

    protected static <T extends OptionalDependency> T getInstance(Class<T> clazz, String string, String string2, String string3) {
        try {
            return (T)((OptionalDependency)clazz.cast(Class.forName(string3).newInstance()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogRecord logRecord = Messages.getResources(null).getLogRecord(Level.CONFIG, (short)27, string2);
            logRecord.setLoggerName(string);
            Logging.log(clazz, "getInstance", logRecord);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    protected final UnsupportedOperationException moduleNotFound() {
        return new UnsupportedOperationException(Errors.format((short)87, this.dependency));
    }
}

