/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;
import org.apache.sis.math.StatisticsFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.opengis.util.InternationalString;

public class Statistics
implements DoubleConsumer,
LongConsumer,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8495118253884975477L;
    private final InternationalString name;
    private double minimum = Double.NaN;
    private double maximum = Double.NaN;
    private double sum;
    private double squareSum;
    private transient double lowBits;
    private transient double squareLowBits;
    private int count;
    private int countNaN;

    public Statistics(CharSequence charSequence) {
        this.name = charSequence == null || charSequence instanceof InternationalString ? (InternationalString)charSequence : new SimpleInternationalString(charSequence.toString());
    }

    public static Statistics forSeries(CharSequence charSequence, CharSequence ... charSequenceArray) {
        ArgumentChecks.ensureNonNull("differenceNames", charSequenceArray);
        Statistics statistics = null;
        int n = charSequenceArray.length;
        while (--n >= -1) {
            CharSequence charSequence2 = n >= 0 ? charSequenceArray[n] : charSequence;
            statistics = statistics == null ? new Statistics(charSequence2) : new WithDelta(charSequence2, statistics);
        }
        return statistics;
    }

    public InternationalString name() {
        return this.name;
    }

    public void reset() {
        this.minimum = Double.NaN;
        this.maximum = Double.NaN;
        this.sum = 0.0;
        this.squareSum = 0.0;
        this.lowBits = 0.0;
        this.squareLowBits = 0.0;
        this.count = 0;
        this.countNaN = 0;
    }

    @Override
    public void accept(double d) {
        if (Double.isFinite(d)) {
            this.real(d);
        } else if (Double.isNaN(d)) {
            ++this.countNaN;
        } else {
            this.real(d);
            this.sum = d;
            this.squareSum = Double.POSITIVE_INFINITY;
            this.lowBits = 0.0;
            this.squareLowBits = 0.0;
        }
    }

    private void real(double d) {
        if (!(this.minimum <= d)) {
            this.minimum = d;
        }
        if (!(this.maximum >= d)) {
            this.maximum = d;
        }
        double d2 = d + this.lowBits;
        this.lowBits = d2 + (this.sum - (this.sum += d2));
        d *= d;
        d2 = d + this.squareLowBits;
        this.squareLowBits = d2 + (this.squareSum - (this.squareSum += d2));
        ++this.count;
    }

    @Override
    public void accept(long l) {
        double d = l;
        this.real(d);
        if ((l -= (long)d) != 0L) {
            d = (double)l + this.lowBits;
            this.lowBits = d + (this.sum - (this.sum += d));
        }
    }

    public void combine(Statistics statistics) {
        ArgumentChecks.ensureNonNull("stats", statistics);
        if (Double.isNaN(this.minimum) || statistics.minimum < this.minimum) {
            this.minimum = statistics.minimum;
        }
        if (Double.isNaN(this.maximum) || statistics.maximum > this.maximum) {
            this.maximum = statistics.maximum;
        }
        double d = statistics.sum + this.lowBits;
        this.lowBits = d + (this.sum - (this.sum += d)) + statistics.lowBits;
        d = statistics.squareSum + this.squareLowBits;
        this.squareLowBits = d + (this.squareSum - (this.squareSum += d)) + statistics.squareLowBits;
        this.count += statistics.count;
        this.countNaN += Math.max(statistics.countNaN, 0);
    }

    public void scale(double d) {
        ArgumentChecks.ensureFinite("factor", d);
        this.minimum *= d;
        this.maximum *= d;
        this.sum *= d;
        this.lowBits *= d;
        d *= d;
        this.squareSum *= d;
        this.squareLowBits *= d;
    }

    void decrementCountNaN() {
        --this.countNaN;
    }

    public int countNaN() {
        return Math.max(this.countNaN, 0);
    }

    public int count() {
        return this.count;
    }

    public double minimum() {
        return this.minimum;
    }

    public double maximum() {
        return this.maximum;
    }

    public double span() {
        return this.maximum - this.minimum;
    }

    public double sum() {
        return this.sum;
    }

    public double mean() {
        return this.sum / (double)this.count;
    }

    public double rms() {
        return Math.sqrt(this.squareSum / (double)this.count);
    }

    public double standardDeviation(boolean bl) {
        return Math.sqrt((this.squareSum - this.sum * this.sum / (double)this.count) / (double)(bl ? this.count : this.count - 1));
    }

    public Statistics differences() {
        return null;
    }

    public String toString() {
        return StatisticsFormat.getInstance().format(this);
    }

    public Statistics clone() {
        try {
            return (Statistics)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.minimum) + 31L * (Double.doubleToLongBits(this.maximum) + 31L * (Double.doubleToLongBits(this.sum) + 31L * Double.doubleToLongBits(this.squareSum)));
        return (int)l ^ (int)(l >>> 32) ^ this.count;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            Statistics statistics = (Statistics)object;
            return this.count == statistics.count && this.countNaN == statistics.countNaN && Double.doubleToLongBits(this.minimum) == Double.doubleToLongBits(statistics.minimum) && Double.doubleToLongBits(this.maximum) == Double.doubleToLongBits(statistics.maximum) && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(statistics.sum) && Double.doubleToLongBits(this.squareSum) == Double.doubleToLongBits(statistics.squareSum) && Objects.equals(this.name, statistics.name);
        }
        return false;
    }

    private static final class WithDelta
    extends Statistics {
        private static final long serialVersionUID = -5149634417399815874L;
        private Statistics delta;
        private double last = Double.NaN;
        private long lastAsLong;

        WithDelta(CharSequence charSequence, Statistics statistics) {
            super(charSequence);
            this.delta = statistics;
            statistics.decrementCountNaN();
        }

        @Override
        public void reset() {
            super.reset();
            this.delta.reset();
            this.delta.decrementCountNaN();
            this.last = Double.NaN;
            this.lastAsLong = 0L;
        }

        @Override
        public void accept(double d) {
            super.accept(d);
            this.delta.accept(d - this.last);
            this.last = d;
            this.lastAsLong = (long)d;
        }

        @Override
        public void accept(long l) {
            super.accept(l);
            if (this.last == (double)this.lastAsLong) {
                this.delta.accept(l - this.lastAsLong);
            } else {
                this.delta.accept((double)l - this.last);
            }
            this.last = l;
            this.lastAsLong = l;
        }

        @Override
        public void combine(Statistics statistics) throws ClassCastException {
            ArgumentChecks.ensureNonNull("stats", statistics);
            this.delta.combine(statistics.differences());
            super.combine(statistics);
            if (statistics instanceof WithDelta) {
                WithDelta withDelta = (WithDelta)statistics;
                this.last = withDelta.last;
                this.lastAsLong = withDelta.lastAsLong;
            } else {
                this.last = Double.NaN;
                this.lastAsLong = 0L;
            }
        }

        @Override
        public void scale(double d) {
            super.scale(d);
            this.delta.scale(d);
        }

        @Override
        final void decrementCountNaN() {
            super.decrementCountNaN();
            this.delta.decrementCountNaN();
        }

        @Override
        public Statistics differences() {
            return this.delta;
        }

        @Override
        public Statistics clone() {
            WithDelta withDelta = (WithDelta)super.clone();
            withDelta.delta = withDelta.delta.clone();
            return withDelta;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && this.delta.equals(((WithDelta)object).delta);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.delta.hashCode();
        }
    }
}

