/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.thumbnail;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.wcm.connector.collaboration.ThumbnailRESTService;

@Path(value="/thumbnailImage/")
public class CloudDriveThumbnailRESTService
extends ThumbnailRESTService {
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    protected final CloudDriveService cloudDrives;

    public CloudDriveThumbnailRESTService(RepositoryService repositoryService, ThumbnailService thumbnailService, NodeFinder nodeFinder, LinkManager linkManager, CloudDriveService cloudDrives) {
        super(repositoryService, thumbnailService, nodeFinder, linkManager);
        this.cloudDrives = cloudDrives;
    }

    @Path(value="/medium/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getThumbnailImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        if (this.accept(workspaceName, nodePath)) {
            return super.getThumbnailImage(repoName, workspaceName, nodePath, ifModifiedSince);
        }
        return this.ok();
    }

    @Path(value="/big/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getCoverImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        if (this.accept(workspaceName, nodePath)) {
            return super.getCoverImage(repoName, workspaceName, nodePath, ifModifiedSince);
        }
        return this.ok();
    }

    @Path(value="/large/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getLargeImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        if (this.accept(workspaceName, nodePath)) {
            return super.getLargeImage(repoName, workspaceName, nodePath, ifModifiedSince);
        }
        return this.ok();
    }

    @Path(value="/small/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getSmallImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        if (this.accept(workspaceName, nodePath)) {
            return super.getSmallImage(repoName, workspaceName, nodePath, ifModifiedSince);
        }
        return this.ok();
    }

    @Path(value="/custom/{size}/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getCustomImage(@PathParam(value="size") String size, @PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        if (this.accept(workspaceName, nodePath)) {
            return super.getCustomImage(size, repoName, workspaceName, nodePath, ifModifiedSince);
        }
        return this.ok();
    }

    @Path(value="/origin/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getOriginImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        if (this.accept(workspaceName, nodePath)) {
            return super.getOriginImage(repoName, workspaceName, nodePath, ifModifiedSince);
        }
        return this.ok();
    }

    protected boolean accept(String workspaceName, String nodePath) throws RepositoryException {
        return this.cloudDrives.findDrive(workspaceName, this.getNodePath(nodePath)) == null;
    }

    protected Response ok() {
        return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)DATE_FORMAT.format(new Date())).build();
    }

    private String getNodePath(String nodePath) {
        ArrayList<String> encodeNameArr = new ArrayList<String>();
        if (!nodePath.equals("/")) {
            for (String name : nodePath.split("/")) {
                if (name.length() <= 0) continue;
                encodeNameArr.add(Text.escapeIllegalJcrChars((String)name));
            }
            StringBuilder encodedPath = new StringBuilder();
            for (String encodedName : encodeNameArr) {
                encodedPath.append("/").append(encodedName);
            }
            nodePath = encodedPath.toString();
        }
        return nodePath;
    }
}

