/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.jpa.web.entity;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebParamsEntity;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebUsersEntity;

@Entity(name="NotificationsWebNotifEntity")
@ExoEntity
@Table(name="NTF_WEB_NOTIFS")
public class WebNotifEntity {
    @Id
    @Column(name="WEB_NOTIF_ID")
    @SequenceGenerator(name="SEQ_NTF_WEB_NOTIFS", sequenceName="SEQ_NTF_WEB_NOTIFS", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_NTF_WEB_NOTIFS")
    private long id;
    @Column(name="SENDER")
    private String sender;
    @Column(name="TYPE")
    private String type;
    @Column(name="CREATION_DATE")
    private Calendar creationDate;
    @Column(name="TEXT")
    private String text;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="webNotification")
    private Set<WebParamsEntity> parameters = new HashSet<WebParamsEntity>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="webNotification")
    private Set<WebUsersEntity> receivers = new HashSet<WebUsersEntity>();

    public long getId() {
        return this.id;
    }

    public String getSender() {
        return this.sender;
    }

    public WebNotifEntity setSender(String sender) {
        this.sender = sender;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public WebNotifEntity setType(String type) {
        this.type = type;
        return this;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public WebNotifEntity setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public WebNotifEntity setText(String text) {
        this.text = text;
        return this;
    }

    public Set<WebParamsEntity> getParameters() {
        return this.parameters;
    }

    public void setParameters(Set<WebParamsEntity> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(WebParamsEntity parameter) {
        this.parameters.add(parameter);
    }

    public void addReceiver(WebUsersEntity receiver) {
        this.receivers.add(receiver);
    }

    public Set<WebUsersEntity> getReceivers() {
        return this.receivers;
    }

    public void setReceivers(Set<WebUsersEntity> receivers) {
        this.receivers = receivers;
    }
}

