/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.DropTriggerStatement;
import java.util.ArrayList;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.structure.DatabaseObject;

public class DropTriggerGenerator
extends AbstractSqlGenerator<DropTriggerStatement> {
    @Override
    public boolean supports(DropTriggerStatement dropTriggerStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase);
    }

    @Override
    public ValidationErrors validate(DropTriggerStatement dropTriggerStatement, Database database, SqlGeneratorChain object) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkDisallowedField("catalogName", dropTriggerStatement.getCatalogName(), database, MSSQLDatabase.class);
        ((ValidationErrors)object).checkRequiredField("triggerName", dropTriggerStatement.getTriggerName());
        if (dropTriggerStatement.getScope() != null) {
            if (database instanceof MSSQLDatabase && !dropTriggerStatement.getScope().equalsIgnoreCase("CATALOG") && dropTriggerStatement.getScope().equalsIgnoreCase("TABLE")) {
                ((ValidationErrors)object).addError("Invalid dropTrigger scope " + dropTriggerStatement.getScope() + ". Possible values: CATALOG, TABLE");
            }
            if (database instanceof PostgresDatabase) {
                if (!dropTriggerStatement.getScope().equalsIgnoreCase("CASCADE") && !dropTriggerStatement.getScope().equalsIgnoreCase("RESTRICT")) {
                    ((ValidationErrors)object).addError("Invalid dropTrigger scope " + dropTriggerStatement.getScope() + ". Possible values: CASCADE , RESTRICT ");
                }
                ((ValidationErrors)object).checkRequiredField("tableName", dropTriggerStatement.getTableName());
            }
        }
        return object;
    }

    @Override
    public Sql[] generateSql(DropTriggerStatement dropTriggerStatement, Database database, SqlGeneratorChain object) {
        object = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        String string = database.escapeObjectName(dropTriggerStatement.getCatalogName(), dropTriggerStatement.getSchemaName(), dropTriggerStatement.getTriggerName(), Trigger.class);
        stringBuilder.append("DROP TRIGGER ");
        if (database instanceof MSSQLDatabase && dropTriggerStatement.getScope() != null && dropTriggerStatement.getScope().equalsIgnoreCase("CATALOG")) {
            string = database.escapeObjectName(dropTriggerStatement.getTriggerName(), Trigger.class);
            string = String.format("%s ON DATABASE", string);
        }
        if (database instanceof PostgresDatabase) {
            String string2;
            string = database.escapeObjectName(dropTriggerStatement.getTriggerName(), Trigger.class);
            String string3 = database.escapeObjectName(dropTriggerStatement.getTableName(), Trigger.class);
            String string4 = database.escapeObjectName(dropTriggerStatement.getSchemaName(), Trigger.class);
            if (string4 == null || string4.isEmpty()) {
                string4 = database.getDefaultSchemaName();
            }
            if ((string2 = database.escapeObjectName(dropTriggerStatement.getScope(), Trigger.class)) == null) {
                string2 = "";
            }
            string = String.format("%s ON %s.%s %s", string, string4, string3, string2);
        }
        stringBuilder.append(string);
        object.add(new UnparsedSql(stringBuilder.toString(), new DatabaseObject[0]));
        CreateProcedureGenerator.surroundWithSchemaSets((List<Sql>)object, dropTriggerStatement.getSchemaName(), database);
        return object.toArray(new Sql[0]);
    }
}

